import { Component, ViewChild } from '@angular/core';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatSidenav } from '@angular/material/sidenav';
import { Router } from '@angular/router';
import { UserManagementService } from 'app/services/user-management.service';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { saveAs } from 'file-saver';
import { MatSort } from '@angular/material/sort';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import moment from 'moment';
export interface PeriodicElement {
  name: string;
  position: number;
  weight: number;
  symbol: string;
}
@Component({
  selector: 'app-collaborator',
  templateUrl: './collaborator.component.html',
  styleUrls: ['./collaborator.component.scss']
})
export class CollaboratorComponent {
  @ViewChild('sidenav') sidenav: MatSidenav;
  @ViewChild('paginator1') paginator1: MatPaginator;
  @ViewChild('paginator2') paginator2: MatPaginator;
  @ViewChild('paginator3') paginator3: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  searchTerm: string = '';
  dataSource1 = new MatTableDataSource<any>([]);
  dataSource2 = new MatTableDataSource<any>([]);
  dataSource3 = new MatTableDataSource<any>([]);
  type = 'All'
  // ... existing code ...
  selectedRows: any[] = [];
  showFiller: boolean = false;
  row: any;
  selectedData: any
  data: any;
  displayedColumns: string[] = ['selector','id', 'name', 'mobile', 'city', 'email','status','test','createdAt', 'action'];
  collaborators: any;
  collaboratorsTable: MatTableDataSource<any>;
  constructor(
    private userManagementService: UserManagementService,
    private router: Router,
    private snackBar: MatSnackBar,
    private dialog : MatDialog,
    private loader : LoaderService,
    private _snackBar: MatSnackBar,
  ) {
    this.getCollaborators('All')
  }
  exportCollaboratorsToCSV() {
    let selectedData;

    if (this.type === 'All') {
      selectedData = this.dataSource1.data.filter(item => item.selected);
    } else if (this.type === 'Veterinary') {
      selectedData = this.dataSource2.data.filter(item => item.selected);
    } else if (this.type === 'Groomers') {
      selectedData = this.dataSource3.data.filter(item => item.selected);
    }

    if (selectedData.length === 0) {
      this.showSnackbar('No rows selected!');
      return;
    }

    const csvData = selectedData.map(item => ({
      id: item.id,
      name: item.collaboratorName,
      mobile: item.mobile,
      city: item.city,
      joinedDate: this.currentUTCDate(item.createdAt),
      email: item.email
    }));

    const csvContent = this.convertToCSV(csvData);
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8' });
    saveAs(blob, 'collaborators.csv');
  }
  convertToCSV(data: any[]): string {
    const header = Object.keys(data[0]).join(',');
    const rows = data.map(item => Object.values(item).join(','));
    return `${header}\n${rows.join('\n')}`;
  }
  showSnackbar(message: string) {
    // Implement your Snackbar logic here
    alert(message);
  }
  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  ngAfterViewInit() {
    this.dataSource1.paginator = this.paginator1;
    this.dataSource2.paginator = this.paginator2;
    this.dataSource3.paginator = this.paginator3;
    
    // this.dataSource3.paginator = this.paginator1;
    // this.collaboratorsTable.paginator = this.paginator;
    // this.collaboratorsTable.sort = this.sort; // Add this line to enable sorting
  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY hh:mm A");
  }
  getCollaborators(type: string) {
    console.log(type);
    this.loader.showLoader();
    this.userManagementService.getCollaboratorsByType(type).subscribe((res: Array<any>) => {
      this.loader.hideLoader();
      res.forEach((el) => {
        // console.log(el['name']);
        el['collaboratorName'] = el['collaboratorName'] ? el['collaboratorName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      })
      this.data = res;
      if (type == 'All') {
        this.dataSource1 = new MatTableDataSource(res);
        this.dataSource1.paginator = this.paginator1;
        this.dataSource1.sort = this.sort;
      } else if (type == 'Veterinary') {
        this.dataSource2 = new MatTableDataSource(res);
        this.dataSource2.paginator = this.paginator2;
        this.dataSource2.sort = this.sort;
      } else if (type == 'Groomers') {
        this.dataSource3 = new MatTableDataSource(res);
        this.dataSource3.paginator = this.paginator3;
        this.dataSource3.sort = this.sort;
      }

      // this.collaboratorsTable.filterPredicate = this.createFilter(); // Add this line to enable custom filtering
    });
  }

  selectAll(event: any) {
    const checked = event.checked;
    let dataSource;

    if (this.type === 'All') {
      dataSource = this.dataSource1.data;
    } else if (this.type === 'Veterinary') {
      dataSource = this.dataSource2.data;
    } else if (this.type === 'Groomers') {
      dataSource = this.dataSource3.data;
    }

    dataSource.forEach(item => {
      item.selected = checked;
    });
  }

  createFilter(): (data: any, filter: string) => boolean {
    let filterFunction = function (data, filter): boolean {
      const searchTerms = filter.split(' ').map((term) => term.toLowerCase());
      for (const searchTerm of searchTerms) {
        if (
          data.collaboratorName.toLowerCase().indexOf(searchTerm) !== -1 ||
          data.id.toLowerCase().indexOf(searchTerm) !== -1 ||
          data.mobile.toLowerCase().indexOf(searchTerm) !== -1
        ) {
          return true;
        }
      }
      return false;
    };
    return filterFunction;
  }
  tabClick(tab) {
    console.log(tab['tab']['textLabel']);
    this.type = tab['tab']['textLabel'];
    this.getCollaborators(this.type);

    this.userManagementService.getCollaboratorsByType(tab['tab']['textLabel']).subscribe((res: Array<any>) => {
      res.forEach((el) => {
        // console.log(el['name']);
        el['collaboratorName'] = el['collaboratorName'] ? el['collaboratorName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      })
      console.log(res);
      this.data = res
      if (tab['tab']['textLabel'] == 'All') {
        const dataSource1 = Object.values(res);
        this.dataSource1 = new MatTableDataSource(
          dataSource1.map((item: any) => ({ ...item }))
        );
        this.dataSource1.paginator = this.paginator1;
        this.dataSource1.sort = this.sort; // Add this line to enable sorting
      } else if (tab['tab']['textLabel'] == 'Veterinary') {
        const dataSource2 = Object.values(res);
        this.dataSource2 = new MatTableDataSource(
          dataSource2.map((item: any) => ({ ...item }))
        );
        this.dataSource2.paginator = this.paginator2;
        this.dataSource2.sort = this.sort;
      }else if(tab['tab']['textLabel'] == 'Groomers'){
        const dataSource1 = Object.values(res);
        this.dataSource3 = new MatTableDataSource(
          dataSource1.map((item: any) => ({ ...item }))
        );
        this.dataSource3.paginator = this.paginator3;
        this.dataSource3.sort = this.sort;
      }
    })
  }

  addCollaborator() {
    // 'petParent/addUser'
    this.router.navigate(['/user/collaborator/addCollaborator'])

  }
  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  editUser() {
    this.row = this.selectedData;
    this.showFiller = true;
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    
    // return this.selectedData
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }
  deleteUser() {
    // this.menuTrigger.closeMenu();
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.userManagementService.deleteCollaborator( this.selectedData['id']).subscribe((res) => {
          this.loader.hideLoader();
          this.getCollaborators('All');
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Collaborator deleted successfully! ',success : true },
            panelClass: 'success-dialog-container'
          }); 
        }, (error) => {
          this.loader.hideLoader();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Something Went Wrong!',success : false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
  }
  cancel() {
    this.getCollaborators(this.type);
    this.sidenav.toggle();
  }

  toggle(element) {
    // drawer.toggle()
    this.row = element;
    this.showFiller = !this.showFiller;

  }

  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    // if(this.type == 'All'){
    //   this.dataSource1.filter = this.searchTerm.trim().toLowerCase();
    // }else if(this.type == 'Veterinary'){
    //   this.dataSource2.filter = this.searchTerm.trim().toLowerCase();
    // }else if(this.type == 'Groomers'){
    //   this.dataSource3.filter = this.searchTerm.trim().toLowerCase();
    // }
    const filterValue = this.searchTerm.trim().toLowerCase();
    this.dataSource1.filter = filterValue;
    this.dataSource2.filter = filterValue;
    this.dataSource3.filter = filterValue;
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
  testChange(event, element){
    this.loader.showLoader()
    this.userManagementService.testChange(event['checked']?'Active' : 'InActive',event['checked'],element['id'],).subscribe((res)=>{
      this.loader.hideLoader()
      this.showSuccessToast('Successfully Done')
    },(error)=>{
      this.loader.hideLoader()
      this.showErrorToast('Failed ...')
    }
    )
  }

}
