import { Component, Input, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { AppointmentManagementService } from 'app/services/appointment-management.service';
import moment from 'moment';

@Component({
  selector: 'app-appointments',
  templateUrl: './appointments.component.html',
  styleUrls: ['./appointments.component.scss']
})
export class AppointmentsComponent {
  @Input() petId : string = '';
  displayedColumns: string[] = [
    'id',
    'collaboratorName',
    'serviceName',
    'city',
    'type',
    'workspaceName',
    'appointmentDate',
    'status',
    'action',
];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  appointments: MatTableDataSource<any>;
  constructor(
    private appointmentManagementService : AppointmentManagementService,
    private router :Router
  ){

  }

  ngOnInit(){
    this.getAppointments(this.petId)
  }

  ngAfterViewInit() {
    this.appointments.paginator = this.paginator;
  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY hh:mm A");
}

  getAppointments(petId){
    this.appointmentManagementService.getAppointmentByPetId(petId).subscribe((res : Array<any>)=>{
      console.log(res);
      const appointmentArray = Object.values(res);
      this.appointments = new MatTableDataSource(
        appointmentArray.map((item: any) => ({ ...item}))
      );
      this.appointments.paginator = this.paginator;
      this.appointments.sort = this.sort;
      
    })
  }

  view(i,element){
    this.router.navigate(['/appointment'], {queryParams : {appointMentId : element['id']}});
  }

}
