import { Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { Controller } from 'app/interfaces/controller';
import { UserManagementService } from 'app/services/user-management.service';
import { EditPetComponent } from '../edit-pet/edit-pet.component';
import { UserActivityHistoryComponent } from '../user-activity-history/user-activity-history.component';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ValidationsService } from 'app/services/validations.service';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { MatMenuTrigger } from '@angular/material/menu';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { AddAddressPetParentComponent } from '../add-address-pet-parent/add-address-pet-parent.component';


@Component({
  selector: 'app-add-user',
  templateUrl: './add-user.component.html',
  styleUrls: ['./add-user.component.scss']
})
export class AddUserComponent {
  addressForm: FormGroup;
  userForm: FormGroup;
  controllers: any;
  pets: any
  pet;
  isThereActivities: boolean = false;
  row;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  displayedColumns: string[] = ['id', 'petName', 'type', 'breed', 'gender', 'action'];
  constructor(private fb: FormBuilder,
    private userManagementService: UserManagementService,
    private router: Router,
    public dialog: MatDialog,
    private snackBar: MatSnackBar,
    private validationsService: ValidationsService,
    private loader: LoaderService
  ) {
    this.addressForm = this.fb.group({
      addresses: this.fb.array([])
    });
    this.createForm()
    this.craeteFormControllers()
  }
  ngOnInit() {
    

  }
  ngOnChanges() {
    if (this.editData) {
      this.getPets();
      this.getAddresses();
      console.log("a");
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }
  }
  createForm() {
    this.userForm = this.fb.group({
      name: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: ['', [Validators.required, this.validationsService.emailValidator()]],
      phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
      gender: ['', Validators.required],
      city: ['', [Validators.required, this.validationsService.cityValidation()]],
      location: ['', [Validators.required, this.validationsService.locationValidator()]],
      profileImage: [null, Validators.required],
      internalNotes: [null]
    })

  }

  get addresses(): FormArray {
    return this.addressForm.get('addresses') as FormArray;
  }

  createAddress(): FormGroup {
    return this.fb.group({
      type : [''],
      flatNo :[''],
      address: ['', Validators.required],
      city: ['', Validators.required],
      pincode: ['', Validators.required],
      location: ['', Validators.required],
      state: ['', Validators.required]
    });
  }

  addAddress() {
    const dialogRef = this.dialog.open(AddAddressPetParentComponent, {
      // width: '300px'
      data: {petParentId: this.editData['id'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.addresses.push(this.fb.group(result));
        this.getAddresses();
      }
    });
  }

  removeAddress(index: number,address) {
    this.userManagementService.deleteAddress(this.editData['id'],address.get('id').value).subscribe((res)=>{
      this.addresses.removeAt(index);
      this.getAddresses();
    })

    
  }

  updateAddress(index: number, address: FormGroup) {
    const dialogRef = this.dialog.open(AddAddressPetParentComponent, {
      // width: '300px'
      data: {petParentId: this.editData['id'],formGroup : address, id : address.get('id').value }
    });

    dialogRef.afterClosed().subscribe(result => {
      this.getAddresses();
      if (result) {
      }
    });
  }

  onSubmit() {
    console.log(this.addressForm.value);
  }

  getPets() {
    if (this.editData) {

      this.loader.showLoader()
      this.userManagementService.getAllPetsByPetParent(this.editData['id']).subscribe((res: Array<any>) => {
        console.log(res);
        this.loader.hideLoader();
        const petsArray = Object.values(res);
        this.pets = new MatTableDataSource(
          petsArray.map((item: any) => ({ ...item }))
        );
      })
    }
  }

  getAddresses(){
    this.addresses.clear();
    this.userManagementService.getAddressesOfPet(this.editData['id']).subscribe((res : Array<any>)=>{
      res.forEach((el)=>{
        this.addresses.push(this.fb.group({
          id : [el.id],
          type : [el.type],
          flatNo :[el.flatNo],
          address: [el.address, Validators.required],
          city: [el.city, Validators.required],
          pincode: [el.pincode, Validators.required],
          location: [el.latitude + ',' + el.longitude, Validators.required],
          state: [el.state, Validators.required]
        }))
      })
      console.log(res);
    })
  }

  activityHistory() {
    this.loader.showLoader();
    this.userManagementService.getAppointmentsHistoryByPetParentId(this.pet['id']).subscribe((res: Array<any>) => {
      this.loader.hideLoader();
      if (res.length > 0) {
        this.isThereActivities = false;
      } else {
        this.isThereActivities = true;
      }
      let dialogRef = this.dialog.open(UserActivityHistoryComponent, {
        data: { editData: res },
        width : '500px'
      });
      dialogRef.afterClosed().subscribe(result => {
        console.log('The dialog was closed');
      });
    })
  }

  toggle(i, element) {
    // this.getPets();
    console.log(i);
    this.pet = element;
    
    this.userManagementService.getAppointmentsHistoryByPetParentId(this.pet['id']).subscribe((res: Array<any>) => {
      if (res.length > 0) {
        this.isThereActivities = true;
      } else {
        this.isThereActivities = false;
      }
    })

  }

  addPet() {
    sessionStorage.setItem('petParentId', this.editData['id']);
    this.router.navigate(['/user/pet/addPet']);

  }
  view() {
    sessionStorage.setItem('petId', this.pet['id'])
    sessionStorage.setItem('petParentId', this.editData['id']);
    this.router.navigate(['/user/pet/editPet']);
    // this.router.navigateByUrl('/user/pet/editPet',{state : {data : { editData: this.pet, petParentId: this.editData['id'] }}})
  }

  editPet() {
    console.log("hurry");

    // let dialogRef = this.dialog.open(EditPetComponent, {
    //   data: { editData: this.pet, petParentId: this.editData['id'] },
    //   width: '700px'
    // });
    // dialogRef.afterClosed().subscribe(result => {
    //   this.getPets();
    //   console.log('The dialog was closed');
    // });
  }



  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  deletePet() {
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.userManagementService.deletePet(this.pet['id']).subscribe((res) => {
          this.loader.hideLoader();
          console.log(res);
          this.getPets();
        }, (error) => {
          this.loader.hideLoader()
          console.error(error);
        })

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }


  edit() {
    console.log(this.editData);
    this.userForm = this.fb.group({
      name: [this.editData['name'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: [this.editData['email'], [Validators.required, this.validationsService.emailValidator()]],
      phone: [this.editData['mobile'], [Validators.required, this.validationsService.mobileNumberValidator()]],
      gender: [this.editData['gender'], Validators.required],
      city: [this.editData['city'], Validators.required],
      profileImage: [this.editData['profileImage'],Validators.required],
      location: [this.editData['latitude'] + ',' + this.editData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
      internalNotes: [null]
    })
    this.userForm.get('profileImage').setValue(this.editData['profileImage'])
  }

  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "userName",
        name: 'name',
        label: "Name",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      email: {
        id: "userName",
        name: 'email',
        label: "Email",
        required: true,
        placeholder: "Enter Email",
        type: "email"
      },
      phone: {
        id: "phone",
        name: 'phone',
        label: "Phone",
        required: true,
        placeholder: "Enter Mobile No.",
        type: "text"
      },
      location: {
        id: "location",
        name: 'location',
        label: "Location",
        required: true,
        placeholder: "0.0,0.0",
        type: "text"
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        options: [
          {
            name: "Male",
            value: "Male"
          },
          {
            name: "Female",
            value: "Female"
          }

        ],
        type: "radio"
      },
      city: {
        id: "city",
        name: 'city',
        label: "City",
        required: true,
        placeholder: "Enter city",
        type: "text"
      },
      profileImage: {
        id: "profileImage",
        name: 'profileImage',
        label: "Upload Image*",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true,
      },
      address:{
        type :{
          id: "type",
          name: 'type',
          label: "Type",
          required: true,
          placeholder: "",
          type: "radio",
          options: [
            {
              name: 'Home',
              value: 'Home'
            },
            {
              name: 'Work',
              value: 'Work'
            },
            {
              name: 'Hotel',
              value: 'Hotel'
            },
            {
              name : 'Other',
              value : 'Other'
            }
          ]
        },
        flatNo :{
          id: "flatNo",
          name: 'flatNo',
          label: "Flat No",
          required: true,
          placeholder: "Enter Flat No",
          type: "text"
        },
        address:{
          id: "address",
          name: 'address',
          label: "Address",
          required: true,
          placeholder: "Enter Address",
          type: "text"
        },
        pincode :{
          id: "Pincode",
          name: 'Pincode',
          label: "Pincode",
          required: true,
          placeholder: "Enter Pincode",
          type: "text"
        },
        city:{
          id: "city",
          name: 'city',
          label: "City",
          required: true,
          placeholder: "Enter city",
          type: "text"
        },
        location:{
          id: "location",
          name: 'location',
          label: "location",
          required: true,
          placeholder: "Enter Location",
          type: "text"
        }
      }
    }
  }
  uploadProfile(event) {
    if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.addPetParentProfileImage(this.editData['id'], this.userForm.get('profileImage').value).subscribe((res) => {
        console.log(res);
        this.loader.hideLoader();
      })
    }
  }
  addUser() {
    let json = this.userForm.value
    //   {
    //     "countryCode": "+91",
    //     "mobile": "8290444559",
    //     "name": "Angular",
    //     "email": "angular@gmail.co",
    //     "verified": false,
    //     "emailVerified": false,
    //     "city": "pune",
    //     "gender": "Male",
    //     "sos": false,
    //     "sosTill": "",
    //     "latitude": "01.110",
    //     "longitude": "10.0111",
    //     "status": "Created"
    // }
    let body = {
      "countryCode": "+91",
      "mobile": json['phone'],
      "name": json['name'],
      "email": json['email'],
      "verified": false,
      "emailVerified": false,
      "city": json['city'],
      "gender": json['gender'],
      "sos": false,
      "sosTill": "",
      "latitude": json['location'].split(",")[0].trim(),
      "longitude": json['location'].split(",")[1].trim(),
      "status": "Created"
    }
    if (this.editData) {
      body['id'] = this.editData['id']
      this.loader.showLoader();
      this.userManagementService.updatePetParent(body).subscribe((res) => {
        this.loader.hideLoader();
        // this.userManagementService.addPetParentProfileImage(res['id'], json['coverImage']).subscribe((res) => {
        console.log(res);
        this.userManagementService.getPetParents(1).subscribe((res) => {
          this.cancel()
          this.router.navigate(['/user/pet']);
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'User updated successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
      }, (error) => {
        this.loader.hideLoader();
        console.error(error);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: error.error.message, success: false }
        });
        // })
      })
    } else {
      this.loader.showLoader();
      this.userManagementService.addPetParent(body).subscribe((res) => {
        // this.userManagementService.addPetParentProfileImage(res['id'], this.userForm.get('profileImage').value).subscribe((res) => {
        console.log(res);
        this.userManagementService.getPetParents(1).subscribe((res) => {
          this.loader.hideLoader();
          this.router.navigate(['/user/pet'])
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'User created successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
        // })
      }, (error) => {
        this.loader.hideLoader();
        console.error(error);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: error.error.message, success: false }
        });
      }
      )
    }
  }

  cancel() {
    this.getPets()
    this.cancelEvent.emit()
    this.router.navigate(['/user/pet'])
  }
  


}

