import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { LoaderService } from 'app/services/loader.service';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-user-view-mode',
  templateUrl: './add-user-view-mode.component.html',
  styleUrls: ['./add-user-view-mode.component.scss']
})
export class AddUserViewModeComponent {
  @Input() viewData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  displayedColumns: string[] = ['id', 'petName', 'type', 'breed', 'gender', 'action'];
  constructor(private fb: FormBuilder,
    private userManagementService: UserManagementService,
    private router: Router,
    public dialog: MatDialog,
    private snackBar: MatSnackBar,
    private validationsService: ValidationsService,
    private loader: LoaderService
  ) {
  }

  form: FormGroup;

  ngOnInit() {
    this.form = this.fb.group({
      id: [{value: '', disabled: true}],
      name: [{value: '', disabled: true}],
      joinedDate: [{value: '', disabled: true}],
      city: [{value: '', disabled: true}],
      mobile: [{value: '', disabled: true}],
      countryCode: [{value: '', disabled: true}],
      email: [{value: '', disabled: true}],
      gender: [{value: '', disabled: true}],
      sos: [{value: false, disabled: true}],
      latitude: [{value: '', disabled: true}],
      longitude: [{value: '', disabled: true}],
      status: [{value: '', disabled: true}],
      profileImage: [{value: '', disabled: true}],
      test: [{value: false, disabled: true}],
      verified: [{value: false, disabled: true}],
      emailVerified: [{value: false, disabled: true}]
    });

    const userData = this.viewData

    this.form.patchValue(userData);
  }

  edit(){

  }
  close(){
    this.cancelEvent.emit();
  }

  

}
