import { Component, Inject } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-reminder',
  templateUrl: './add-reminder.component.html',
  styleUrls: ['./add-reminder.component.scss']
})
export class AddReminderComponent {
  form: FormGroup;
  controlls: any;
  constructor(
    public dialogRef: MatDialogRef<AddReminderComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private validationsService: ValidationsService,

    private fb: FormBuilder,
    private loader: LoaderService,
    private petService: PetService
  ) {
    this.createControlls();
    this.createForm();
  }

  ngOnInit() {
    if (this.data['record']) {
      this.edit()

    }
    if(this.form.get('repeate').value == 'Never'){
      this.form.get('workSpaceTimings').clearValidators();
        this.form.get('workSpaceTimings').updateValueAndValidity()
    }
    this.form.get('repeate').valueChanges.subscribe((chnage) => {
      if (chnage == 'Never') {
        this.form.get('workSpaceTimings').clearValidators();
        this.form.get('workSpaceTimings').updateValueAndValidity()
      } else {
        this.form.get('workSpaceTimings').setValidators(this.validationsService.atLeastOneSelectedValidator());
        this.form.get('workSpaceTimings').updateValueAndValidity()

      }
      this.allDaysValuechanges(chnage);
    })


    const daysGroup = this.form.get('workSpaceTimings') as FormGroup;
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allDaysSelected = this.weekdays.filter(day => daysGroup.get(day).value === false);
        if (allDaysSelected.length > 0 && this.form.get('repeate').value == 'Daily' && key === 'Sun') {
          this.form.get('repeate').setValue('Custom');
        }
      });
    });

  }

  edit() {
    let el = this.data['record']
    this.form = this.fb.group({
      id: [el['id']],
      reminderTitle: [el['title'], Validators.required],
      description: [el['description']],
      date: [new Date(el['reminderTime']), Validators.required],
      endDate: [new Date(el['endDate']), Validators.required],
      time: [this.formatTime(el['reminderTime']), Validators.required],
      repeate: [!el['repeat'] ? 'Never' : el['data']['repeatTime'], Validators.required],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: [''],
        // all : ['']

      }, { validator: this.validationsService.atLeastOneSelectedValidator() }),

    })
    if(this.form.get('repeate').value == 'Never'){
      this.form.get('workSpaceTimings').clearValidators();
        this.form.get('workSpaceTimings').updateValueAndValidity()
    }
    el['data']['days'].forEach((day) => {
      if (day == "Mon") {
        this.form.get('workSpaceTimings').get('Mon').setValue(true)
      }
      if (day == "Tue") {
        this.form.get('workSpaceTimings').get('Tue').setValue(true)
      }
      if (day == "Wed") {
        this.form.get('workSpaceTimings').get('Wed').setValue(true)
      }
      if (day == "Thu") {
        this.form.get('workSpaceTimings').get('Thu').setValue(true)
      }
      if (day == "Fri" || day == "fri") {
        this.form.get('workSpaceTimings').get('Fri').setValue(true)
      }
      if (day == "Sat") {
        this.form.get('workSpaceTimings').get('Sat').setValue(true)
      }
      if (day == "Sun") {
        this.form.get('workSpaceTimings').get('Sun').setValue(true)
      }
    })
  }

  changeVal(e: any): void {
    this.form.get('repeate').setValue('Custom');

  }

  createForm() {
    this.form = this.fb.group({
      reminderTitle: ['', Validators.required],
      description: [''],
      date: ['', Validators.required],
      endDate: ['', Validators.required],
      time: ['', Validators.required],
      repeate: ['', Validators.required],
      workSpaceTimings: this.fb.group({
        Mon: [false],
        Tue: [false],
        Wed: [false],
        Thu: [false],
        Fri: [false],
        Sat: [false],
        Sun: [false],
        // all : ['']

      }, { validator: this.validationsService.atLeastOneSelectedValidator() }),

    })
  }
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];

  allDaysValuechanges(chnage) {

    // this.formGroup.get('addDays').valueChanges.subscribe((chnage)=>{
    if (chnage == 'Daily') {
      this.weekdays.forEach((day) => {
        this.form.get('workSpaceTimings').get(day).setValue(true)
      })
    } else if (chnage == 'Never') {
      this.weekdays.forEach((day) => {
        this.form.get('workSpaceTimings').get(day).setValue(false)
      })
    }
    // })
  }

  createControlls() {
    this.controlls = {
      reminderTitle: {
        id: "reminderTitle",
        name: 'reminderTitle',
        label: "Reminder Title",
        placeholder: "Enter Reminder Title",
        required: true,

        type: "toggle"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description",
        placeholder: "Enter Description",
        required: true,

        type: "toggle"
      },
      date: {
        id: "date",
        name: 'date',
        label: "Start Date",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      endDate: {
        id: "endDate",
        name: 'endDate',
        label: "End Date",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      time: {
        id: "time",
        name: 'time',
        label: "Time*",
        placeholder: "Select Time",
        required: true,
        type: "Date"
      },
      repeate: {
        id: "repeate",
        name: 'repeate',
        label: "Repeat",
        placeholder: "",
        required: true,
        type: "Date",
        options: [
          {
            name: 'Never',
            value: 'Never'
          },
          {
            name: 'Daily',
            value: 'Daily'
          },
          {
            name: 'Custom',
            value: 'Custom'
          },
        ],
      },
      addDays: {
        id: "addDays",
        name: "addDays",
        label: "All Days",
      },
      workSpaceTimings: {
        Mon: {
          id: "Mon",
          name: 'Mon',
          label: "Mon",
          required: true,
          type: "checkbox"
        },
        Tue: {
          id: "Tue",
          name: 'Tue',
          label: "Tue",
          required: true,
          type: "checkbox"
        },
        Wed: {
          id: "Wed",
          name: 'Wed',
          label: "Wed",
          required: true,
          type: "checkbox"
        },
        Thu: {
          id: "Thu",
          name: 'Thu',
          label: "Thu",
          required: true,
          type: "checkbox"
        },
        Fri: {
          id: "Fri",
          name: 'Fri',
          label: "Fri",
          required: true,
          type: "checkbox"
        },
        Sat: {
          id: "Sat",
          name: 'Sat',
          label: "Sat",
          required: true,
          type: "checkbox"
        },
        Sun: {
          id: "Sun",
          name: 'Sun',
          label: "Sun",
          required: true,
          type: "checkbox"
        },
        // all: {
        //   id: "all",
        //   name: 'all',
        //   label: "All Days",
        //   required: true,
        //   type: "checkbox"
        // }

      },

    }
  }

  onNoClick(): void {
    this.dialogRef.close();
  }

  async add() {
    // (this.data['remindersArray'] as FormArray).push(this.form);
    let json = this.form.value;
    console.log(this.convertTimeToMilliseconds());
    let data = {
      title: json['reminderTitle'],
      description: json['description'],
      reminderTime: this.convertTimeToMilliseconds(),
      endDate: new Date(json['endDate']).getTime(),
      userId: sessionStorage.getItem('petParentId'),
      repeat: json['repeate'] == 'Never' ? false : true,
      data: json['repeate'] !== 'Never' ? {
        repeatTime: json['repeate'],
        days: [],
      } : {},
      petId: sessionStorage.getItem('petId'),
    }
    Object.keys(json['workSpaceTimings']).forEach(key => {
      if (json['workSpaceTimings'][key] == true) {
        data['data']['days'].push(key);
      }
    })
    // this.dialogRef.close();
        // this.petService.getReminders(sessionStorage.getItem('petParentId')).subscribe((res) => {
    //   debugger
    //   console.log(res);
    //   this.loader.hideLoader();
    //   this.dialogRef.close()
    // }, (error => {
    //   this.loader.hideLoader();
    // }))
    if (this.data['record']) {
      this.loader.showLoader()
      data['id'] = this.data['record']['id'];
      this.petService.editReminder(data).subscribe((res) => {
        console.log("res", res);
        
        this.loader.hideLoader();
        this.dialogRef.close()
        
      }, (error) => {
        this.loader.hideLoader();
        this.dialogRef.close()
      })


    } else {
      this.loader.showLoader()
      this.petService.addReminders(data).subscribe((res) => {
        this.dialogRef.close()
        // this.petService.getReminders(sessionStorage.getItem('petParentId')).subscribe((res) => {
        //   console.log(res);
        //   this.loader.hideLoader();
        //   this.dialogRef.close()
        // }, (error => {
        //   this.loader.hideLoader();
        // }))
        this.loader.hideLoader();
        this.dialogRef.close()
      }, (error) => {
        this.loader.hideLoader();
        this.dialogRef.close()
      }
      )
    }
  }

  convertTimeToMilliseconds() {
    const reminderTime = new Date(this.form.get('date').value);
    const time = this.form.get('time').value.toString();

    const [timePart, period] = time.split(" "); // Split time into time and period (AM/PM)
    const [hours, minutes] = timePart.split(":").map(Number); // Split hours and minutes

    let adjustedHours = hours;

    // Adjust hours based on AM/PM
    if (period === 'PM' && hours < 12) {
        adjustedHours += 12; // Convert PM hours to 24-hour format
    } else if (period === 'AM' && hours === 12) {
        adjustedHours = 0; // Handle 12 AM (midnight)
    }

    // Set the hours and minutes
    reminderTime.setHours(adjustedHours);
    reminderTime.setMinutes(minutes);

    return reminderTime.getTime();
}


  formatTime(date) {
    date = new Date(date);
    let hours = date.getHours();
    let minutes = date.getMinutes();
    const ampm = hours >= 12 ? 'PM' : 'AM';

    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    minutes = minutes < 10 ? '0' + minutes : minutes;

    const timeString = `${hours}:${minutes} ${ampm}`;
    return timeString;
  }

  onUpload(event) {
    this.form.get('document').setValue(event)
  }

}
