import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { AdoptionManagementService } from 'app/services/adoption-management.service';
import { LoaderService } from 'app/services/loader.service';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-pet',
  templateUrl: './add-pet.component.html',
  styleUrls: ['./add-pet.component.scss']
})
export class AddPetComponent {
  form: FormGroup;
  controllers: any;
  @Input() petParentId: string;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  constructor(private fb: FormBuilder,
    private userManagementService: UserManagementService,
    private adoptionManagementService: AdoptionManagementService,
    private router: Router,
    private snackBar: MatSnackBar,
    private validationsService: ValidationsService,
    private dialog: MatDialog,
    private loader: LoaderService
  ) {
    this.form = this.fb.group({
      name: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: ['', Validators.required],
      breed: ['', Validators.required],
      month: [0, [Validators.required, Validators.min(0), Validators.max(12)]],
      year: [0, [Validators.required, Validators.min(0)]],
      age: ['',],//[Validators.required,Validators.pattern('^[0-9]+$')]x
      gender: ['', Validators.required],
      image: [null, Validators.required],
      weight: [null], //weight color coatLength neutered bloodType temperament trainingLevel allergies marks
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null]
    })
    this.craeteFormControllers()
  }
  ngOnInit() {
    console.log(this.editData);
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }

    this.onSpeciesChange();
  }
  ngOnChanges() {

  }
  onSpeciesChange() {
    this.form.get('species').valueChanges.subscribe((change) => {
      console.log("chnage", change);

      this.controllers['bloodType']['options'] = new Array();
      this.controllers['color']['options'] = new Array();
      this.controllers['temperament']['options'] = new Array();
      this.controllers['breed']['options'] = new Array();
      this.adoptionManagementService.getBreeds(change).subscribe((res: Array<any>) => {
        console.log(res);
        res.forEach(el => {
          this.controllers['breed']['options'].push({//options
            name: el,
            value: el
          })
        });
        // this.form.get('breed').setValue(this.controllers['breed']['options'][0].value)
      })

      if (change == 'dog') {
        this.controllers['bloodType']['options'] = [
          {
            name: 'DEA 1.1 (positive or negative)',
            value: 'DEA 1.1 (positive or negative)'
          },
          {
            name: 'DEA 3',
            value: 'DEA 3'
          },
          {
            name: 'DEA 4',
            value: 'DEA 4'
          },
          {
            name: 'DEA 5',
            value: 'DEA 5'
          },
          {
            name: 'DEA 6',
            value: 'DEA 6'
          },
          {
            name: 'DEA 7',
            value: 'DEA 7'
          },
          {
            name: 'DEA 8',
            value: 'DEA 8'
          },

        ];
        this.controllers['color']['options'] = [
          {
            name: 'Black',
            value: 'Black'
          },
          {
            name: 'Brown',
            value: 'Brown'
          },
          {
            name: 'White',
            value: 'White'
          },
          {
            name: 'Golden',
            value: 'Golden'
          },
          {
            name: 'Grey',
            value: 'Grey'
          },
          {
            name: 'White and black',
            value: 'White and black'
          },
          {
            name: 'White and brown',
            value: 'White and brown'
          },
          {
            name: 'Black and brown',
            value: 'Black and brown'
          },
          {
            name: 'Black, white and brown',
            value: 'Black, white and brown'
          }
        ];
        this.controllers['temperament']['options'] = [
          { name: 'Friendly', value: 'Friendly' },
          { name: 'Not friendly', value: 'Not friendly' },
          { name: 'Reserved', value: 'Reserved' },
          { name: 'Anxious', value: 'Anxious' },
          { name: 'Fearful', value: 'Fearful' },
          { name: 'Reactive', value: 'Reactive' },
          { name: 'Aggressive', value: 'Aggressive' }
        ];
      } else if (change == 'cat') {
        this.controllers['bloodType']['options'] = [
          {
            name: 'Type A',
            value: 'Type A'
          },
          {
            name: 'Type B',
            value: 'Type B'
          },
          {
            name: 'Type AB',
            value: 'Type AB'
          },
        ];
        this.controllers['color']['options'] = [
          {
            name: 'Black',
            value: 'Black'
          },
          {
            name: 'Brown',
            value: 'Brown'
          },
          {
            name: 'White',
            value: 'White'
          },
          {
            name: 'Orange',
            value: 'Orange'
          },
          {
            name: 'Grey',
            value: 'Grey'
          },
          {
            name: 'White and black',
            value: 'White and black'
          },
          {
            name: 'White and orange',
            value: 'White and orange'
          },
          {
            name: 'Black and grey',
            value: 'Black and grey'
          },

        ];
        this.controllers['temperament']['options'] = [
          { name: 'Friendly', value: 'Friendly' },
          { name: 'Social', value: 'Social' },
          { name: 'Aloof', value: 'Aloof' },
          { name: 'Timid', value: 'Timid' },
          { name: 'Not friendly', value: 'Not friendly' },
          { name: 'Aggressive', value: 'Aggressive' }
        ];
      }
      this.controllers['breed'] = JSON.parse(JSON.stringify(this.controllers['breed']));
      this.controllers['color'] = JSON.parse(JSON.stringify(this.controllers['color']));
      this.controllers['bloodType'] = JSON.parse(JSON.stringify(this.controllers['bloodType']));
      this.controllers['temperament'] = JSON.parse(JSON.stringify(this.controllers['temperament']));
    })
  }
  edit() {
    this.form = this.fb.group({
      name: [this.editData['petName'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: [this.editData['type'], Validators.required],
      month: [this.editData['month'], [Validators.required, Validators.min(0), Validators.max(12)]],
      year: [this.editData['year'], [Validators.required, Validators.min(0)]],
      breed: [this.editData['breed'], Validators.required],
      age: [null,],
      gender: [this.editData['gender'], Validators.required],
      image: [this.editData['profileImage']],
      weight: [this.editData['weight'] ? this.editData['weight']:'', Validators.min(0)], //weight color coatLength neutered bloodType temperament trainingLevel allergies marks
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null,]
    })
    let type;
    if (this.editData['gender'] == 'female') {
      this.form.get('gender').setValue('Female');
    } else if (this.editData['gender'] == 'male') {
      this.form.get('gender').setValue('Male');
    }
    if(this.editData['type'] == 'Cat'){
      this.form.get('species').setValue('cat')
    }
    if(this.editData['type'] == 'Dog'){
      this.form.get('species').setValue('dog')
    }
    if (this.form.get('species').value == "cat") {
      type = "Cat"
    } else if (this.form.get('species').value == "dog") {
      type = "Dog"
    }
    // else if (this.form.get('species').value == "bird") {
    //   type = "Bird"
    // } else if (this.form.get('species').value == "exotic") {
    //   type = "Exotic"
    // }
    if (this.editData['metadata']) {
      this.editData['metadata'].forEach((el) => {
        if (el['key'] == 'petColor') {
          this.form.get('color').setValue(el['value'])
        }
        if (el['key'] == 'trainingLevel') {
          this.form.get('trainingLevel').setValue(el['value'])
        }
        if (el['key'] == 'allergy') {
          this.form.get('allergies').setValue(el['value'])

        }
        if (el['key'] == 'neutered') {
          this.form.get('neutered').setValue(el['value'])

        }
        if (el['key'] == 'bloodType') {
          this.form.get('bloodType').setValue(el['value'])

        }
        if (el['key'] == 'temperament') {
          this.form.get('temperament').setValue(el['value'])

        }
        if (el['key'] == 'coatLength') {
          this.form.get('coatLength').setValue(el['value'])

        }
        if(el['key'] == 'distintive'){
          this.form.get('marks').setValue(el['value'])
        }
      })
    }

    console.log(type);

    this.adoptionManagementService.getBreeds(type).subscribe((res: Array<any>) => {
      res.forEach(el => {
        this.controllers['breed']['options'].push({
          name: el,
          value: el
        })
      });
      this.form.get('breed').setValue(this.editData['breed'])
    })
    console.log('form', this.form);

  }
  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "name",
        name: 'name',
        label: "Pet Name",
        required: true,
        placeholder: "Enter Pet Name",
        type: "text"
      },
      species: {
        id: "species",
        name: 'species',
        label: "Pet Species*",
        required: true,
        placeholder: "Enter Pet Species",
        options: [
          {
            name: "Dog",
            value: "dog"
          },
          {
            name: "Cat",
            value: "cat"
          },
          {
            name: "Bird",
            value: "bird"
          },
          {
            name: "Exotic",
            value: "exotic"
          }
        ],
        type: "text"
      },
      breed: {
        id: "breed",
        name: 'breed',
        label: "Pet Breed*",
        required: true,
        placeholder: "Enter Pet Breed",
        options: [],
        type: "text"
      },
      age: {
        id: "age",
        name: 'age',
        label: "Pet Age",
        required: true,
        placeholder: "Enter Age In Months",
        type: "text"
      },
      year : {
        id: "year",
        name: "year",
        label: "Year",
        placeholder: "Enter Year",
        required: true,
      },
      month : {
        id: "month",
        name: "month",
        label: "Month",
        placeholder: "Enter Month",
        required: true,
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        options: [
          {
            name: "Male",
            value: "Male"
          },
          {
            name: "Female",
            value: "Female"
          }

        ],
        type: "radio"
      },
      image: {
        id: "image",
        name: 'image',
        label: "Upload Pet Image*",
        required: true,
        placeholder: "",
        type: "image"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true,
      },
      weight: {
        id: "weight",
        name: "weight",
        label: "Weight (in kg)",
        placeholder: "Enter Weight",
        required: true,
      },
      color: {
        id: "color",
        name: "color",
        label: "Color",
        placeholder: "Enter Color",
        required: true,
        options: [
          { name: 'Black', value: 'Black' },
          { name: 'Brown', value: 'Brown' },
          { name: 'White', value: 'White' },
          { name: 'Golden', value: 'Golden' },
          { name: 'Grey', value: 'Grey' },
          { name: 'White and black ', value: 'White and black ' },
          { name: 'White and brown', value: 'White and brown ' },
          { name: 'Black and brown', value: 'Black and brown' },
          { name: 'Black, white and brown', value: 'Black, white and brown' },
        ]
      },
      coatLength: {
        id: "coatLength",
        name: "coatLength",
        label: "Coat Length",
        placeholder: "Enter Color",
        required: true,
        options: [
          { name: 'Small', value: 'Small' },
          { name: 'Medium', value: 'Medium' },
          { name: 'Large', value: 'Large' },
        ]
      },
      neutered: {
        id: "neutered",
        name: "neutered",
        label: "Neutered/Spayed",
        placeholder: "Enter Color",
        required: true,
        options: [
          {
            name: 'Yes',
            value: 'Yes'
          }, {
            name: 'No',
            value: 'No'
          }
        ]
      },
      bloodType: {
        id: "bloodType",
        name: "bloodType",
        label: "Blood Type",
        placeholder: "Enter bloodType",
        required: true,
        options: [
          { name: 'DEA 1.1', value: 'DEA 1.1' },
          { name: 'DEA 1.2', value: 'DEA 1.2' },
          { name: 'DEA 3', value: 'DEA 3' },
          { name: 'DEA 4', value: 'DEA 4' },
          { name: 'DEA 5', value: 'DEA 5' },
          { name: 'DEA 6', value: 'DEA 6' },
          { name: 'DEA 7', value: 'DEA 7' },
          { name: 'DEA 8', value: 'DEA 8' },
        ]
      },
      temperament: {
        id: "temperament",
        name: "temperament",
        label: "Temperament",
        placeholder: "Enter Temperament",
        required: true,
        options: [
          { name: 'Friendly ', value: 'Friendly ' },
          { name: 'Not friendly', value: 'Not friendly' },
          { name: 'Reserved', value: 'Reserved' },
          { name: 'Anxious', value: 'Anxious' },
          { name: 'Fearful', value: 'Fearful' },
          { name: 'Reactive', value: 'Reactive' },
          { name: 'Aggressive', value: 'Aggressive' },
        ]
      },
      trainingLevel: {
        id: "trainingLevel",
        name: "trainingLevel",
        label: "Training Level",
        placeholder: "Enter Training Level",
        required: true,
        options: [
          { name: 'House Training', value: 'House Training' },
          { name: 'Basic Obedience', value: 'Basic Obedience' },
          { name: 'Socialization', value: 'Socialization' },
          { name: 'Advanced obedience', value: 'Advanced obedience' },
          { name: 'Impulse control', value: 'Impulse control' },
          { name: 'Leash Training', value: 'Leash Training' },
          { name: 'Off-leash training', value: 'Off-leash training' },
          { name: 'Trick training', value: 'Trick training' },
          { name: 'Agility training', value: 'Agility training' },
          { name: 'Therapy Dog Training', value: 'Therapy Dog Training' },
          { name: 'Service Dog Training', value: 'Service Dog Training' },
          { name: 'Search and Rescue Training', value: 'Search and Rescue Training' },
          { name: 'Scent Detection Training', value: 'Scent Detection Training' },
          { name: 'Protection Training', value: 'Protection Training' },
        ]
      },
      allergies: {
        id: "allergies",
        name: "allergies",
        label: "Allergies",
        placeholder: "Enter Allergies",
        required: true,

      },
      marks: {
        id: "marks",
        name: "marks",
        label: "Distinctive Marks",
        placeholder: "Enter Allergies",
        required: true,

      },

    }
  }
  uploadProfile(event) {
    if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.addPetProfileImage(this.petParentId, this.editData['id'], this.form.get('image').value).subscribe((res) => {
        console.log(res);
        this.loader.hideLoader();
      })
    }
  }

  addPet() {
    if(!this.petParentId){
      this.petParentId = sessionStorage.getItem('petParentId')
    }
    console.log(this.form);
    
    let json = this.form.value
    let body = {
      "petName": json['name'],
      "type": json['species'],
      "breed": json['breed'],
      "weight" : json['weight'],
      "gender": json['gender'],
      "year": json['year'],
      "month": json['month'],
      "userId": this.petParentId,
      "active": true,
      "metadata": []
    }

    if (this.editData) {
      if (this.editData['metadata']) {
        body['metadata'] = this.editData['metadata'];
        
        body['metadata'].forEach((el) => {
          if (el['key'] == "petColor") {
            el['value'] = json['color'];
            // else{
            //   body['metadata'].filter(el => el[])
            // }
          }
          if (el['key'] == 'trainingLevel') {
            el['value'] = json['trainingLevel'];
          }
          if (el['key'] == 'allergy') {
            el['value'] = json['allergies'];

          }
          if (el['key'] == 'neutered') {
            el['value'] = json['neutered'];

          }
          if (el['key'] == 'bloodType') {
            el['value'] = json['bloodType'];

          }
          if (el['key'] == 'temperament') {
            el['value'] = json['temperament'];

          }
          if (el['key'] == 'coatLength') {
            el['value'] = json['coatLength'];

          }
          if(el['key'] == 'distintive'){
            el['value'] = json['marks'];
          }
        })
        // { key: "distintive", value: distintiveMarks }
        if ((body['metadata'].some(obj => obj.key === 'distintive') == false) && json['marks']) {
          body['metadata'].push(
            {
              "key": "distintive",
              "value": json['marks']
            }
          )
        }
        if ((body['metadata'].some(obj => obj.key === 'bloodType') == false) && json['bloodType']) {
          body['metadata'].push(
            {
              "key": "bloodType",
              "value": json['bloodType']
            }
          )
        }
  
        if ((body['metadata'].some(obj => obj.key === 'temperament') == false) && json['temperament']) {
          if (json['temperament']) {
            body['metadata'].push(
              {
                "key": "temperament",
                "value": json['temperament']
              }
            )
          }
        }
  
        if ((body['metadata'].some(obj => obj.key === 'neutered')==false) && json['neutered']){
          body['metadata'].push({
            "key": "neutered",
            "value": json['neutered']
          })
        }
  
        if ((body['metadata'].some(obj => obj.key === 'allergies') == false) && json['allergies']) {
          body['metadata'].push({
            "key": "allergy",
            "value": json['allergies']
          })
        }
  
        if ((body['metadata'].some(obj => obj.key === 'trainingLevel') == false )&& json['trainingLevel']) {
          body['metadata'].push({
            "key": "trainingLevel",
            "value": json['trainingLevel'],
  
          })
        }
  
        if ((body['metadata'].some(obj => obj.key === 'petColor') == false) && json['color']) {
          body['metadata'].push({
            "key": "petColor",
            "value": json['color']
          })
        }

        // if(json['color'] == '' && json['trainingLevel'] == '' && json['allergies'] == '' &&  json['neutered'] == '' && json['bloodType'] == '' && json['temperament'] == '' && json['coatLength'] == '' && json['marks']==''){
        //   body['metadata'] = []
        // }
        body.metadata = body.metadata.filter(item => item.value);
        
      }else {
        if (json['coatLength']) {
          body['metadata'].push(
            {
              "id": '',
              "key": "coatLength",
              "value": json['coatLength']
            }
          )
        }
        if (json['bloodType']) {
          body['metadata'].push(
            {
              "id": '',
              "key": "bloodType",
              "value": json['bloodType']
            }
          )
        }

        if (json['temperament']) {
          body['metadata'].push(
            {
              "id": '',
              "key": "temperament",
              "value": json['temperament']
            }
          )
        } if (json['neutered']) {
          body['metadata'].push({
            "id": '',
            "key": "neutered",
            "value": json['neutered']
          })
        }
        if (json['allergies']) {
          body['metadata'].push({
            "id": '',
            "key": "allergy",
            "value": json['allergies']
          })
        }
        if (json['trainingLevel']) {
          body['metadata'].push({
            "id": '',
            "key": "trainingLevel",
            "value": json['trainingLevel'],

          })
        }
        if(json['marks']){
          body['metadata'].push({
            "id": '',
            "key": "distintive",
            "value": json['marks'],

          })
        }

        if (json['color']) {
          body['metadata'].push({
            "id": '',
            "key": "petColor",
            "value": json['color']
          })
        }
        body.metadata = body.metadata.filter(item => item.value);

      }

      body["id"] = this.editData["id"];
      this.loader.showLoader();
      this.userManagementService.updatePet(this.petParentId, body).subscribe((res) => {
        this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe((res: Array<any>) => {
          console.log(res);
          this.loader.hideLoader();
          this.cancelEvent.emit()
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Pet updated successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
        console.log(res);
      }, (error) => {
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    } else {
      if (json['coatLength']) {
        body['metadata'].push(
          {
            "key": "coatLength",
            "value": json['coatLength']
          }
        )
      }
      if (json['bloodType']) {
        body['metadata'].push(
          {
            "key": "bloodType",
            "value": json['bloodType']
          }
        )
      }
      
      if (json['temperament']) {
        body['metadata'].push(
          {
            "key": "temperament",
            "value": json['temperament']
          }
        )
      } if (json['neutered']) {
        body['metadata'].push({
          "key": "neutered",
          "value": json['neutered']
        })
      }
      if (json['allergies']) {
        body['metadata'].push({
          "key": "allergy",
          "value": json['allergies']
        })
      }
      if (json['trainingLevel']) {
        body['metadata'].push({
          "key": "trainingLevel",
          "value": json['trainingLevel'],

        })
      }
      
      if (json['color']) {
        body['metadata'].push({
          "key": "petColor",
          "value": json['color']
        })
      }
      if(json['marks']){
        body['metadata'].push({
          "key": "distintive",
          "value": json['marks'],

        })
      }

      this.loader.showLoader();
      
      this.userManagementService.addPet(this.petParentId, body).subscribe((res) => {
        this.userManagementService.addPetProfileImage(this.petParentId, res['id'], json['image']).subscribe((res) => {
          this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe((res: Array<any>) => {
            this.loader.hideLoader();
            console.log(res);
            this.cancelEvent.emit()
            const dialogRef = this.dialog.open(SuccessDialogComponent, {
              width: '300px',
              data: { message: 'Pet created successfully!', success: true },
              panelClass: 'success-dialog-container'
            });
            console.log(res);
          })
        })
        console.log(res);
      }, (error) => {
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }

  getPets() {
    // if (this.editData) {
    this.loader.showLoader()
    this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe((res: Array<any>) => {
      console.log(res);
      this.loader.hideLoader();
    })
    // }
  }

  cancel() {
    this.form.reset()
    this.getPets();
    this.cancelEvent.emit();
    this.router.navigate(['/user/pet']);
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
  ngOnDestroy() {
    this.form.reset()
  }
}
