import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-collaborator',
  templateUrl: './add-collaborator.component.html',
  styleUrls: ['./add-collaborator.component.scss']
})
export class AddCollaboratorComponent {
  form: FormGroup;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controllers: any;
  constructor(private fb: FormBuilder,
    private userManagementService: UserManagementService,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private loader: LoaderService,
    private dialog: MatDialog

  ) {
    this.form = this.fb.group({
      name: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: ['', [Validators.required, this.validationsService.emailValidator()]],
      phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
      city: ['', [Validators.required, this.validationsService.cityValidation()]],
      profileImage: ['',Validators.required]
    })

    this.craeteFormControllers()

  }
  ngOnInit() {

  }

  ngOnChanges() {
    console.log(this.editData);
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }
  }
  edit() {
    this.form = this.fb.group({
      name: [this.editData['collaboratorName'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: [this.editData['email'], [Validators.required, this.validationsService.emailValidator()]],
      phone: [this.editData['mobile'], [Validators.required, this.validationsService.mobileNumberValidator()]],
      city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
      profileImage: [this.editData['imageUrl'], Validators.required],
      internalNotes: []
    })
  }

  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "userName",
        name: 'name',
        label: "Name",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      email: {
        id: "userName",
        name: 'email',
        label: "Email",
        required: true,
        placeholder: "Enter Email",
        type: "email"
      },
      phone: {
        id: "phone",
        name: 'phone',
        label: "Phone",
        required: true,
        placeholder: "Enter Mobile No.",
        type: "text"
      },
      city: {
        id: "city",
        name: 'city',
        label: "City",
        required: true,
        placeholder: "Enter City",
        type: "text"
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        type: "text"
      },

      profileImage: {
        id: "profileImage",
        name: 'profileImage',
        label: "Partner Image*",
        required: true,
        placeholder: "Enter Name",
        type: "file"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true,
      }
    }
  }
  updateProfile() {
    if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.addCollaboratorProfile(this.editData['id'], this.form.get('profileImage').value).subscribe((res) => {
        this.loader.hideLoader();
        this.showSuccessToast("Profile Image updated Successfully")
      })
    }
  }
  addCollaborator() {
    let data = {
      "email": this.form.value['email'],
      "countryCode": "23456",
      "mobile": this.form.value['phone'],
      "collaboratorName": this.form.value['name'],
      "isVerified": true,
      "isEmailVerified": true,
      "city": this.form.value['city'],
      "status": "Created"
    }
    if (this.editData) {
      data["id"] = this.editData['id'];
      this.loader.showLoader();
      this.userManagementService.updateCollaboratorById('1', data).subscribe((res) => {
        // this.userManagementService.addCollaboratorProfile(res['id'], this.form.get('coverImage').value).subscribe((res) => {
        this.userManagementService.getCollaboratorsByType('All').subscribe((res) => {
          this.loader.hideLoader();
          this.cancel()
          this.router.navigate(['/user/collaborator']);
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Collaborator updated successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
        // })
      }, (error) => {
        console.log("🚀 ~ AddCollaboratorComponent ~ this.userManagementService.updateCollaboratorById ~ error:", error)
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: error.error.message === "could not execute statement; SQL [n/a]; constraint [admin_user.email_UNIQUE]; nested exception is org.hibernate.exception.ConstraintViolationException: could not execute statement" ? "Email should be unique" : 'Something Went Wrong!', success: false }
        });
      }

      )
    } else {
      this.loader.showLoader();
      this.userManagementService.registerCollaborators(data, '1').subscribe((res) => {
        this.userManagementService.addCollaboratorProfile(res['id'], this.form.get('profileImage').value).subscribe((res) => {
          this.userManagementService.getCollaboratorsByType('All').subscribe((res) => {
            this.loader.hideLoader();
            this.router.navigate(['/user/collaborator']);
          })
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Collaborator created successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
      }, (error) => {
        console.log("🚀 ~ AddCollaboratorComponent ~ this.userManagementService.registerCollaborators ~ error:", error)
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: error.error.message, success: false }
        });
      }
      )
    }
  }
  cancel() {
    this.cancelEvent.emit()
    this.router.navigate(['/user/collaborator'])
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
