import { Component, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { UserManagementService } from 'app/services/user-management.service';

@Component({
  selector: 'app-add-address-pet-parent',
  templateUrl: './add-address-pet-parent.component.html',
  styleUrls: ['./add-address-pet-parent.component.scss']
})
export class AddAddressPetParentComponent {

  addressForm: FormGroup;
  controllers: any;

  constructor(
    private fb: FormBuilder,
    public dialogRef: MatDialogRef<AddAddressPetParentComponent>,
    private userManagementService : UserManagementService,
    @Inject(MAT_DIALOG_DATA) public data: any,
  ) {
    this.createControllers();
    this.addressForm = this.fb.group({
      type: [''],
      flatNo: [''],
      address: ['', Validators.required],
      city: ['', Validators.required],
      pincode: ['', Validators.required],
      location: ['', Validators.required],
      state: ['', Validators.required]
    });
  }

  ngOnInit(){
    if(this.data['id']){
      this.addressForm = this.data['formGroup']
    }
  }

  onSubmit() {
    let json = this.addressForm.value;
    let body = {
      "userId": this.data['petParentId'],
      "type": json['type'],
      "flatNo": json['flatNo'],
      "latitude": "11.110",
      "longitude": "22.333",
      "address": json['address'],
      "pincode": json['pincode'],
      "city": json['city'],
      "state": json['state'],
      "default": false
    }
    if(this.data['id']){
      body['id'] = this.data['id']
      this.userManagementService.updateAddress(this.data['petParentId'],this.data['id'],body).subscribe((res)=>{
        console.log(res);
        this.dialogRef.close(this.addressForm.value);
        
      })
    }else{
      this.userManagementService.addAddress(this.data['petParentId'],body).subscribe((res)=>{
        this.dialogRef.close(this.addressForm.value);
      })
    }
  }

  onCancel() {
    this.dialogRef.close();
  }

  createControllers() {
    this.controllers = {
      type: {
        id: "type",
        name: 'type',
        label: "Type",
        required: true,
        placeholder: "",
        type: "radio",
        options: [
          {
            name: 'Home',
            value: 'Home'
          },
          {
            name: 'Work',
            value: 'Work'
          },
          {
            name: 'Hotel',
            value: 'Hotel'
          },
          {
            name: 'Other',
            value: 'Other'
          }
        ]
      },
      flatNo: {
        id: "flatNo",
        name: 'flatNo',
        label: "Flat No",
        required: true,
        placeholder: "Enter Flat No",
        type: "text"
      },
      address: {
        id: "address",
        name: 'address',
        label: "Address",
        required: true,
        placeholder: "Enter Address",
        type: "text"
      },
      pincode: {
        id: "pincode",
        name: 'pincode',
        label: "Pincode",
        required: true,
        placeholder: "Enter Pincode",
        type: "text"
      },
      city: {
        id: "city",
        name: 'city',
        label: "City",
        required: true,
        placeholder: "Enter city",
        type: "text"
      },
      location: {
        id: "location",
        name: 'location',
        label: "location",
        required: true,
        placeholder: "Enter Location",
        type: "text"
      },state:{
        id: "state",
        name: 'state',
        label: "State",
        required: true,
        placeholder: "Enter State",
        type: "text"
      }
    }
  }

}
