import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { RollsManagementComponent } from './rolls-management.component';
import { RollsManagementRoutingModule } from './rolls-management-routing.module';
import { MatTableModule } from '@angular/material/table';
import { MatIconModule } from '@angular/material/icon';
import { MatMenuModule } from '@angular/material/menu';
import { CommonComponentsModule } from 'app/components/common-components/common-components.module';
import { AddRollComponent } from './add-roll/AddRollComponent';
import {MatDialogModule} from '@angular/material/dialog';
import {MatDatepickerModule} from '@angular/material/datepicker';
import {MatNativeDateModule} from '@angular/material/core';
import {MatButtonModule} from '@angular/material/button';
import { ControllersModule } from 'app/components/controllers/controllers.module';
import {MatSidenavModule} from '@angular/material/sidenav';
import { MatPaginatorModule } from '@angular/material/paginator';
import { FormsModule } from '@angular/forms';
import {MatSlideToggleModule} from '@angular/material/slide-toggle';
import { DisplayVideoComponent } from './display-video/display-video.component';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { StatsComponent } from './stats/stats.component';

import {MatCheckboxModule} from '@angular/material/checkbox';

@NgModule({
    declarations: [RollsManagementComponent, AddRollComponent, DisplayVideoComponent, StatsComponent],
    imports: [
        CommonModule,
        RollsManagementRoutingModule,
        MatTableModule,
        MatSlideToggleModule,
        ControllersModule,
        MatMenuModule,
        MatIconModule,
        MatButtonModule,
        MatNativeDateModule,
        MatDatepickerModule,
        CommonComponentsModule,
        MatDialogModule,
        MatSidenavModule,
        FormsModule,
        MatPaginatorModule,
        MatSnackBarModule,
        MatCheckboxModule
    ],
})
export class RollsManagementModule {}
