import { Component, ViewChild } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { MatMenuTrigger } from '@angular/material/menu';
import { Router } from '@angular/router';
import { RollsManagementService } from 'app/services/rolls-management.service';
import { AddRollComponent } from './add-roll/AddRollComponent';
import { MatSidenav } from '@angular/material/sidenav';
import { DisplayVideoComponent } from './display-video/display-video.component';
import { FormControl } from '@angular/forms';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { saveAs } from 'file-saver';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import moment from 'moment';
@Component({
    selector: 'app-rolls-management',
    templateUrl: './rolls-management.component.html',
    styleUrls: ['./rolls-management.component.scss'],
})
export class RollsManagementComponent {
    isChecked = true;
    @ViewChild(MatPaginator) paginator: MatPaginator;
    rolls: MatTableDataSource<any>;
    ctrl = true;
    showFiller: Boolean = false;
    row: any;
    selectedRow: any;
    index: number;
    showAll: boolean = false;
    @ViewChild('sidenav') sidenav: MatSidenav;
    data: any;
    searchTerm: string = '';
    displayedColumns: string[] = [
        'selector',
        'id',
        'uploadedBy',
        'description',
        'createdAt',
        'views',
        'likes',
        'shares',
        'test',
        'active',
        'rolls',
        'thumbnail',
        'action',
    ];
    isView: boolean = false;
    constructor(
        private rollsManagementService: RollsManagementService,
        private router: Router,
        public dialog: MatDialog,
        private snackBar: MatSnackBar,
        private loader: LoaderService,
        private _snackBar: MatSnackBar,
    ) {
        this.getRolls();
    }
    ngOnInit() {
        console.log(this.ctrl);
    }

    currentUTCDate(date): string {
        return moment.utc(date).local().format("DD-MMM-YYYY hh:mm A");
    }

    getRolls() {
        let ary = []
        this.loader.showLoader();
        this.rollsManagementService.getAllRoles(1).subscribe((res: Array<any>) => {
            this.loader.hideLoader()
            res.forEach((el) => {
                // console.log(el['name']);
                el['uploaderName'] = el['uploaderName'] ? el['uploaderName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
                // el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
                // .capitalize()
                if (!this.showAll) {
                    if (el['status'] == 'ACTIVE') {//|| el['status'] == 'Active'
                        ary.push(el)
                    }
                } else {
                    ary.push(el)
                }
            })
            this.data = res;
            const rollsArray = Object.values(ary);
            this.rolls = new MatTableDataSource(
                rollsArray.map((item: any) => ({
                    ...item,
                }))
            );
            this.rolls.paginator = this.paginator;
        });
    }

    openSnackBar(message: string) {
        this._snackBar.open(message, 'Close', {
            duration: 2000,
        });
    }

    copyToClipboard(text: string) {
        navigator.clipboard.writeText(text).then(() => {
            this.openSnackBar('Copied!');
        }).catch(err => {
            console.error('Failed to copy text: ', err);
        });
    }
    
    showDataEvent(event) {
        this.showAll = !this.showAll;
        this.getRolls()
    }
    @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
    editRoll(isView: boolean = false) {
        console.log('edit');
        // this.row = new Array();
        this.row = this.selectedRow;
        // this.row = this.data[this.index];
        this.isView = isView;
        this.showFiller = true;
        this.sidenav.toggle();
    }
    clickName(element) {
        console.log(element);
        // this.row = new Array();
        this.row = this.selectedRow;
        this.row=element;
        // this.row = this.data[this.index];
        this.isView = this.isView;
        this.showFiller = true;
        this.sidenav.toggle();
    }
    deleteRoll() {
        console.log('delete');
        let rollId = this.selectedRow['id'];
        const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
            width: '400px',
            data: { message: 'Are you sure you want to Delete Roll?' }
        });

        dialogRef.afterClosed().subscribe(result => {
            if (result) {
                // User confirmed action
                this.loader.showLoader()
                this.rollsManagementService.deleteRoll(rollId).subscribe((res) => {
                    this.loader.hideLoader();
                    this.getRolls();
                    console.log(res);
                    this.menuTrigger.closeMenu();
                    const dialogRef = this.dialog.open(SuccessDialogComponent, {
                        width: '300px',
                        data: { message: 'Roll deleted successfully!', success: true },
                        panelClass: 'success-dialog-container'
                    });
                }, (error) => {
                    this.loader.hideLoader()
                    const dialogRef = this.dialog.open(SuccessDialogComponent, {
                        width: '300px',
                        data: { message: 'Something Went Wrong!', success: false }
                    });
                }
                );

            } else {
                // User cancelled action
                console.log('Cancelled');
                dialogRef.close()
            }
        })
    }
    filter(searchTerm: string) {
        this.searchTerm = searchTerm;
        this.applyFilter();
    }
    testChange(event, element){
        console.log(event);
        this.loader.showLoader()
        this.rollsManagementService.updateTest('ROLL',element['id'],event['checked']).subscribe(
            (res) => {
                this.loader.hideLoader()
                console.log(res);
                this.showSuccessToast('Update successful');
            },
            (error) => {
                this.loader.hideLoader()
                console.error(error);
                this.showErrorToast('Update failed');
            }

        )
    }
    applyFilter() {
        this.rolls = this.data.filter((item) => {
            const searchableFields = [
                'id',
                'uploadedBy',
                'description',
                'views',
                'likes',
                'shares',
            ];
            return searchableFields.some((field) =>
                item[field]
                    ?.toLowerCase()
                    .includes(this.searchTerm.toLowerCase())
            );
        });
    }

    viewVideo(element) {
        console.log(element['location']);
        const dialogRef = this.dialog.open(DisplayVideoComponent, {
            data: { url: element['location'] },
        });

        dialogRef.afterClosed().subscribe((result) => {
            console.log('The dialog was closed');
        });
    }
    add(event) {
        this.router.navigate(['/rolls/add']);
        // const dialogRef = this.dialog.open(AddRollComponent);
        // dialogRef.afterClosed().subscribe(result => {
        //   console.log('The dialog was closed');
        // });
    }

    export(event) {
            // Filter selected rows
            const selectedRows = this.rolls.data.filter(row => row.selected);
            
            // Convert selected rows to CSV
            const csvData = this.convertToCSV(selectedRows);
            
            // Create a Blob and save the CSV file
            const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });
            saveAs(blob, 'rolls.csv');
    }
    convertToCSV(data: any[]): string {
        const header = Object.keys(data[0]).join(',');
        const csv = data.map((row) => Object.values(row).join(',')).join('\n');
        return `${header}\n${csv}`;
    }
    toggle(row, element) {
        // drawer.toggle()
        this.selectedRow = element;
        this.index = row;
    }
    slideToggleChange(event, element) {
        // element['status']
        if (event['checked'] == false) {
            element['status'] = 'Pending';
        } else {
            element['status'] = 'ACTIVE';
        }
        this.loader.showLoader();
        this.rollsManagementService
            .updateRollStatus(element['id'], element['status'])
            .subscribe(
                (res) => {
                    this.loader.hideLoader()
                    console.log(res);
                    this.showSuccessToast('Update successful');
                },
                (error) => {
                    this.loader.hideLoader()
                    console.error(error);
                    this.showErrorToast('Update failed');
                }
            );
    }
    showSuccessToast(message: string): void {
        this.snackBar.open(message, 'Close', {
            duration: 3000,
            panelClass: ['success-toast'],
        });
    }

    showErrorToast(message: string): void {
        this.snackBar.open(message, 'Close', {
            duration: 3000,
            panelClass: ['error-toast'],
        });
    }
    cancel() {
        this.getRolls();
        this.sidenav.toggle();
    }
}
