import { Component, ElementRef, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';

@Component({
  selector: 'app-display-video',
  templateUrl: './display-video.component.html',
  styleUrls: ['./display-video.component.scss']
})
export class DisplayVideoComponent {
  @ViewChild('videoPlayer') videoplayer: ElementRef;
  constructor(
    public dialogRef: MatDialogRef<DisplayVideoComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
  ) {}

  onNoClick(): void {
    this.dialogRef.close();
  }

  toggleVideo() {
    this.videoplayer.nativeElement.play();
}

}
