import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { RollsManagementService } from 'app/services/rolls-management.service';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { StatsComponent } from '../stats/stats.component';
import { MatDialog } from '@angular/material/dialog';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { DomSanitizer } from '@angular/platform-browser';
import { LoaderService } from 'app/services/loader.service';


@Component({
  selector: 'app-add-roll',
  templateUrl: './add-roll.component.html',
  styleUrls: ['./add-roll.component.scss']
})
export class AddRollComponent {
  collaboratorId: string; '1'
  workspaceId: string = ""
  form: FormGroup;
  controlls: any;
  @Input() editData: any;
  @Input() isView: boolean;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  constructor(
    private fb: FormBuilder,
    private rollsManagementService: RollsManagementService,
    private router: Router,
    private workspaceManagementService: WorkspaceManagementService,
    private sanitizer: DomSanitizer,
    private userManagementService: UserManagementService,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    public dialog: MatDialog,
    private loader: LoaderService
  ) {
    this.createForm();
    this.createControls();
  }

  ngOnInit() {
    
    this.form.get('userType').valueChanges.subscribe((change) => {
      // debugger
      this.form.get('workSpace').setValue('');

      if (change == 'Veterinary' || change == 'Groomer') {
        this.form.get('workSpace').setValidators(Validators.required);
        this.form.get('workSpace').updateValueAndValidity();
      } else {
        this.form.get('workSpace').clearValidators();
        this.form.get('workSpace').updateValueAndValidity();
      }


      this.onUserTypeChange(change)
    })
    this.form.get('workSpace').valueChanges.subscribe((chnage) => {
      this.onWorkspaceChange(chnage)
    })
  }


  ngOnChanges() {
    if (this.editData) {
      // let ele = document.getElementById("add-update");
      // ele.innerHTML = "Save";
      this.edit();
    }
  }

  onUserTypeChange(change) {
    // debugger
    console.log("sdf");

    // this.form.get('userType').valueChanges.subscribe((change) => {
    this.controlls['workSpace']['options'] = []
    console.log(change);
    let serviceId;
    if (change == "Veterinary") {
      serviceId = "d8d71038-c48c-11ed-abc1-02817ef0919c";
    }
    if (change == "Groomer") {
      serviceId = "5e4c6b60-c48e-11ed-abc1-02817ef0919c";
    }
    if (change == 'FurrCrew') {
      this.collaboratorId = '1'
    }
    if (change == 'FurrFiesta') {
      this.collaboratorId = '2'
    }
    // debugger 
    this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      console.log(res);
      res.forEach((element) => {
        // element['collaboratorId']
        if (element['status'] == "Active") {
          this.controlls['workSpace']['options'].push(
            {
              name: element['designationName'] + '-' + element['workplaceName'],
              value: element['designationName'] + '-' + element['workplaceName']
            });
        }
        this.controlls['workSpace'] = JSON.parse(JSON.stringify(this.controlls['workSpace']));
      });
      
    })

    // })
  }

  onWorkspaceChange(chnage) {
    let serviceId;
    if (this.form.get('userType').value == "Veterinary") {
      serviceId = "d8d71038-c48c-11ed-abc1-02817ef0919c";
    }
    if (this.form.get('userType').value == "Groomer") {
      serviceId = "5e4c6b60-c48e-11ed-abc1-02817ef0919c";
    }
    this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      console.log(res);
      res.forEach((element) => {
        // element['collaboratorId']
        if (chnage == element['designationName'] + '-' + element['workplaceName']) {
          console.log("got it ");
          this.workspaceId = element['id']
          this.collaboratorId = element['collaboratorId']
        }
      });
    })
  }
  edit() {
    console.log(this.editData);

    this.form = this.fb.group({
      file: [this.editData['location'], Validators.required],
      is18Plus: [this.editData['adult'], Validators.required],
      rollCaption: [this.editData['description'], [Validators.required, this.validationsService.stringValidator()]],
      rollTags: this.fb.array([], Validators.required),//[this.editData['tag'], Validators.required],
      uploadedBy: [this.editData['uploaderName'], Validators.required],
      userType: [this.editData['type']],
      coverImage: [this.editData['coverImage'], Validators.required],
      workSpace: [null],
      collaborator: [null],
      featured: [this.editData['featured']],
      sponsored: [this.editData['sponsored']],
      test: [this.editData['test']],
      internalNotes: [null]
    });
    let serviceId;
    let tagsArray = this.form.get('rollTags') as FormArray;
    let array = this.editData['tag'].split(' ');
    array.forEach(element => {
      tagsArray.push(
        this.fb.control(element)
      )
    });    //
    if (this.editData['type'] == 'VETERINARY') {
      this.form.get('userType').setValue('Veterinary')
    } else if (this.editData['type'] == "GROOMER" || this.editData['type'] == "Grooming") {
      this.form.get('userType').setValue('Groomer')
    }
    if (this.editData['createdBy'] == "1") {
      // this.form.get('userType').setValue("FurrCrew")
      this.collaboratorId = '1'
    } else if (this.editData['createdBy'] == "2") {
      // this.form.get('userType').setValue("FurrFiesta")
      this.collaboratorId = '2'
    }

    if (this.form.get('userType').value == "Veterinary") {
      serviceId = "d8d71038-c48c-11ed-abc1-02817ef0919c";
    }
    if (this.form.get('userType').value == "Groomer") {
      serviceId = "5e4c6b60-c48e-11ed-abc1-02817ef0919c";
    }
    this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      console.log(res);
      this.controlls['workSpace']['options'] = []
      res.forEach((element) => {
        // element['collaboratorId']
        if (element['status'] == "Active") {
          this.controlls['workSpace']['options'].push(
            {
              name: element['designationName'] + '-' + element['workplaceName'],
              value: element['designationName'] + '-' + element['workplaceName']
            }
          );
        }
        this.controlls['workSpace'] = JSON.parse(JSON.stringify(this.controlls['workSpace']));
        if (this.editData['workspaceId'] == element['id']) {
          console.log("found it1");
          console.log(element);
          this.workspaceId = element['id'];
          debugger
          this.form.get('workSpace').setValue(element['designationName'] + '-' + element['workplaceName']);
          console.log(this.form.get('workSpace'));

        }

      });
    })
  }

  stats(type: string) {//stats
    let stats: MatTableDataSource<any>;
    let aray = []

    this.rollsManagementService.stats(this.editData['id'], 'ROLL').subscribe((res: Array<any>) => {
      res.forEach((el) => {
        if (el['viewed'] && type == 'views') {////liked shared
          aray.push(el)
          const statsArray = Object.values(aray);
          stats = new MatTableDataSource(statsArray.map((item: any) => ({ ...item, })));
        } else if (el['liked'] && type == 'likes') {
          aray.push(el)
          const statsArray = Object.values(aray);
          stats = new MatTableDataSource(statsArray.map((item: any) => ({ ...item, })));

        } else if (el['shared'] && type == 'share') {
          aray.push(el)
          const statsArray = Object.values(aray);
          stats = new MatTableDataSource(statsArray.map((item: any) => ({ ...item, })));
        }
      })
      const dialogRef = this.dialog.open(StatsComponent, {
        width: '600px',
        data: { stats: stats }
      });

    })
  }
  createForm() {
    this.form = this.fb.group({
      file: [null, Validators.required],
      is18Plus: [false, Validators.required],
      rollCaption: [null, [Validators.required, this.validationsService.stringValidator()]],
      rollTags: this.fb.array([], Validators.required),
      userType: [null, Validators.required],
      workSpace: [null],
      collaborator: [null],
      internalNotes: [null],
      coverImage: [null, Validators.required],
      featured: [false],
      sponsored: [false],
      test: [false]
    });
  }

  createControls() {
    this.controlls = {
      file: {
        id: "file",
        name: 'file',
        label: "Upload Roll*",
        required: true,
        type: "file",
      },
      coverImage: {
        id: "coverImage",
        name: 'coverImage',
        label: "Cover Image*",
        required: true,
        type: "file",
      },
      is18Plus: {
        id: "is18Plus",
        name: 'is18Plus',
        label: "This roll Is 18+",
        required: true,
        type: "checkbox",
      },
      rollCaption: {
        id: "rollCaption",
        name: 'rollCaption',
        label: "Roll Caption",
        placeholder: "Write a Roll Caption",
        required: true,
        type: "text",
      },
      rollTags: {
        id: "rollTags",
        name: 'rollTags',
        label: "Roll Tags",
        placeholder: "Write a Roll Tags",
        required: true,
        type: "text",
      },
      userType: {
        id: "userType",
        name: 'userType',
        label: "Select Service Type",
        required: true,
        type: "radio",
        options: [
          {
            name: "FurrCrew",
            value: "FurrCrew"
          }, {
            name: "FurrFiesta",
            value: "FurrFiesta"
          },
          // {
          //   name: "Services",
          //   value: "Services"
          // },
          {
            name: "Veterinary",
            value: "Veterinary"
          }, {
            name: "Groomer",
            value: "Groomer"
          }
        ]
      },
      workSpace: {
        id: "workSpace",
        name: "workSpace",
        label: "Select Workspace",
        placeholder: "Select Workspace",
        options: []
      },
      collaborator: {
        id: "collaborator",
        name: "collaborator",
        label: "Select Collaborator",
        placeholder: "Select Collaborator",
        required: true,
        type: "dropdown",
        options: []
      },
      uploadedBy: {
        id: "uploadedBy",
        name: "uploadedBy",
        label: "Select UploadedBy",
        placeholder: "Enter uploadedBy",
        required: true,
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true,
      },
      featured: {
        id: "featured",
        name: 'featured',
        label: "Featured",
        required: true,
        type: "boolean"
      },
      sponsored: {
        id: "sponsored",
        name: 'sponsored',
        label: "Sponsored",
        required: true,
        type: "boolean"
      },
      test: {
        id: "test",
        name: 'test',
        label: "Test",
        required: true,
        type: "boolean"
      }
    };
  }

  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/rolls']);
  }

  updateCoverImage(event) {
    if (this.editData) {
      this.loader.showLoader()
      this.rollsManagementService.updateCoverImage(this.form.get('coverImage').value, this.editData['id']).subscribe((res) => {
        console.log(res);
        this.loader.hideLoader()
        this.showSuccessToast("Uploaded Successfully")
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to upload")
      }
      );
    }
  }

  create() {
    let json = this.form.value;
    console.log(json);
    if (this.editData) {
      let collaboratorId = this.collaboratorId;
      let isAdult = json['is18Plus'];
      let rollId = this.editData['id'];
      let tag = json['rollTags'];
      let file = json['file'];
      let description = json['rollCaption'];
      this.loader.showLoader()
      this.rollsManagementService.updateRoll(collaboratorId, isAdult, rollId, file, tag.join(" "), description, json['userType'], this.workspaceId, this.editData['status'], json['featured'], json['sponsored'], json['test']).subscribe((res1) => {
        this.rollsManagementService.getAllRoles(1).subscribe((res: Array<any>) => {
          this.loader.hideLoader();
          this.onNoClick();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Roll updated successfully!', success: true },
            panelClass: 'success-dialog-container'
          });

        })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      );
    } else {
      let file = json['file'];
      let tag = json['rollTags'];
      let description = json['rollCaption'];
      this.loader.showLoader()
      this.rollsManagementService.addRoll(file, tag.join(" "), description, this.collaboratorId, json['is18Plus'], json['userType'], this.workspaceId, json['featured'], json['sponsored'], json['test']).subscribe((res1) => {
        this.rollsManagementService.updateCoverImage(json['coverImage'], res1['id']).subscribe((res) => {
          console.log(res);
          this.rollsManagementService.getAllRoles(1).subscribe((res: Array<any>) => {
            this.loader.hideLoader()
            this.router.navigate(['rolls']);
            this.cancelEvent.emit();
            const dialogRef = this.dialog.open(SuccessDialogComponent, {
              width: '300px',
              data: { message: 'Roll created successfully!', success: true },
              panelClass: 'success-dialog-container'
            });
          }, (error) => {
            this.loader.hideLoader();
          }
          )
        }, (error) => {
          this.loader.hideLoader()
        })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }

  editClip() {
    if (this.editData) {
      this.loader.showLoader()
      this.rollsManagementService.updateRoleClip(this.editData['id'], this.form.get('file').value).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);

      })
    }
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  toggleView(val: boolean): void {
    this.isView = val;
  }
}
