import { Component, ViewChild } from '@angular/core';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatPaginator } from '@angular/material/paginator';
import { MatSidenav } from '@angular/material/sidenav';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { LoaderService } from 'app/services/loader.service';
import { NotificationService } from 'app/services/notification.service';
import moment from 'moment';

@Component({
  selector: 'app-notifications',
  templateUrl: './notifications.component.html',
  styleUrls: ['./notifications.component.scss']
})
export class NotificationsComponent {
  displayedColumns: string[] = ['name', 'designation','userName','dateJoined', 'access'];
  searchTerm: string = '';
  @ViewChild(MatPaginator) paginator: MatPaginator;
  notifications: MatTableDataSource<any>;
  data: any;
  showAll: boolean = false;
  constructor(
    private router: Router,
    private snackBar: MatSnackBar,
    private notificationService : NotificationService,
    private loader : LoaderService
  ) {
    this.getNotification();
  }
  index: number;
  ngAfterViewInit() {
    this.notifications.paginator = this.paginator;
  }
  currentUTCDate(milliseconds): string {
    if (milliseconds == 0) {
      0
    } else {
      return moment.utc(new Date(milliseconds)).local().format("DD-MMM-YYYY")
    }
  }
  getNotification() {
    let ary = []
    // this.notificationService.getNotifications().subscribe((res: Array<any>) => {
    //   this.data = res;
    //   res.forEach((el) => {
    //     el['title'] = el['title'] ? el['title'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
    //     el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
    //     if (!this.showAll) {
    //       if (el.status === 'Active') {
    //         ary.push(el)
    //       }
    //     } else {
    //       ary.push(el)
    //     }
    //     // .capitalize()
    //   })
    //   const webinarArray = Object.values(ary);
    //   this.notifications = new MatTableDataSource(webinarArray.map((item: any) => ({ ...item, })));
    //   this.notifications.paginator = this.paginator;
    // });
  }
  showDataEvent(event) {
    this.showAll = !this.showAll;
    this.getNotification()
  }

  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  showFiller: boolean = false;
  @ViewChild('sidenav') sidenav: MatSidenav;
  editUser() {
    this.row = new Array();
    this.row = this.data[this.index];

    this.showFiller = true;
    this.sidenav.toggle();
  }
  row: any;
  deleteUser() {
    // this.educationService.deleteCourse(this.data[this.index]['id']).subscribe((res) => {
    //   console.log(res);
    //   this.getWebinar();
    //   this.menuTrigger.closeMenu();
    //   this.showSuccessToast("Successfully Deleted")
    // }, (error) => {
    //   this.showErrorToast("Deletion Failed")
    // }
    // )
  }

  toggle(row) {
    // drawer.toggle()
    this.index = row;
  }

  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    this.notifications.filter = this.searchTerm.trim().toLowerCase();
  }

  add(event) {
    console.log(event);
    this.router.navigate(['/notification/create']);
  }

  export(event) {
    const webinarsToExport = this.notifications.data; // Use .data to get the raw data
    const csvData = this.convertToCSV(webinarsToExport);
    const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });

    // saveAs(blob, 'webinars.csv');
  }
  cancel() {
    this.sidenav.toggle();
  }
  convertToCSV(data: any[]): string {
    const header = Object.keys(data[0]).join(',');
    const csv = data.map(row => Object.values(row).join(',')).join('\n');
    return `${header}\n${csv}`;
  }
  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Inactive';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
    this.updatestatus(newStatus, element);
  }
  updatestatus(newStatus, element) {
    let body = {
      "id": element.id,
      "title": element.title,
      "description": element.description,
      "eventOn": element.eventOn,
      "isPublished": element.isPublished,
      "mode": element.mode,
      "price": element.price,
      "author": element.author,
      "isPaid": element.isPaid,
      "eduCategory": element.eduCategory,
      "published": newStatus === 'Active',
      "status": newStatus
    }
    // this.educationService.updateWebinar(body).subscribe(
    //   (res) => {
    //     console.log(res);
    //     this.showSuccessToast('Update successful');
    //   },
    //   (error) => {
    //     console.error(error);
    //     this.showErrorToast('Update failed');
    //   }
    // );
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
