import { Component, NgModule } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { ValidationsService } from 'app/services/validations.service';
// import { ReactiveFormsModule } from '@angular/forms';

@Component({
  selector: 'app-my-account',
  templateUrl: './my-account.component.html',
  styleUrls: ['./my-account.component.scss']
})

// @NgModule({
//   imports: [ReactiveFormsModule]
// })

export class MyAccountComponent {
  form: FormGroup;
  controllers: any;
  constructor(private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar

  ) {
    this.form = this.fb.group({
      name: ['', [Validators.required, this.validationsService.stringValidator()]],
      email: ['', [Validators.required, this.validationsService.emailValidator()]],
      designation: ['', [Validators.required, this.validationsService.designationValidator()]],
      Password: ['', Validators.required]
    });


    this.craeteFormControllers()

  }
  
  ngOnInit() {

  }

  ngOnChanges() {

  }


  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "userName",
        name: 'name',
        label: "Account Name",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      email: {
        id: "userName",
        name: 'email',
        label: "Email",
        required: true,
        placeholder: "Enter Email",
        type: "email"
      },
      designation: {
        id: "designation",
        name: 'designation',
        label: "Designation",
        required: true,
        placeholder: "Enter Designation ",
        type: "text"
      },
      Password: {
        id: "Password",
        name: 'Password',
        label: "Password",
        required: true,
        placeholder: "Password",
        type: "Password"
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        type: "text"
      },

      filename: {
        id: "filename",
        name: 'filename',
        label: "Partner Image",
        required: true,
        placeholder: "Enter Name",
        type: "file"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true,
      }
    }
  }
  

  submit() {
    if (this.form.valid) {
      this.showSuccessToast("Form submitted successfully!");
    }
    this.cancel();
  }

  cancel() {
    this.router.navigate(['/user/collaborator'])
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

}
