import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { MiscellaneousComponent } from './miscellaneous.component';
import { MiscellaneousRoutingModule } from './miscellaneous-routing.module';
import { BlogArticleComponent } from './blog-article/blog-article.component';
import { EventsComponent } from './events/events.component';
import { ManageAdminComponent } from './manage-admin/manage-admin.component';
import { MyAccountComponent } from './my-account/my-account.component';
import {MatTableModule} from '@angular/material/table';
import { MatIconModule } from '@angular/material/icon';
import { MatMenuModule } from '@angular/material/menu';
import { CommonComponentsModule } from 'app/components/common-components/common-components.module';
import { AddBlogComponent } from './add-blog/add-blog.component';
import { ControllersModule } from 'app/components/controllers/controllers.module';
import {MatButtonModule} from '@angular/material/button';
import { AdvertisementComponent } from './advertisement/advertisement.component';
import { MatPaginatorModule } from '@angular/material/paginator';
import { AddEventComponent } from './add-event/add-event.component';
import { MatSidenavModule } from '@angular/material/sidenav';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import {MatSlideToggleModule} from '@angular/material/slide-toggle';
import { CreateAdvertisementComponent } from './create-advertisement/create-advertisement.component';
import { AddTicketComponent } from './add-ticket/add-ticket.component';
import { ReactiveFormsModule } from '@angular/forms';
import { MatFormFieldModule } from '@angular/material/form-field';
import { AddAdminComponent } from './add-admin/add-admin.component';
import { MatTabsModule } from '@angular/material/tabs';
import { FaqsComponent } from './faqs/faqs.component';
import { AddFaqComponent } from './add-faq/add-faq.component';
import { TruncatePipe } from 'app/pipe/truncate.pipe';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { FormsModule } from '@angular/forms';


@NgModule({
  declarations: [
    MiscellaneousComponent,
    BlogArticleComponent,
    EventsComponent,
    ManageAdminComponent,
    MyAccountComponent,
    AddBlogComponent,
    AdvertisementComponent,
    AddEventComponent,
    CreateAdvertisementComponent,
    AddTicketComponent,
    AddAdminComponent,
    FaqsComponent,
    TruncatePipe,
    AddFaqComponent
  ],
  imports: [
    CommonModule,
    MiscellaneousRoutingModule,
    MatTableModule,
    MatMenuModule,
    MatTabsModule,
    MatButtonModule,
    MatIconModule,
    CommonComponentsModule,
    ControllersModule,
    MatPaginatorModule,
    MatSidenavModule,
    MatSnackBarModule,
    MatSlideToggleModule,
    ReactiveFormsModule,
    MatFormFieldModule,
    MatCheckboxModule,
    FormsModule,
  ]
})
export class MiscellaneousModule { }
