import { RouterModule, Routes } from "@angular/router";
import { NgModule } from "@angular/core";
import {MiscellaneousComponent} from './miscellaneous.component'
import { BlogArticleComponent } from "./blog-article/blog-article.component";
import { EventsComponent } from "./events/events.component";
import { ManageAdminComponent } from "./manage-admin/manage-admin.component";
import { MyAccountComponent } from "./my-account/my-account.component";
import { AddBlogComponent } from "./add-blog/add-blog.component";
import { AddEventComponent } from "./add-event/add-event.component";
import { AdvertisementComponent } from "./advertisement/advertisement.component";
import { CreateAdvertisementComponent } from "./create-advertisement/create-advertisement.component";
import { AddAdminComponent } from "./add-admin/add-admin.component";
import { FaqsComponent } from "./faqs/faqs.component";
import { AddFaqComponent } from "./add-faq/add-faq.component";

const routes: Routes = [
    {
      path: '',
      component: MiscellaneousComponent,
    },
    {
      path : 'blog',
      component : BlogArticleComponent
    },
    {
      path : 'events',
      component : EventsComponent
    },
    {
      path : 'admin',
      component : ManageAdminComponent
    },
    {
      path : 'faqs',
      component : FaqsComponent
    },
    {
      path : 'account',
      component : MyAccountComponent
    },{
      path : 'blog/addBlog',
      component : AddBlogComponent
    },{
      path : 'events/addEvent',
      component : AddEventComponent
    },{
      path : 'advertisment',
      component :AdvertisementComponent
    },{
      path : 'advertisment/createAdd',
      component : CreateAdvertisementComponent
    },{
      path : 'admin/addAdmin',
      component : AddAdminComponent
    },{
      path : 'faqs/addFaq',
      component : AddFaqComponent
    }
    
  ];
  
  @NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
  })
  export class MiscellaneousRoutingModule {
  }