import { Component, ViewChild } from '@angular/core';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatPaginator } from '@angular/material/paginator';
import { MatSidenav } from '@angular/material/sidenav';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatTableDataSource } from '@angular/material/table';
import { saveAs } from 'file-saver'; // Import the saveAs function

import { Router } from '@angular/router';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import { LoaderService } from 'app/services/loader.service';

@Component({
  selector: 'app-manage-admin',
  templateUrl: './manage-admin.component.html',
  styleUrls: ['./manage-admin.component.scss']
})
export class ManageAdminComponent {
  constructor(
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    private snackBar: MatSnackBar,
    private loader : LoaderService,
    private _snackBar: MatSnackBar
  ) {
    this.getAdmins();
  }
  selectedCategory: string = 'blog';
  searchTerm: string = '';
  selectedElement: any;
  @ViewChild(MatPaginator) paginator: MatPaginator;
  
  displayedColumns: string[] = [
    'select',
    'id',
    'email',
    'attemptCount',
    'createAt',
    'createBy',
    'active',
    'locked',
    'deleted'
  ];
  admins: MatTableDataSource<any>;
  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  data: any;
  showFiller: Boolean = false;
  row: any;
  selectedElements: any[] = [];
  index: number;
  @ViewChild('sidenav') sidenav: MatSidenav;
  
  ngAfterViewInit() {
    this.admins.paginator = this.paginator;
  }


  getAdmins(){
    this.miscellaneousService.getAdminList().subscribe((res) => {
      console.log('Response:', res); // Check the response
      const adminArray = Object.values(res);
      console.log('Admin Array:', adminArray); // Check the adminArray
      this.admins = new MatTableDataSource(adminArray.map((item: any) => ({ ...item, selected: false })));
      this.admins.paginator = this.paginator;
    });
  }
  
  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  selectAll(event: any) {
    const isChecked = event.checked;
    this.admins.data.forEach((element: any) => {
      element.selected = isChecked;
    });
    this.updateSelectedElements();
  }

  updateSelectedElements() {
    this.selectedElements = this.admins.data.filter((element: any) => element.selected);
  }
  editUser() {
    // this.row = new Array();
    this.row = this.selectedElement;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  deleteUser() {
    this.menuTrigger.closeMenu();
    // this.miscellaneousService.deleteBlog(this.selectedElement['id']).subscribe((res) => {
    //   console.log(res);
    //   this.getAdmins();
    //   this.showSuccessToast('Deleted Successfully')
    // }, (error) => {
    //   this.showErrorToast('Failed Delete')
    // }
    // )
  }

  toggle(row, element) {
    // drawer.toggle()
    this.selectedElement = element
  }

  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    this.admins.filter = this.searchTerm.trim().toLowerCase();
  }
  add(event) {
    console.log(event);
    this.router.navigate(['/miscellaneous/admin/addAdmin']);
  }

  export(event) {
    if (this.selectedElements.length === 0) {
      this.showErrorToast('No items selected for export.');
      return;
    }

    const csvData = this.convertToCSV(this.selectedElements);
    const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });
    saveAs(blob, 'selected_admins.csv');
  }

  convertToCSV(data: any[]): string {
    const header = Object.keys(data[0]).join(',');
    const csv = data.map((row) => Object.values(row).join(',')).join('\n');
    return `${header}\n${csv}`;
  }
  // slideToggleChange(event: any, element: any) {
  //   const newStatus = event.checked ? 'Active' : 'Inactive';
  //   // You can now update the status in your data or perform any other actions.
  //   // For example, you might want to call an API to update the status on the server.
  //   console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
  //   this.updatestatus(newStatus, element);
  // }
  // updatestatus(newStatus, element) {
  //   let body = {
  //     "id": element.id,
  //     "title": element.title,
  //     "status": newStatus === 'Active',
  //     "type": element.type,
  //     "readTimeSpan": element.readTimeSpan,
  //     "data": element.data,
  //     "category": element.category,
  //     "deviceType": element.deviceType,
  //     "author": element.author,
  //   }
  //   this.miscellaneousService.upddateBlog(body, "1").subscribe(
  //     (res) => {
  //       console.log(res);
  //       this.showSuccessToast('Update successful');
  //     },
  //     (error) => {
  //       console.error(error);
  //       this.showErrorToast('Update failed');
  //     }
  //   );
  // }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  cancel() {
    this.sidenav.toggle();
    this.router.navigate(['/miscellaneous/admin']);
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
