import { E } from '@angular/cdk/keycodes';
import { Component, ViewChild } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatPaginator } from '@angular/material/paginator';
import { MatSidenav } from '@angular/material/sidenav';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import { UserManagementService } from 'app/services/user-management.service';
import moment from 'moment';

@Component({
  selector: 'app-faqs',
  templateUrl: './faqs.component.html',
  styleUrls: ['./faqs.component.scss']
})
export class FaqsComponent {
  @ViewChild('sidenav') sidenav: MatSidenav;
  @ViewChild('paginator1') paginator1: MatPaginator;
  @ViewChild('paginator2') paginator2: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  searchTerm: string = '';
  dataSource1: MatTableDataSource<any>;
  dataSource2: MatTableDataSource<any>;
  type = 'All'
  // ... existing code ...
  showFiller = false;
  row: any;
  selectedData: any
  data: any;
  displayedColumns: string[] = ['id', 'title', 'description', 'createdAt', 'active','action'];
  collaborators: any;
  collaboratorsTable: MatTableDataSource<any>;
  constructor(
    private userManagementService: UserManagementService,
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader : LoaderService,
    private _snackBar: MatSnackBar
  ) {
    this.getFaqs('Users')
  }
  exportCollaboratorsToCSV() {
    const csvData = this.collaboratorsTable.data.map(item => ({
      id: item.id,
      name: item.name,
      mobile: item.mobile,
      city: item.city,
      email: item.email
    }));
    const csvContent = this.convertToCSV(csvData);
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8' });
    // saveAs(blob, 'collaborators.csv');
  }

  convertToCSV(data: any[]): string {
    const header = Object.keys(data[0]).join(',');
    const rows = data.map(item => Object.values(item).join(','));
    return `${header}\n${rows.join('\n')}`;
  }

  ngAfterViewInit() {
    // this.dataSource3.paginator = this.paginator1;
    // this.collaboratorsTable.paginator = this.paginator;
    // this.collaboratorsTable.sort = this.sort; // Add this line to enable sorting
  }

  getFaqs(type: string) {
    console.log(type);
    this.miscellaneousService.getFaqsByType(type == 'Users' ? 'user' : 'collaborator').subscribe((res: Array<any>) => {
      // this.userManagementService.getCollaboratorsByType(type).subscribe((res: Array<any>) => { 
      this.data = res;
      if (type == 'Users') {
        const dataSource1 = Object.values(res);
        this.dataSource1 = new MatTableDataSource(
          dataSource1.map((item: any) => ({ ...item }))
        );
        this.dataSource1.paginator = this.paginator1;
        this.dataSource1.sort = this.sort; // Add this line to enable sorting
      } else if (type == 'Partner') {
        const dataSource2 = Object.values(res);
        this.dataSource2 = new MatTableDataSource(
          dataSource2.map((item: any) => ({ ...item }))
        );
        this.dataSource2.paginator = this.paginator2;
        this.dataSource2.sort = this.sort;
      }

      // this.collaboratorsTable.filterPredicate = this.createFilter(); // Add this line to enable custom filtering
    });
  }

  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  slideToggleChange(event, elemt) {
    // console.log(event['checked']);
    elemt['status'] = event['checked'];
    this.miscellaneousService.chnageFaqStatus(elemt).subscribe((res) => {
      console.log(res);
      this.showSuccessToast("Successfully Updated")
    }, (error) => {
      this.showErrorToast('Failed to update')
    }
    )
  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }

  createFilter(): (data: any, filter: string) => boolean {
    let filterFunction = function (data, filter): boolean {
      const searchTerms = filter.split(' ').map((term) => term.toLowerCase());
      for (const searchTerm of searchTerms) {
        if (
          data.collaboratorName.toLowerCase().indexOf(searchTerm) !== -1 ||
          data.id.toLowerCase().indexOf(searchTerm) !== -1 ||
          data.mobile.toLowerCase().indexOf(searchTerm) !== -1
        ) {
          return true;
        }
      }
      return false;
    };
    return filterFunction;
  }

  tabClick(tab) {
    this.type = tab['tab']['textLabel'];
    this.miscellaneousService.getFaqsByType(this.type == 'Users' ? 'user' : 'collaborator').subscribe((res: Array<any>) => {
      res.forEach((el) => {
        // console.log(el['name']);
        // el['collaboratorName'] = el['collaboratorName'] ? el['collaboratorName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
        // el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      })
      this.data = res
      if (tab['tab']['textLabel'] == 'Users') {
        const dataSource1 = Object.values(res);
        this.dataSource1 = new MatTableDataSource(
          dataSource1.map((item: any) => ({ ...item }))
        );
        this.dataSource1.paginator = this.paginator1;
        this.dataSource1.sort = this.sort; // Add this line to enable sorting
      } else if (tab['tab']['textLabel'] == 'Partner') {
        const dataSource2 = Object.values(res);
        this.dataSource2 = new MatTableDataSource(
          dataSource2.map((item: any) => ({ ...item }))
        );
        this.dataSource2.paginator = this.paginator2;
        this.dataSource2.sort = this.sort;
      }
    })
  }

  addCollaborator() {
    // 'petParent/addUser'
    this.router.navigate(['/miscellaneous/faqs/addFaq']);
  }

  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  editUser() {
    this.row = this.selectedData;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  clickTitle(element) {
    console.log(element);
    
    this.row = this.selectedData;
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  deleteUser() {
    // this.menuTrigger.closeMenu();
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.miscellaneousService.deleteFaq(this.selectedData['id']).subscribe((res) => {
          // this.getCollaborators('All');
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Faq delted Successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        }, (error) => {
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Something Went Wrong!', success: false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
  }

  cancel() {
    this.sidenav.toggle();
  }

  toggle(element) {
    console.log(element);
    
    // drawer.toggle()
    this.selectedData = element;
  }

  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    if (this.type == 'Users') {
      this.dataSource1.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.type == 'Partner') {
      this.dataSource2.filter = this.searchTerm.trim().toLowerCase();
    }
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

}
