import { Component, ViewChild } from '@angular/core';
import { MiscellaneousService } from '../../../services/miscellaneous.service';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { Router } from '@angular/router';
import { MatSidenav } from '@angular/material/sidenav';
import { MatSnackBar } from '@angular/material/snack-bar';
import moment from 'moment';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { SelectionModel } from '@angular/cdk/collections';

@Component({
  selector: 'app-events',
  templateUrl: './events.component.html',
  styleUrls: ['./events.component.scss'],
})
export class EventsComponent {
  searchTerm: string = '';
  showFiller: boolean = false;
  data: any;
  index: any;
  selection = new SelectionModel<any>(true, []); 
  selectedEl: any
  row: any;
  @ViewChild(MatPaginator) paginator: MatPaginator;
  displayedColumns: string[] = [
    'selector',
    'id',
    'name',
    'city',
    'scheduledDate',
    'eventType',
    'price',
    'active',
    'test',
    'action',
  ];
  events: MatTableDataSource<any>;
  constructor(
    private miscellaneousService: MiscellaneousService,
    private snackBar: MatSnackBar,
    private router: Router,
    private dialog: MatDialog,
    private loader: LoaderService,
    private _snackBar: MatSnackBar,
  ) {
    this.getEvents();
  }
  ngAfterViewInit() {
    this.events.paginator = this.paginator;
  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }

  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  selectAll(event) {
    const checked = event.checked;
    if (checked) {
      this.selection.select(...this.events.data); // Select all rows
    } else {
      this.selection.clear(); // Deselect all rows
    }
  }

  getEvents() {
    let ary = [];
    this.loader.showLoader()
    this.miscellaneousService.getEvent().subscribe((res: Array<any>) => {
      this.loader.hideLoader()
      this.data = res;
      res.forEach((el) => {
        // el['scheduledDate'] = moment.utc(el['scheduledDate']).local().format("DD-MMM-YYYY");
        // console.log(el['name']);
        // el['name'] = el['name'] ? el['name'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
        el['title'] = el['title'] ? el['title'][0].toUpperCase() + el['title'].slice(1).toLowerCase() : '';
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        if (!this.showAll) {
          if (el.status === 'Active') {
            ary.push(el)
          }
        } else {
          ary.push(el)
        }
        // .capitalize()
      })
      const eventsArray = Object.values(ary);
      this.events = new MatTableDataSource(
        eventsArray.map((item: any) => ({
          ...item,
        }))
      );
      this.events.paginator = this.paginator;
    });
  }

  showAll: boolean = false;
  showDataEvent(event) {
    this.showAll = !this.showAll;
    this.getEvents()
  }
  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  @ViewChild('sidenav') sidenav: MatSidenav;
  editUser() {
    this.showFiller = true;
    this.row = this.selectedEl
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    
    this.showFiller = true;
    this.row = this.selectedEl
    this.row = element;
    this.sidenav.toggle();
  }
  deleteUser() {
    // this.menuTrigger.closeMenu();    
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.miscellaneousService.deleteEvent(this.selectedEl['id']).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          this.getEvents()
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Event deleted successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        }, (error) => {
          this.loader.hideLoader();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Something Went Wrong!', success: false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })

  }
  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }
  applyFilter() {
    this.events.filter = this.searchTerm.trim().toLowerCase();
  }

  toggle(i, element) {
    // drawer.toggle()
    this.index = i;
    this.selectedEl = element
  }

  cancel() {
    this.getEvents();
    this.sidenav.toggle();
  }

  add(event) {
    console.log(event);
    this.router.navigate(['/miscellaneous/events/addEvent']);
  }

  export(event) {
    
  const selectedRows = this.selection.selected; // Get selected rows

  if (selectedRows.length > 0) {
    this.miscellaneousService.exportData(selectedRows);
    this.showSuccessToast('Export successful');
  } else {
    this.showErrorToast('No rows selected for export');
  }
  }

  isAllSelected() {
    const numSelected = this.selection.selected.length;
    const numRows = this.events.data.length;
    return numSelected === numRows;
  }
  
  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Inactive';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
    this.updatestatus(newStatus, element);
  }

  updatestatus(newStatus, element) {
    console.log(element);
    element['status'] = newStatus;
    // let body = {
    //   "id": element.id,
    //   "scheduledDate": element.scheduledDate,
    //   "title": element.title,
    //   "description": element.description,
    //   "bookingLink": element.bookingLink,
    //   "eventType": element.eventType,
    //   "entryFee": element.entryFee,
    //   "status": newStatus,
    //   "phone" : element.phone,
    //   "likes": element.likes,
    //   "shares": element.shares,
    //   "address": {
    //     "address": element.address.address,
    //     "city": element.address.city,
    //     "state": element.address.state,
    //     "pinCode": element.address.pincode,
    //     "latitude": element.address.latitude,
    //     "longitude": element.address.longitude,
    //   },
    //   "prices": element.prices,
    //   "deviceType": element.deviceType,
    //   "terms": element.terms,
    // }
    this.loader.showLoader();
    this.miscellaneousService.updateEvent(element.id, element).subscribe(
      (res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast('Update successful');
      },
      (error) => {
        this.loader.hideLoader();
        console.error(error);
        this.showErrorToast('Update failed');
      }
    );
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  testChange(event, element) {
    this.loader.showLoader();
    this.miscellaneousService.testChange('EVENTS', element['id'], event['checked']).subscribe((res) => {
      this.loader.hideLoader()
      this.showSuccessToast('SuccessFully Done')
    },
      (error) => {
        this.loader.hideLoader();
        this.showErrorToast('Failed...')
      }
    )
  }
}

// evenet
// appointment
// webinar/course
// yamadhe payment service call hote
// yacha callback madhe check karaycha aahe
// payment
