import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { AdoptionManagementService } from 'app/services/adoption-management.service';
import { EducationService } from 'app/services/education.service';
import { LoaderService } from 'app/services/loader.service';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import moment from 'moment';

@Component({
  selector: 'app-create-advertisement',
  templateUrl: './create-advertisement.component.html',
  styleUrls: ['./create-advertisement.component.scss']
})
export class CreateAdvertisementComponent {
  form: FormGroup;
  @Input() editData: any;
  
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controlls: any;
  constructor(private fb: FormBuilder,
    private router: Router,
    private miscellaneousService: MiscellaneousService,
    private educationService : EducationService,
    private workspaceManagementService : WorkspaceManagementService,
    private adoptionManagementService : AdoptionManagementService,
    private snackBar: MatSnackBar,
    private dialog : MatDialog,
    private loader : LoaderService
  ) {
    this.craeteFormControllers();
    this.createForm();
  }
  ngOnInit() {
    // this.form.get('advertisementType').valueChanges.subscribe((chnage2)=>{
    //   this.onAdvertiserForChange(chnage2);
    // })
  }
  ngOnChanges() {
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }
  }
  onAdvertiserForChange(chnage2){
    let type = this.form.get('advertisementFor');
    // this.form.get('advertisementType').valueChanges.subscribe((chnage2)=>{
      console.log(chnage2);
      console.log(type.value);
      this.controlls['advertiserName']['options'] = [];
      if(chnage2 == 'Details'){
        if(type.value == 'WEBINAR'){
          this.educationService.getAllWebiars().subscribe((res:Array<any>)=>{
            res.forEach((el)=>{
              this.controlls['advertiserName']['options'].push(
                {
                  name: el['title'],
                  value: el['title']
                }
              )
            })
          })
        }else if(type.value == 'COURSE'){
          this.educationService.getCources().subscribe((res : Array<any>)=>{
            res.forEach((el)=>{
              this.controlls['advertiserName']['options'].push(
                {
                  name: el['title'],
                  value: el['title']
                }
              )
            })
          })
        }else if(type .value== 'VET'){
          this.workspaceManagementService.getWorkSpaces('d8d71038-c48c-11ed-abc1-02817ef0919c').subscribe((res : Array<any>)=>{
            console.log(res);
            res.forEach((el)=>{
              this.controlls['advertiserName']['options'].push(
                {
                  name: el['workplaceName'],
                  value: el['workplaceName']
                }
              )
            })
          })
          
        }else if(type.value == 'GROOMER'){
          this.workspaceManagementService.getWorkSpaces('5e4c6b60-c48e-11ed-abc1-02817ef0919c').subscribe((res : Array<any>)=>{
            console.log(res);
            res.forEach((el)=>{
              this.controlls['advertiserName']['options'].push(
                {
                  name: el['workplaceName'],
                  value: el['workplaceName']
                }
              )
            })
          })
        }else if(type.value == 'NGO'){
          this.workspaceManagementService.getWorkSpaces('5e4a1033-c48e-11ed-abc1-02817ef0919c').subscribe((res : Array<any>)=>{
            console.log(res);
            res.forEach((el)=>{
              this.controlls['advertiserName']['options'].push(
                {
                  name: el['workplaceName'],
                  value: el['workplaceName']
                }
              )
            })
          })
        }else if(type.value == 'ADOPTION'){
          this.adoptionManagementService.getPetAdoptons('1').subscribe((res : Array<any>)=>{
            console.log(res);
            res.forEach((el)=>{
              this.controlls['advertiserName']['options'].push(
                {
                  name: el['petName'],
                  value: el['petName']
                }
              )
            })
            
          })
        }
      }
    // })
  }
  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/miscellaneous/advertisment']);
  }
  
  edit() {
    console.log(this.editData);
    this.form = this.fb.group({
      advertisementFor: [this.editData['type'], Validators.required],
      advertisementType : [this.editData['subType']],
      advertiserName : [this.editData['advertiserName']],
      title: [this.editData['title'], Validators.required],
      description: [this.editData['description'], Validators.required],
      startDate: [new Date(this.editData['startDate']), Validators.required],//moment(json['startDate']).unix()
      endDate: [new Date(this.editData['endDate'])],
      linkType : [null],
      internalLink : [this.editData['internalLink']],
      externalLink : [this.editData['externalLink']],
      link: [''],
      fileType: [this.editData['fileView']],
      file: [this.editData['file'], Validators.required],
      internalNotes: [''],
    })
    if(this.editData['fileView'] == 'video'){
      this.form.get('fileType').setValue('video/*')
    }
    if(this.editData['fileView'] == 'image'){
      this.form.get('fileType').setValue('image/*')//image/*
    }
    if(this.editData['internalLink']){
      this.form.get('linkType').setValue('Internal Link')
    }
    if(this.editData['externalLink']){
      this.form.get('linkType').setValue('External Link')
    }
  }

  createForm() {
    this.form = this.fb.group({
      advertisementFor: ['', Validators.required],
      advertisementType : ['List'],
      advertiserName : [''],
      title: ['', Validators.required],
      description: ['', Validators.required],
      startDate: ['', Validators.required],
      endDate: [''],
      linkType: ['', Validators.required],
      internalLink : [''],
      externalLink : [''],
      link: ['', Validators.required],
      fileType: [''],
      file: ['', Validators.required],
      internalNotes: [''],
    })
  }

  craeteFormControllers() {
    this.controlls = {
      advertisementFor: {
        id: "advertisementFor",
        name: 'advertisementFor',
        label: "Advertisement for",
        required: true,
        type: "dropdown",
        options: [
          {
            name: "ROLL",
            value: "ROLL"
          }, {
            name: "EVENT",
            value: "EVENT"
          },
          {
            name: "BLOG",
            value: "BLOG"
          },
          {
            name: "ARTICLE",
            value: "ARTICLE"
          },
          {
            name: "WEBINAR",
            value: "WEBINAR"
          },
          {
            name: "COURSE",
            value: "COURSE"
          }, {
            name: "VET",
            value: "VET"
          }, {
            name: "GROMMER",
            value: "GROMMER"
          }, {
            name: "NGO",
            value: "NGO"
          }, {
            name: "ADOPTION",
            value: "ADOPTION"
          }

        ]
      },
      advertisementType :{
        id: "advertisementType",
        name: 'advertisementType',
        label: "advertisement Type",
        required: true,
        placeholder: "",
        type: "radio",
        options: [
          {
            name: "List",
            value: "List"
          }, {
            name: "Details",
            value: "Details"
          }
        ]
      },
      advertiserName : {
        id: "advertiserName",
        name: 'advertiserName',
        label: "Advertiser Name",
        required: true,
        placeholder: "Enter advertiser Name",
        type: "text",
        options: []
      },
      title: {
        id: "title",
        name: 'title',
        label: "Title",
        required: true,
        placeholder: "Enter Title",
        type: "text"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description",
        required: true,
        placeholder: "Enter Description",
        type: "text",
      },
      startDate: {
        id: "startDate",
        name: 'startDate',
        label: "start Date",
        required: true,
        placeholder: "Enter start Date",
        type: "text"
      },
      endDate: {
        id: "endDate",
        name: 'endDate',
        label: "End Date",
        required: true,
        placeholder: "Enter End Date",
        type: "text"
      },
      linkType: {
        id: "linkType",
        name: 'linkType',
        label: "Advertisement link",
        required: true,
        placeholder: "",
        type: "radio",
        options: [
          {
            name: "Internal Link",
            value: "Internal Link"
          }, {
            name: "External Link",
            value: "External Link"
          }
        ]
      },
      internalLink: {
        id: "internalLink",
        name: 'internalLink',
        label: "Internal Link",
        required: true,
        placeholder: "Enter Link",
        type: "text"
      },
      externalLink : {
        id: "externalLink",
        name: 'externalLink',
        label: "External Link",
        required: true,
        placeholder: "Enter Link",
        type: "text"
      },
      fileType: {
        id: "fileType",
        name: 'fileType',
        label: "File Type",
        required: true,
        placeholder: "Enter address",
        type: "radio",
        options: [
          {
            name: "Image",
            value: "image/*"
          }, {
            name: "Video",
            value: "video/*"
          }
        ]
      },
      file: {
        id: "file",
        name: 'file',
        label: "Upload File",
        required: true,
        placeholder: "Upload File",
        type: "text"
      },
      internalNotes: {
        id: "internalNotes",
        name: 'internalNotes',
        label: "Internal Notes",
        required: true,
        type: "text",

      },

    }
  }

  create() {
    let json = this.form.value;
    console.log(json);
    let body = {
      "title": json['title'],
      "description": json['description'],
      "status": this.editData? this.editData['status']:'Active',
      "startDate": moment(json['startDate']).unix(),//moment(json['startDate']).unix()
      "endDate": moment(json['endDate']).unix(),
      "advertiserName": json['advertiserName'],
      "rawData": json['internalNotes'],
      "filePath": json['file'],
      "type": json['advertisementFor'],
      "internalLink": json['internalLink'],
      "externalLink" : json['externalLink'],
      "viewedCount": 2,
      "subType": json['advertisementType'],
      "refId": ""
    }
    if (this.editData) {
      body['id'] = this.editData['id'];
      this.miscellaneousService.editAdvertisement(body['id'],body).subscribe((res)=>{
        console.log(res);
      })
    } else {      
      this.miscellaneousService.createAdvertisement(body).subscribe((res)=>{
        console.log(res);
        
      })
    }

  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

}

