import { Component, ViewChild } from '@angular/core';
import { MiscellaneousService } from '../../../services/miscellaneous.service';
import { MatMenuTrigger } from '@angular/material/menu';
import { Router } from '@angular/router';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { saveAs } from 'file-saver'; // Import the saveAs function
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatSidenav } from '@angular/material/sidenav';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';

@Component({
  selector: 'app-blog-article',
  templateUrl: './blog-article.component.html',
  styleUrls: ['./blog-article.component.scss'],
})
export class BlogArticleComponent {
  selectedCategory: string = sessionStorage.getItem('type') ? sessionStorage.getItem('type') : 'blog';
  searchTerm: string = '';
  lastActiveTabIndex: number = 0;
  selectedElement: any;
  @ViewChild(MatPaginator) paginator1: MatPaginator;
  @ViewChild(MatPaginator) paginator2: MatPaginator;
  displayedColumns: string[] = [
    'selector',
    'id',
    'title',
    'readTimeSpan',
    'data',
    'active',
    'test',
    'action',
  ];
  blogs: MatTableDataSource<any>;
  articles: MatTableDataSource<any>;

  constructor(
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader: LoaderService,
    private _snackBar: MatSnackBar,
  ) {
    this.getBlogs(this.selectedCategory);
  }
  ngOnInit() {
    console.log(this.selectedCategory);
    const storedIndex = sessionStorage.getItem('lastActiveTabIndex');
    this.lastActiveTabIndex = storedIndex ? parseInt(storedIndex, 10) : 0;
    this.tabClick({ index: this.lastActiveTabIndex, tab: { textLabel: this.selectedCategory } })
    this.loadWorkspaces(this.lastActiveTabIndex)
  }

  ngAfterViewInit() {
    this.blogs.paginator = this.paginator1;
    this.articles.paginator = this.paginator2;
  }

  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }
  
  loadWorkspaces(index: number) {
    switch (index) {
      case 0:
        this.getBlogs(this.selectedCategory)
        break;
      case 1:
        this.getBlogs(this.selectedCategory)
        break;
      default:
        break;
    }
  }
  // showArticleList(): void {
  //   this.getBlogs('article');
  //   this.selectedCategory = 'article';
  // }

  // showBlogList(): void {
  //   this.getBlogs('blog');
  //   this.selectedCategory = 'blog';
  // }
  getBlogs(category: string) {
    let ary = []
    this.loader.showLoader();
    this.miscellaneousService.getBlogs(false, category).subscribe((res: Array<any>) => {
      this.loader.hideLoader()
      res.forEach((el) => {
        if (!this.showAll) {
          if (el.status === true) {
            ary.push(el)
          }
        } else {
          ary.push(el)
        }
      })
      this.data = res
      const blogArray = Object.values(ary);
      if (category == 'blog') {
        this.blogs = new MatTableDataSource(
          blogArray.map((item: any) => ({
            ...item,

          }))
        );
        this.blogs.paginator = this.paginator1;
      }
      if (category == 'article') {
        this.articles = new MatTableDataSource(
          blogArray.map((item: any) => ({
            ...item,

          }))
        );
        this.blogs.paginator = this.paginator2;
      }

    }, (error) => {
      this.loader.hideLoader();
    });
  }

  showAll: boolean = false;
  showDataEvent(event) {
    this.showAll = !this.showAll;
    this.getBlogs(this.selectedCategory)
  }

  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  data: any;
  showFiller: Boolean = false;
  row: any;
  index: number;
  @ViewChild('sidenav') sidenav: MatSidenav;
  editUser() {
    // this.row = new Array();
    this.row = this.selectedElement;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  clickTitle(element) {
    console.log(element);
    
    // this.row = new Array();
    this.row = this.selectedElement;
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  deleteUser() {
    this.menuTrigger.closeMenu();
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.miscellaneousService.deleteBlog(this.selectedElement['id']).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          this.getBlogs('blog');
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Blog deleted successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        },
          (error) => {
            this.loader.hideLoader()
            const dialogRef = this.dialog.open(SuccessDialogComponent, {
              width: '300px',
              data: { message: 'Something Went Wrong!', success: false }
            });
          })


      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
  }

  tabClick(tab) {
    if (tab['tab']['textLabel'] == "Blogs") {
      this.getBlogs("blog");
      this.selectedCategory = 'blog'
    }
    if (tab['tab']['textLabel'] == "Educational Blogs") {
      this.getBlogs("article");
      this.selectedCategory = 'article'
    }
    sessionStorage.setItem("type", this.selectedCategory)
    sessionStorage.setItem("lastActiveTabIndex", tab.index.toString())

  }

  toggle(row, element) {
    // drawer.toggle()
    this.selectedElement = element
  }

  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    if (this.selectedCategory == 'blog') {
      this.blogs.filter = this.searchTerm.trim().toLowerCase();
    }
    if (this.selectedCategory == 'article') {
      this.articles.filter = this.searchTerm.trim().toLowerCase();
    }
  }
  add(event) {
    console.log(event);
    this.router.navigate(['/miscellaneous/blog/addBlog']);
  }

  getSelectedRows(): any[] {
    if (this.selectedCategory === 'blog') {
      return this.blogs.data.filter(row => row.selected);
    } else {
      return this.articles.data.filter(row => row.selected);
    }
  }
  
  export(event) {
    const selectedRows = this.getSelectedRows();
    if (selectedRows.length === 0) {
      this.openSnackBar('No rows selected for export');
      return;
    }

    const csvData = this.convertToCSV(selectedRows);
    const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });

    saveAs(blob, `${this.selectedCategory}.csv`);
  }

  convertToCSV(data: any[]): string {
    if (data.length === 0) {
      return '';
    }
    const header = Object.keys(data[0]).join(',');
    const csv = data.map((row) => Object.values(row).join(',')).join('\n');
    return `${header}\n${csv}`;
  }
  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Inactive';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
    this.updatestatus(newStatus, element);
  }
  updatestatus(newStatus, element) {
    element['status'] = newStatus === 'Active';
    
    this.loader.showLoader()
    this.miscellaneousService.upddateBlog(element, element.id).subscribe(
      (res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast('Update successful');
      },
      (error) => {
        this.loader.hideLoader()
        console.error(error);
        this.showErrorToast('Update failed');
      }
    );
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  cancel() {
    this.getBlogs(this.selectedCategory);
    this.sidenav.toggle();
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  testChange(event, element) {
    this.loader.showLoader()
    this.miscellaneousService.testChange('BLOGS_ARTICLES', element['id'], event['checked']).subscribe((res) => {
      this.loader.hideLoader()
      this.showSuccessToast('SuccessFully Done')
    },
      (error) => {
        this.loader.hideLoader()
        this.showErrorToast('Failed...')
      }
    )
  }
}
