import { Component, ViewChild } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatSidenav } from '@angular/material/sidenav';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { CouponManagementService } from 'app/services/coupon-management.service';
import { LoaderService } from 'app/services/loader.service';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import moment from 'moment';

@Component({
  selector: 'app-advertisement',
  templateUrl: './advertisement.component.html',
  styleUrls: ['./advertisement.component.scss']
})
export class AdvertisementComponent {
  data: any;
  row: any;
  index;
  showFiller: Boolean = false;
  @ViewChild('sidenav') sidenav: MatSidenav;
  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  advertisementData: MatTableDataSource<any>;;
  displayedColumns: string[] = ['selector','id', 'title', 'advertisementFor', 'description', 'startDate', 'endDate', 'status','subType', 'action'];
  constructor(
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    private couponManagementService: CouponManagementService,
    private dialog: MatDialog,
    private loader: LoaderService,
    private _snackBar: MatSnackBar,
  ) {
    this.getAdvertisement();
  }

  getAdvertisement() {
    let ary = [];
    this.miscellaneousService.getAdvertisement().subscribe((res: any) => {
      console.log(res);
      this.data = res;
      res.forEach((el) => {
        el['startDate'] = moment.utc(el['startDate']).local().format("DD-MMM-YYYY");
        el['endDate'] = moment.utc(el['endDate']).local().format("DD-MMM-YYYY");
        // console.log(el['name']);
        el['title'] = el['title'] ? el['title'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : '';
        if (!this.showAll) {
          if (el.status === 'Active') {
            ary.push(el)
          }
        } else {
          ary.push(el)
        }
        // el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      })
      const array = Object.values(ary);
      this.advertisementData = new MatTableDataSource(array.map((item: any) => ({ ...item, })));
    })
  }

  showAll: boolean = false;
  showDataEvent(event) {
    this.showAll = !this.showAll;
    this.getAdvertisement()
  }
  
  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }
  
  filter(event) {

  }
  add(event) {
    this.router.navigate(['/miscellaneous/advertisment/createAdd']);
  }
  export(data: any[]) {
    const csvRows = [];
  
    // Get the headers
    const headers = ['ID', 'Title', 'Advertisement For', 'Description', 'Start Date', 'End Date', 'Status', 'Sub Type'];
    csvRows.push(headers.join(','));
  
    // Format the data
    data.forEach(row => {
      const values = [
        row.id,
        row.title,
        row.advertisementFor,
        row.description,
        row.startDate,
        row.endDate,
        row.status,
        row.subType
      ];
      csvRows.push(values.join(','));
    });
  
    // Create a Blob and download the CSV
    const blob = new Blob([csvRows.join('\n')], { type: 'text/csv' });
    const url = window.URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = 'advertisements.csv';
    a.click();
    window.URL.revokeObjectURL(url);
  }

  exportSelected() {
    // Get the selected rows
    const selectedRows = this.advertisementData.filteredData.filter(row => row.selected);
    
    // Implement export logic here, e.g., converting to CSV or Excel
    // For demonstration, let's log the selected rows
    console.log('Selected rows for export:', selectedRows);
    
    // Call a method to convert the data to CSV or another format and download it
    this.export(selectedRows);
  }

  deleteAdd() {

  }
  editAdd() {
    this.row = this.data[this.index];
    this.showFiller = true;
    this.sidenav.toggle();
  }
  clickTitle(element) {
    console.log(element);
    
    this.row = this.data[this.index];
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  toggle(index, row) {
    this.index = index;
    // this.row = row;
  }

  cancel() {
    this.sidenav.toggle();
    // this.menuTrigger.closeMenu();
    // this.router.navigate(['/miscellaneous/advertisment']);
  }
  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Inactive';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
    this.updatestatus(newStatus, element);
  }
  updatestatus(newStatus, element) {
    let body = {
      "id": element.id,
      "code": element.code,
      "createdBy": element.createdBy,
      "expiryDate": element.expiryDate,
      "couponName": element.couponName,
      "quantity": element.quantity,
      "discount": element.discount,
      "usedCount": element.usedCount,
      "endDate": element.endDate,
      "split": element.split,
      "publishedFor": element.publishedFor,
      "published": element.published,
      "collabDiscount": element.collabDiscount,
      "discountType": element.discountType,
      "active": newStatus === 'Active'
    }
    this.couponManagementService.updateCoupon("1", body, "1").subscribe(
      (res) => {
        console.log(res);
        this.showSuccessToast('Update successful');
      },
      (error) => {
        console.error(error);
        this.showErrorToast('Update failed');
      }
    );
  }

  private snackBar: MatSnackBar
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
