import { Component, EventEmitter, Inject, Input, Output } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Controller } from 'app/interfaces/controller';
import { LoaderService } from 'app/services/loader.service';
import { MiscellaneousService } from 'app/services/miscellaneous.service';

@Component({
  selector: 'app-add-ticket',
  templateUrl: './add-ticket.component.html',
  styleUrls: ['./add-ticket.component.scss']
})
export class AddTicketComponent {
  form : FormGroup;
  tickets;
  controller : Controller;
  eventId : string
  @Output() addTicket: EventEmitter<FormGroup> = new EventEmitter();

  constructor(
    private miscellaneousService : MiscellaneousService,
    public dialogRef: MatDialogRef<AddTicketComponent>,
    private snackBar: MatSnackBar,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private loader : LoaderService
    ){

  }
  ngOnInit(){
    this.form = this.data['form'];
    this.controller = this.data['controller']
    this.eventId = this.data['eventId']
    this.tickets = this.data['tickets']
   
  }

  onNoClick(){
    this.dialogRef.close()
  }

  add(){
    // debugger
    let json = this.form.value;  
    let data = {
      eventId: this.eventId,
      eventPrice: json['eventEntryFees'],
      ticketType: json['ticketType'],
      maxPerson : json['maxPerson']
    }
    this.tickets.push(this.form)
    this.dialogRef.close();
    if(this.eventId){
      this.miscellaneousService.addTicket(data).subscribe((res)=>{
        this.dialogRef.close()
        console.log(res);
        this.miscellaneousService.getEvent().subscribe((res) => {
          this.dialogRef.close();
        })
      })
    }
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
