import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-faq',
  templateUrl: './add-faq.component.html',
  styleUrls: ['./add-faq.component.scss']
})
export class AddFaqComponent {
  form: FormGroup;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controllers: any;
  constructor(private fb: FormBuilder,
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader : LoaderService

  ) {
    this.form = this.fb.group({
      type: ['', [Validators.required]],
      header: ['', [Validators.required]],
      body: ['', [Validators.required]],
    })

    this.craeteFormControllers()

  }
  ngOnInit() {

  }

  ngOnChanges() {
    console.log(this.editData);
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }
  }
  
  edit() {
    console.log(this.editData);
    this.form = this.fb.group({
      type: [this.editData['type'], [Validators.required]],
      header: [this.editData['title'], [Validators.required]],
      body: [this.editData['description'], [Validators.required]],
    })
  }

  craeteFormControllers() {
    this.controllers = {
      type: {
        id: "type",
        name: 'type',
        label: "Type",
        required: true,
        placeholder: "",
        options: [
          {
            name: "User",
            value: "user"
          },
          {
            name: "Partner",
            value: "collaborator"
          }

        ],
        type: "radio"
      },
      header: {
        id: "header",
        name: 'header',
        label: "Faq Header",
        required: true,
        placeholder: "Enter Mail Header",
        type: "string"
      },
      body: {
        id: "body",
        name: "body",
        label: "Faq Body*",
        placeholder: "",
        required: true,
      }
    }
  }

  addFaq() {
    let json = this.form.value;
    let data = {
      "title": json['header'],
      "description": json['body'],
      "parentId": "1",
      "status": true,
      "type": json["type"]
    }
    if (this.editData) {
      data["id"] = this.editData['id'];
      this.miscellaneousService.editFaq(data).subscribe((res) => {
        // this.userManagementService.addCollaboratorProfile(res['id'], this.form.get('filename').value).subscribe((res) => {
        // this.miscellaneousService.getFaqsByType(json['type']).subscribe((res) => {
        //   // this.router.navigate(['/miscellaneous/faqs']);
        //   const dialogRef = this.dialog.open(SuccessDialogComponent, {
        //     width: '300px',
        //     data: { message: 'Faq edited successfully!', success: true },
        //     panelClass: 'success-dialog-container'
        //   });
        // })
        // })
      }, (error) => {
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      })
    } else {
      this.miscellaneousService.addFaq(data).subscribe((res) => {
        this.miscellaneousService.getFaqsByType(json['type']).subscribe((res) => {
          // this.router.navigate(['/miscellaneous/faqs']);
        });
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'FAQ added successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
      }, (error) => {
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }
  cancel() {
    this.cancelEvent.emit()
    this.router.navigate(['/miscellaneous/faqs'])
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
