import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { Router } from '@angular/router';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import { AddTicketComponent } from '../add-ticket/add-ticket.component';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ValidationsService } from 'app/services/validations.service';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { TimeDateService } from 'app/services/time-date.service';
import { LoaderService } from 'app/services/loader.service';
import moment from 'moment';

@Component({
  selector: 'app-add-event',
  templateUrl: './add-event.component.html',
  styleUrls: ['./add-event.component.scss']
})
export class AddEventComponent {
  form: FormGroup;
  ticket: FormGroup;
  ticketIndex: number;
  controlls: any;
  @Input() editData: any;
  newTicket: boolean = false;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  constructor(
    private fb: FormBuilder,
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    public dialog: MatDialog,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private timeDateService: TimeDateService,
    private loader: LoaderService
  ) {
    this.createForm();
    this.createControlls();
  }

  ngOnInit() {
    this.form.get('toBeAnnounced').valueChanges.subscribe((change)=>{
      if(!change){
        debugger
        this.form.get('city').setValidators(Validators.required);
        this.form.get('city').updateValueAndValidity();
        this.form.get('state').setValidators(Validators.required);
        this.form.get('state').updateValueAndValidity();

        this.form.get('pincode').setValidators(Validators.required);
        this.form.get('pincode').updateValueAndValidity();

        this.form.get('address').setValidators(Validators.required);
        this.form.get('address').updateValueAndValidity();

        this.form.get('location').setValidators(Validators.required);
        this.form.get('location').updateValueAndValidity();
      }else{
        this.form.get('city').clearValidators()
        this.form.get('city').updateValueAndValidity();

        this.form.get('state').clearValidators()
        this.form.get('state').updateValueAndValidity();

        this.form.get('pincode').clearValidators()
        this.form.get('pincode').updateValueAndValidity();

        this.form.get('address').clearValidators()
        this.form.get('address').updateValueAndValidity();

        this.form.get('location').clearValidators()
        this.form.get('location').updateValueAndValidity();
      }
    })
    this.form.get('upComing').valueChanges.subscribe((change)=>{
      if(!change){
        this.form.get('eventTime').setValidators(Validators.required);
        this.form.get('eventTime').updateValueAndValidity();

        this.form.get('eventDate').setValidators(Validators.required);
        this.form.get('eventDate').updateValueAndValidity();
      }else{
        this.form.get('eventTime').clearValidators()
        this.form.get('eventTime').updateValueAndValidity();

        this.form.get('eventDate').clearValidators()
        this.form.get('eventDate').updateValueAndValidity();
      }
    })
    this.form.get('publishedFor').valueChanges.subscribe((change) => {
      if (change == 'FurrCrewApp') {
        this.form.get('image').clearValidators();
        this.form.get('image').updateValueAndValidity();
      } else {
        this.form.get('image').setValidators(Validators.required);
        this.form.get('image').updateValueAndValidity();
      }
    })
  }

  ngOnChanges() {
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save";
      this.edit();
    }
  }

  edit() {
    console.log(this.editData);

    // this.timeDateService.millisecondsToDateTime(this.timeDateService.convertUTCToIST(this.editData['scheduledDate'])).date
    this.form.get('city').setValue(this.editData['address']['city'])
    this.form.get('state').setValue(this.editData['address']['state'])
    this.form.get('pincode').setValue(this.editData['address']['pinCode'])
    this.form.get('address').setValue(this.editData['address']['address'])
    this.form.get('location').setValue(this.editData['address']['latitude'] + ',' + this.editData['address']['longitude'])
    this.form.get('eventDate').setValue(this.timeDateService.millisecondsToDateTime(this.editData['scheduledDate']).date)
    this.form.get('eventTime').setValue(this.timeDateService.millisecondsToDateTime(this.editData['scheduledDate']).time)
    this.form.get('phone').setValue(this.editData['phone'])
    this.form.get('image').setValue(this.editData['coverImage'])
    this.form.get('eventType').setValue(this.editData['eventType'])
    this.form.get('eventTitle').setValue(this.editData['title'])
    this.form.get('eventDescription').setValue(this.editData['description'])
    this.form.get('coverImage').setValue(this.editData['images'] ? this.editData['images'][0]['value'] : '')
    this.form.get('tAndC').setValue(this.editData['terms']);
    this.form.get('slug').setValue(this.editData['slug']);
    this.form.get('toBeAnnounced').setValue(this.editData['tba']);
    this.form.get('upComing').setValue(this.editData['upcoming'])
    this.form.get('isTest').setValue(this.editData['isTest'])//upcoming //tba
    this.form.get('eventLink').setValue(this.editData['bookingLink'])
    if (this.editData['deviceType'] == "MOBILE") {
      this.form.get('publishedFor').setValue('FurrCrewApp')
    } else if (this.editData['deviceType'] == "WEB") {
      this.form.get('publishedFor').setValue('WebSite')
    } else if (this.editData['deviceType'] == "BOTH") {
      this.form.get('publishedFor').setValue('Both')
    }
    if (this.form.get('publishedFor').value == 'FurrCrewApp') {
      this.form.get('image').clearValidators();
      this.form.get('image').updateValueAndValidity();
    } else {
      this.form.get('image').setValidators(Validators.required);
      this.form.get('image').updateValueAndValidity();
    }
    let array = this.form.get('tickets') as FormArray;
    array.clear();
    this.editData['prices'].forEach(ticket => {
      let formGroup = this.fb.group({
        eventEntryFees: [ticket['eventPrice'], Validators.required],
        ticketType: [ticket['ticketType'], Validators.required],
        maxPerson: [ticket['maxPerson'], Validators.required],
      })
      array.push(formGroup);
    });
  }

  createForm() {
    this.form = this.fb.group({
      city: [null, [Validators.required, this.validationsService.stringValidator()]],
      state: [null, [Validators.required, this.validationsService.stringValidator()]],
      pincode: [null, [Validators.required, this.validationsService.pincodeValidator()]],
      address: [null, [Validators.required, this.validationsService.stringValidator()]],
      location: [null, [Validators.required, this.validationsService.locationValidator()]],
      eventDate: [null, Validators.required],
      eventTime: [null, Validators.required],
      phone: [null, [Validators.required, this.validationsService.mobileNumberValidator()]],
      image: [null],
      coverImage: [null, [Validators.required]],
      eventLink: ['', [Validators.required]],
      eventType: [null, Validators.required],
      publishedFor: ['FurrCrewApp', Validators.required],
      eventTitle: [null, [Validators.required, this.validationsService.stringValidator()]],
      eventDescription: [null, [Validators.required, this.validationsService.stringValidator()]],
      tickets: this.fb.array([], Validators.required),
      slug: [null],
      isTest: [false],
      // eventEntryFees : [null, Validators.required],
      // ticketType : [null, Validators.required],
      // maxPerson : [null, Validators.required],
      tAndC: [null, Validators.required],
      toBeAnnounced : [false, Validators.required],
      upComing : [false, Validators.required]
    })
    // if (!this.editData) {
    //   this.addTicket();
    // }
  }

  createControlls() {
    this.controlls = {
      city: {
        id: "city",
        name: 'city',
        label: "Enter City",
        placeholder: "Enter City",
        required: true,
        type: "text"
      },
      state: {
        id: "state",
        name: 'state',
        label: "Enter State",
        placeholder: "Enter State",
        required: true,
        type: "text"
      },
      pincode: {
        id: "pincode",
        name: 'pincode',
        label: "Pincode",
        placeholder: "Enter Pincode",
        required: true,
        type: "text"
      },
      address: {
        id: "address",
        name: 'address',
        label: "Address",
        placeholder: "Enter address",
        required: true,
        type: "text"
      },
      location: {
        id: "location",
        name: 'location',
        label: "Location",
        placeholder: "0.0,0.0",
        required: true,
        type: "text"
      },
      eventDate: {
        id: "eventDate",
        name: 'eventDate',
        label: "Event Date",
        placeholder: "Enter EventDate",
        required: true,
        type: "text"
      },
      eventTime: {
        id: "eventTime",
        name: 'eventTime',
        label: "Event Time*",
        placeholder: "Enter EventTime",
        required: true,
        type: "text"
      },
      eventLink: {
        id: "eventLink",
        name: 'eventLink',
        label: "Event Google Sheet Link",
        placeholder: "Enter Link",
        required: true,
        type: "text"
      },
      phone: {
        id: "phone",
        name: 'phone',
        label: "Phone",
        placeholder: "Enter Phone",
        required: true,
        type: "text"
      },
      image: {
        id: "image",
        name: 'image',
        label: "Thumb Image*",
        placeholder: "Enter Image",
        required: true,
        type: "text"
      },
      coverImage: {
        id: "coverImage",
        name: 'coverImage',
        label: "Cover Image*",
        placeholder: "Cover Image",
        required: true,
        type: "text"
      },
      eventType: {
        id: "eventType",
        name: 'eventType',
        label: "Event Type",
        placeholder: "Enter Type",
        required: true,
        options: [
          {
            name: 'Online',
            value: 'Online'
          }, {
            name: 'Offline',
            value: 'Offline'
          }
        ],
        type: "radio"
      },
      publishedFor: {
        id: "publishedFor",
        name: 'publishedFor',
        label: "Published For",
        placeholder: "",
        required: true,
        options: [
          {
            name: 'FurrCrewApp',
            value: 'FurrCrewApp'
          }, {
            name: 'WebSite',
            value: 'WebSite'
          }, {
            name: 'Both',
            value: 'Both'
          }
        ],
        type: "radio"
      },
      eventTitle: {
        id: "eventTitle",
        name: 'eventTitle',
        label: "Event Title",
        placeholder: "Enter Title",
        required: true,
        type: "text"
      },
      eventDescription: {
        id: "eventDescription",
        name: 'eventDescription',
        label: "Event Description*",
        placeholder: "Enter Description",
        required: true,
        type: "text"
      },
      eventEntryFees: {
        id: "eventEntryFees",
        name: 'eventEntryFees',
        label: "Event Entry Fees",
        placeholder: "Event Entry Fees",
        required: true,
        type: "text"
      },
      slug: {
        id: "slug",
        name: "slug",
        label: "Custom Title",
        placeholder: "Custom Title",
        requied: true,
        type: "text"
      },
      ticketType: {
        id: "ticketType",
        name: 'ticketType',
        label: "Ticket Type",
        placeholder: "Ticket Type",
        required: true,
        type: "text"
      },
      maxPerson: {
        id: "maxPerson",
        name: 'maxPerson',
        label: "Max Person",
        placeholder: "Max Person",
        required: true,
        type: "text"
      },
      tAndC: {
        id: "tAndC",
        name: 'tAndC',
        label: "T&C*",
        placeholder: "T&C",
        required: true,
        type: "text"
      },
      isTest: {
        id: 'isTest',
        name: 'isTest',
        label: 'Test',
        placeholder: "",
        required: true,
        type: "boolean"
      },
      toBeAnnounced :{
        id: 'toBeAnnounced',
        name: 'toBeAnnounced',
        label: 'To Be Announced',
        placeholder: "",
        required: true,
        type: "boolean"
      },
      upComing :{
        id: 'upComing',
        name: 'upComing',
        label: 'Upcoming',
        placeholder: "",
        required: true,
        type: "boolean"
      }
    }
  }

  onNoClick(): void {
    this.router.navigate(['/miscellaneous/events']);
    this.cancelEvent.emit();
  }

  coverImageUpload(event) {
    console.log(event);
    if (this.editData) {
      this.loader.showLoader()
      this.miscellaneousService.addEventCoverImage(this.editData['id'], this.form.get('coverImage').value).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast("Uploaded Successfully")
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to Upload")
      }
      )
    }
  }

  fileUpload(event) {
    if (this.editData) {
      this.loader.showLoader()
      this.miscellaneousService.addEventImage(this.form.get('image').value, this.editData['id']).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast("Uploaded Successfully")
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to Upload")
      }
      )
    }
  }

  // timeDatetoMilliseconds(){
  //   this.timeDateService.dateTimeToMilliseconds(this.form.get('eventDate').value,this.form.get('eventTime').value).startTime
  // }
  create() {
    console.log(this.form);
    
    let json = this.form.value
    let body = {
      "scheduledDate": !json['upComing'] ? this.timeDateService.dateTimeToMilliseconds(this.form.get('eventDate').value, this.form.get('eventTime').value).startTime : Date.now(),
      "title": json['eventTitle'],
      "description": json['eventDescription'],
      "bookingLink": json['eventLink'],
      "eventType": json['eventType'],
      "entryFee": json['eventEntryFees'],
      "status": "Inactive", //"Active",
      "likes": this.editData ? this.editData['likes'] : 0,
      "terms": json['tAndC'],
      "phone": json['phone'],
      "shares": this.editData ? this.editData['shares'] : 0,
      "deviceType": "",
      "slug": json['slug'],
      "tba" : json['toBeAnnounced'],
      "upcoming" : json['upComing'],
      "prices": [],
      "test": json['isTest']

    }
    json['tickets'].forEach((ticket) => {
      body['prices'].push({
        "eventPrice": ticket['eventEntryFees'],
        "ticketType": ticket['ticketType'],
        "maxPerson": ticket['maxPerson']
      })
    })
    if (json['publishedFor'] == "FurrCrewApp") {
      body['deviceType'] = 'MOBILE';
    } else if (json['publishedFor'] == "WebSite") {
      body['deviceType'] = 'WEB'
    } else if (json['publishedFor'] == 'Both') {
      body['deviceType'] = "BOTH"
    }
    if (this.editData) {
      let addresData = {
        "id": this.editData['address']['id'],
        "eventId": this.editData['address']['eventId'],
        "address": json['address'],
        "city": json['city'],
        "state": json['state'],
        "pinCode": json['pincode'],
        "latitude": json['location'].split(",")[0].trim(),
        "longitude": json['location'].split(",")[1].trim()
      }
      body['id'] = this.editData['id'];
      body['address'] = this.editData['address'];
      body['status'] = this.editData['status']
      this.loader.showLoader()
      this.miscellaneousService.updateEvent(this.editData['id'], body).subscribe((res) => {
        this.miscellaneousService.updateEventAddress(addresData).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Event updated Successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
          this.onNoClick();
        })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    } else {
      body['address'] = {
        "address": json['toBeAnnounced'] ? 'tba': json['address'],
        "city": json['toBeAnnounced'] ?'tba' :  json['city'],
        "state": json['toBeAnnounced'] ?'tba' : json['state'],
        "pinCode": json['toBeAnnounced'] ? 413512 : json['pincode'],
        "latitude": json['toBeAnnounced'] ? 21.20: json['location'] ? json['location'].split(",")[0].trim(): 0,
        "longitude": json['toBeAnnounced'] ? 21.21: json['location'] ? json['location'].split(",")[1].trim(): 0,

      }
      this.loader.showLoader()
      this.miscellaneousService.createEvent(body).subscribe((res1) => {
        console.log(res1);
        this.miscellaneousService.addEventCoverImage(res1['id'], json['coverImage']).subscribe((res) => {

          console.log(res);
          if (json['image']) {
            this.miscellaneousService.addEventImage(json['image'], res1['id']).subscribe((res) => {
              console.log(res);
              this.miscellaneousService.getEvent().subscribe((res) => {
                const dialogRef = this.dialog.open(SuccessDialogComponent, {
                  width: '300px',
                  data: { message: 'Event created Successfully!', success: true },
                  panelClass: 'success-dialog-container'
                });
                this.onNoClick();
              })
            }, (error) => {
              this.loader.hideLoader()
              const dialogRef = this.dialog.open(SuccessDialogComponent, {
                width: '300px',
                data: { message: 'Something Went Wrong!', success: false }
              });
            }
            )
          } else {
            this.miscellaneousService.getEvent().subscribe((res) => {
              const dialogRef = this.dialog.open(SuccessDialogComponent, {
                width: '300px',
                data: { message: 'Event created Successfully!', success: true },
                panelClass: 'success-dialog-container'
              });
              this.onNoClick();
            })
          }
        }, (error) => {
          this.loader.hideLoader()
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Something Went Wrong!', success: false }
          });
        })


        this.loader.hideLoader();
        this.onNoClick();
      })
    }
  }

  addTicket() {
    let formGroup = this.fb.group({
      eventEntryFees: [null, [Validators.required, Validators.pattern('^[0-9]+$')]],
      ticketType: [null, Validators.required],
      maxPerson: [null, [Validators.required, Validators.pattern('^[0-9]+$')]],
      newTicket: [false]
    })
    let array = this.form.get('tickets') as FormArray;
    // array.push(formGroup);
    let dialogRef = this.dialog.open(AddTicketComponent, {
      data: { controller: this.controlls, form: formGroup, eventId: this.editData ? this.editData['id'] : '', tickets: array }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
    });

  }
  deleteTicket() {
    let array = this.form.get('tickets') as FormArray;
    array.removeAt(this.ticketIndex)
    if (this.editData) {
      this.loader.showLoader()
      this.miscellaneousService.deleteTicket(this.editData['prices'][this.ticketIndex]['id']).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
      })
    }
  }
  editTicket() {
    console.log("edit");
    let json = this.ticket.value
    let body = {
      id: this.editData['prices'][this.ticketIndex]['id'],
      eventPrice: json['eventEntryFees'],
      ticketType: json['ticketType'],
      maxPerson: json['maxPerson']
    }
    this.loader.showLoader()
    this.miscellaneousService.updateTicket(body).subscribe((res) => {
      this.loader.hideLoader()
      console.log(res);
    })
  }
  action(formGroup, i) {
    this.ticket = formGroup;
    this.ticketIndex = i;
    console.log("action");

  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
