import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-blog',
  templateUrl: './add-blog.component.html',
  styleUrls: ['./add-blog.component.scss']
})
export class AddBlogComponent {
  form: FormGroup;
  controlls: any;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  constructor(
    private fb: FormBuilder,
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader: LoaderService
  ) {
    this.createForm();
    this.createControlls();
  }

  ngOnChanges() {
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save";
      this.edit();
    }
  }

  ngOnInit() {
    console.log("blog article");
    console.log(sessionStorage.getItem('type'));
    
    this.form.get('blogOrArticle').setValue(sessionStorage.getItem('type'))
    this.form.get('PublishFor').valueChanges.subscribe((res) => {
      if (res == 'FurrCrewApp') {
        this.form.get('image').clearValidators();
        this.form.get('image').updateValueAndValidity();
      } else {
        this.form.get('image').setValidators(Validators.required);
        this.form.get('image').updateValueAndValidity();
      }
    })

  }

  edit() {
    this.form = this.fb.group({
      name: [this.editData['author'], [Validators.required, this.validationsService.stringValidator()]],
      image: [this.editData['images'][0]['value'], Validators.required],
      coverImage: [this.editData['coverImage']],
      tags: this.fb.array([]),//Validators.required
      blogOrArticle: [this.editData['category'], Validators.required],
      PublishFor: [this.editData['deviceType'], Validators.required],
      title: [this.editData['title'], [Validators.required, this.validationsService.stringValidator()]],
      readTime: [this.editData['readTimeSpan'], Validators.required],
      bodyTest: [this.editData['data'], Validators.required],
      slug: [this.editData['slug']],
      test: [null],
      featured: [this.editData['featured']],
      sponsored: [this.editData['sponsored']],
    })
    if (this.editData['deviceType'] == "MOBILE") {
      this.form.get('PublishFor').setValue('FurrCrewApp')
    } else if (this.editData['deviceType'] == "WEB") {
      this.form.get('PublishFor').setValue('WebSite')
    } else if (this.editData['deviceType'] == 'BOTH') {
      this.form.get('PublishFor').setValue('Both')
    }
    if (this.editData['category'] == 'blog') {
      this.form.get('blogOrArticle').setValue('blog')
    } else if (this.editData['category'] == 'article') {
      this.form.get('blogOrArticle').setValue('article')
    }
    // if(this.form.get('PublishFor').value =='FurrCrewApp' || this.form.get('PublishFor').value == 'Both'){
    //   this.form.get('coverImage').setValidators(Validators.required )
    // }
    let tagsArray = this.form.get('tags') as FormArray;
    let array = this.editData['tag'] ? this.editData['tag'].split(' ') : [];
    array.forEach(element => {
      tagsArray.push(
        this.fb.control(element)
      )
    });
  }

  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/miscellaneous/blog']);
  }

  createForm() {
    this.form = this.fb.group({
      name: [null, [Validators.required, this.validationsService.stringValidator()]],
      image: [null, Validators.required],
      coverImage: [null,],
      tags: this.fb.array([], Validators.required),
      blogOrArticle: ['blog', Validators.required],
      PublishFor: [null, Validators.required],
      title: [null, [Validators.required, this.validationsService.stringValidator()]],
      slug: [null],
      readTime: [null, Validators.required],
      bodyTest: [null, Validators.required],
      test: [null],
      featured: [false],
      sponsored: [false],
    })
    if (this.form.get('PublishFor').value == 'FurrCrewApp' || this.form.get('PublishFor').value == 'Both') {
      this.form.get('image').setValidators(Validators.required)
    }
  }

  createControlls() {
    this.controlls = {
      name: {
        id: "name",
        name: 'name',
        label: "Name",
        placeholder: "Name of the author",
        required: true,
        type: "text"
      },
      image: {
        id: "image",
        name: 'image',
        label: "Cover Image*",
        required: true,
        type: "file"
      },
      coverImage: {
        id: "coverImage",
        name: 'coverImage',
        label: "Thumb Image*",
        required: true,
        type: "file"
      },
      tags: {
        id: "tags",
        name: 'tags',
        label: "Tags",
        placeholder: "Add Tags And Press Enter",
        required: true,
        type: "tag"
      },
      blogOrArticle: {
        id: "blogOrArticle",
        name: 'blogOrArticle',
        label: "Create",
        required: true,
        type: "radio",
        options: [
          {
            name: 'Blog',
            value: 'blog'
          }, {
            name: 'Educational Blog',
            value: 'article'
          }
        ]
      },
      PublishFor: {
        id: "PublishFor",
        name: 'PublishFor',
        label: "Publish For",
        required: true,
        type: "radio",
        options: [
          {
            name: 'FurrCrewApp',
            value: 'FurrCrewApp'
          },
          {
            name: 'WebSite',
            value: 'WebSite'
          },
          {
            name: 'Both',
            value: 'Both'
          },
        ]
      },
      title: {
        id: "title",
        name: 'title',
        label: "Title",
        placeholder: "Enter Main Blog Title Here",
        required: true,
        type: "text"
      },
      readTime: {
        id: "readTime",
        name: 'readTime',
        label: "Read Time",
        placeholder: "Select Time",
        required: true,
        type: "dropdown",
        options: [
          {
            name: '5 Min',
            value: "5 Min"
          },
          {
            name: '10 Min',
            value: "10 Min"
          },
          {
            name: '15 Min',
            value: "15 Min"
          },
          {
            name: '20 Min',
            value: '20 Min'
          },
          {
            name: '25 Min',
            value: "25 Min"
          },
          {
            name: '30 Min',
            value: '30 Min'
          },
          {
            name: '35 Min',
            value: "35 Min"
          },
          {
            name: '40 Min',
            value: '40 Min'
          },
          {
            name: '45 Min',
            value: "45 Min"
          }, {
            name: '50 Min',
            value: '50 Min'
          },
          {
            name: '55 Min',
            value: "55 Min"
          }, {
            name: '60 Min',
            value: '60 Min'
          }]
      },
      bodyTest: {
        id: "bodyTest",
        name: 'bodyTest',
        label: "Body Text*",
        required: true,
        type: "richText"
      },
      featured: {
        id: "featured",
        name: 'featured',
        label: "Featured",
        required: true,
        type: "boolean"
      },
      sponsored: {
        id: "sponsored",
        name: 'sponsored',
        label: "Sponsored",
        required: true,
        type: "boolean"
      },
      slug: {
        id: "slug",
        name: "slug",
        label: "Custom Title",
        required: true,
        type: "string"
      },
      test: {
        id: "test",
        name: "test",
        label: "Test",
        type: "toggle"
      }

    }
  }

  imageUpload(event) {
    debugger
    if (this.editData) {
      this.loader.showLoader()
      this.miscellaneousService.addBlogImages(this.editData['id'], this.form.get('image').value).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast("Uploaded Successfully")
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to Upload")
      }
      )
    }
  }

  coverImageUpload(event) {
    debugger
    if (this.editData) {
      this.loader.showLoader()
      this.miscellaneousService.addCoverImage(this.editData['id'], this.form.get('coverImage').value).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast("Uploaded Successfully")
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to Upload")
      }
      )
    }
    
  }

  create() {
    let json = this.form.value
    console.log(this.form);
    let body = {
      "title": json['title'],
      "status": this.editData ? this.editData['status'] : true,
      "readTimeSpan": json['readTime'],
      "data": json['bodyTest'],
      "deviceType": json['PublishFor'],
      "category": json['blogOrArticle'],
      "tags": json['tags'].join(' '),
      "author": json['name'],
      "featured": json['featured'],
      "sponsored": json['sponsored'],
      "slug": json["slug"]

    }
    if (json['PublishFor'] == 'WebSite') {
      body['deviceType'] = 'WEB'
    } else if (json['PublishFor'] == 'FurrCrewApp') {
      body['deviceType'] = 'MOBILE'
    } else if (json['PublishFor'] == 'Both') {
      body['deviceType'] = 'BOTH'
    }
    if (this.editData) {
      body['id'] = this.editData['id']
      this.loader.showLoader()
      this.miscellaneousService.upddateBlog(body, this.editData['id']).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: json['blogOrArticle'].value =="article" ? 'Educational Blog' : json['blogOrArticle']+' updated successfully', success: true },
          panelClass: 'success-dialog-container'
        });
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    } else {
      this.loader.showLoader();
      this.miscellaneousService.addBlog(body).subscribe((res) => {
        console.log(res);
        this.miscellaneousService.addBlogImages(res['id'], json['image']).subscribe((res) => {
          console.log(res);
        })
        this.miscellaneousService.addCoverImage(res['id'], json['coverImage']).subscribe((res) => {
          console.log(res);
        })
        this.miscellaneousService.getBlogs().subscribe((res) => {
          this.router.navigate(['/miscellaneous/blog/']);
        })
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: json['blogOrArticle'].value =='article' ? 'Educational Blog' : json['blogOrArticle'] +' created successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

}
