import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { LoaderService } from 'app/services/loader.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-admin',
  templateUrl: './add-admin.component.html',
  styleUrls: ['./add-admin.component.scss']
})
export class AddAdminComponent {
  form: FormGroup;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controllers: any;
  constructor(private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader: LoaderService

  ) {
    this.form = this.fb.group({
      name: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: ['', [Validators.required, this.validationsService.emailValidator()]],
      phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
      gender: ['', [Validators.required]],
      role: ['', Validators.required]
    })

    this.craeteFormControllers()

  }
  ngOnInit() {

  }

  ngOnChanges() {
    console.log(this.editData);
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Edit"
      this.edit()
    }
  }
  edit() {
    this.form = this.fb.group({
      name: [this.editData['collaboratorName'], [Validators.required, this.validationsService.stringValidator()]],
      email: [this.editData['email'], [Validators.required, this.validationsService.emailValidator()]],
      phone: [this.editData['mobile'], [Validators.required, this.validationsService.mobileNumberValidator()]],
      gender: ['', [Validators.required]],
      role: ['', Validators.required],
      internalNotes: ['']
    })
  }

  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "userName",
        name: 'name',
        label: "Name",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      email: {
        id: "userName",
        name: 'email',
        label: "Email",
        required: true,
        placeholder: "Enter Email",
        type: "email"
      },
      phone: {
        id: "phone",
        name: 'phone',
        label: "Phone",
        required: true,
        placeholder: "Enter Mobile No.",
        type: "text"
      },

      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        options: [
          {
            name: "Male",
            value: "Male"
          },
          {
            name: "Female",
            value: "Female"
          }

        ],
        type: "radio"
      },
      role: {
        id: "role",
        name: 'role',
        label: "Role",
        required: true,
        options: [
          {
            name: "Staff",
            value: "Staff"
          },
          {
            name: "Super Admin",
            value: "Super Admin"
          }

        ],
        type: "radio"
      },


      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true,
      }
    }
  }

  addCollaborator() {

  }
  cancel() {
    this.cancelEvent.emit()
    this.router.navigate(['/miscellaneous'])
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

}
