import { Component, ViewChild } from '@angular/core';
import { EducationService } from '../../../services/education.service';
import { MatMenuTrigger } from '@angular/material/menu';
import { Router } from '@angular/router';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { saveAs } from 'file-saver'; // Import the saveAs function
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatSidenav } from '@angular/material/sidenav';
import moment from 'moment';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { TimeDateService } from 'app/services/time-date.service';
@Component({
  selector: 'app-webinar',
  templateUrl: './webinar.component.html',
  styleUrls: ['./webinar.component.scss']
})
export class WebinarComponent {
  searchTerm: string = '';
  @ViewChild(MatPaginator) paginator: MatPaginator;
  webinars: MatTableDataSource<any>;
  displayedColumns: string[] = ['selector','id', 'title', 'author', 'mode', 'price', 'publishDate', 'liveDate','createAt', 'published','test', 'action'];
  data: any;
  selectedRows: any[] = [];
  showAll: boolean = false;
  constructor(
    private educationService: EducationService,
    private router: Router,
    private snackBar: MatSnackBar,
    private dialog : MatDialog,
    private loader : LoaderService,
    private _snackBar: MatSnackBar,
    public timeDateService : TimeDateService,
  ) {
    this.getWebinar();
  }
  index: number;
  ngAfterViewInit() {
    this.webinars.paginator = this.paginator;
  }
  currentUTCDate(milliseconds): string {
    if (milliseconds == 0) {
      0
    } else {
      return moment.utc(new Date(milliseconds)).local().format("DD-MMM-YYYY")
    }
  }

  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }
  
  getWebinar() {
    let ary = []
    this.loader.showLoader();
    this.educationService.getAllWebiars().subscribe((res: Array<any>) => {
      this.loader.hideLoader();
      this.data = res;
      res.forEach((el) => {
        // el['publishDate'] = moment.utc(el['publishDate']).local().format("DD-MMM-YYYY");
        // console.log(el['name']);
        el['title'] = el['title'] ? el['title'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        if (!this.showAll) {
          if (el.status === 'Active') {
            ary.push(el)
          }
        } else {
          ary.push(el)
        }
        // .capitalize()
      })
      const webinarArray = Object.values(ary);
      this.webinars = new MatTableDataSource(webinarArray.map((item: any) => ({ ...item, })));
      this.webinars.paginator = this.paginator;
    });
  }
  showDataEvent(event) {
    this.showAll = !this.showAll;
    this.getWebinar()
  }

  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  showFiller: boolean = false;
  @ViewChild('sidenav') sidenav: MatSidenav;
  editUser() {
    this.row = new Array();
    this.row = this.data[this.index];

    this.showFiller = true;
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    
    this.row = new Array();
    this.row = this.data[this.index];
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }
  row: any;
  deleteUser() {
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        // User confirmed action
        this.educationService.deleteCourse(this.data[this.index]['id']).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          this.getWebinar();
          this.menuTrigger.closeMenu();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Webinar deleted successfully',success : true },
            panelClass: 'success-dialog-container'
          });
        }, (error) => {
          this.loader.hideLoader()
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Something Went Wrong!',success : false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
    
  }

  toggle(row) {
    // drawer.toggle()
    this.index = row;
  }

  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    this.webinars.filter = this.searchTerm.trim().toLowerCase();
  }

  add(event) {
    console.log(event);
    this.router.navigate(['/education/webinar/addWebinar']);
  }

  selectAll(event) {
    const isChecked = event.checked;
    this.webinars.data.forEach(row => row.selected = isChecked);
    this.selectedRows = isChecked ? [...this.webinars.data] : [];
  }
  
  export(event) {
    const selectedRows = this.webinars.data.filter(row => row.selected);
    const csvData = this.convertToCSV(selectedRows);
    const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });

    saveAs(blob, 'selected-webinars.csv');
  }
  cancel() {
    this.getWebinar()
    this.sidenav.toggle();
  }
  convertToCSV(data: any[]): string {
    const header = Object.keys(data[0]).join(',');
    const csv = data.map(row => Object.values(row).join(',')).join('\n');
    return `${header}\n${csv}`;
  }
  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Inactive';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
    this.updatestatus(newStatus, element);
  }
  //   {
  //     "id": "a3c3ae77-163e-41cb-8036-e015b7a3295c",
  //     "title": "abc",
  //     "description": "<p>abc</p>",
  //     "eventOn": 1709058600000,
  //     "status": "Inactive",
  //     "mode": "Online",
  //     "price": 0,
  //     "author": "abc",
  //     "createAt": "07-Feb-2024 13:55:09 UTC",
  //     "likedCount": 0,
  //     "sharedCount": 0,
  //     "viewedCount": 0,
  //     "eduCategory": "Course",
  //     "publishDate": 1706985000000,
  //     "files": [
  //         {
  //             "id": "5c23d30a-e33b-4315-9de4-c97b5c8ebd06",
  //             "filePath": "https://ap-south-1-bvur-dev-furrcrew.s3.ap-south-1.amazonaws.com/Webinar/a3c3ae77-163e-41cb-8036-e015b7a3295c/WIN_20240115_12_21_57_Pro.mp4?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Date=20240212T053633Z&X-Amz-SignedHeaders=host&X-Amz-Expires=1799&X-Amz-Credential=AKIAQQBFJX7DRRSV7EVT%2F20240212%2Fap-south-1%2Fs3%2Faws4_request&X-Amz-Signature=b905a4c2a84fb807446232f4957d7e802675c15508ce10a287427454d6d2c5ef",
  //             "eduId": "a3c3ae77-163e-41cb-8036-e015b7a3295c",
  //             "episodeNo": 1,
  //             "title": "AAA",
  //             "description": "<p>AAA</p>",
  //             "videoDuration": "AVC",
  //             "active": false
  //         }
  //     ],
  //     "value": false,
  //     "liveDate": 1707351802000,
  //     "featured": false,
  //     "sponsored": false,
  //     "published": false,
  //     "paid": false
  // }
  updatestatus(newStatus, element) {
    let body = {
      "id": element.id,
      "title": element.title,
      "description": element.description,
      "eventOn": element.eventOn,
      "isPublished": element.isPublished,
      "mode": element.mode,
      "price": element.price,
      "author": element.author,
      "isPaid": element.isPaid,
      "eduCategory": element.eduCategory,
      "published": newStatus === 'Active',
      "status": newStatus
    }
    this.loader.showLoader()
    this.educationService.updateWebinar(body).subscribe(
      (res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast('Update successful');
      },
      (error) => {
        this.loader.hideLoader()
        console.error(error);
        this.showErrorToast('Update failed');
      }
    );
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  testChange(event, element){
    this.loader.showLoader()
    this.educationService.testChange('WEBINAR_COURSE',element['id'],event['checked']).subscribe((res)=>{
        this.loader.hideLoader()
        this.showSuccessToast('SuccessFully Done')
    },
    (error)=>{
      this.loader.hideLoader();
        this.showErrorToast('Failed...')
    }
    )
}

}
