import { Component, Input } from '@angular/core';
import { FormArray, FormBuilder, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-episodes',
  templateUrl: './episodes.component.html',
  styleUrls: ['./episodes.component.scss']
})
export class EpisodesComponent {
  @Input() episodesount : number;
  @Input() formArray : FormArray;
  @Input() webinarId : string;

  constructor(
    private fb : FormBuilder,
    private dialog : MatDialog,
    private validationsService : ValidationsService,
    private loader : LoaderService
    ){

  }

  ngOnInit(){
    console.log(this.episodesount);
    console.log(this.formArray);
    
  }

  counter(i: number) {    
    return new Array(i);
  }

  addEpisode(){
    console.log("123");
    
    this.episodesount += 1
    this.formArray.push(this.fb.group({
      id: [''],
      eduId: [''],
      title: ['', [Validators.required, this.validationsService.stringValidator()]],
      description: [''],
      duration: ['', [Validators.required,Validators.pattern('^[0-9]+$')]],
      episode: ['', Validators.required],
    }))
  }
  ngOnDestroy(){
    console.log("23");
    
    this.formArray.removeAt(this.formArray.controls.length-1)
  }

}
 

  
