import { Component, Inject, Input, EventEmitter, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { EducationService } from 'app/services/education.service';
import { LoaderService } from 'app/services/loader.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-episode',
  templateUrl: './episode.component.html',
  styleUrls: ['./episode.component.scss']
})
export class EpisodeComponent {
  form: FormGroup;
  controlls: any;
  @Input() webinarId: string
  @Input() formArray: FormArray;
  @Input() episodeNo: number;
  constructor(
    private educationService: EducationService,
    private fb: FormBuilder,
    private snackBar: MatSnackBar,
    private dialog : MatDialog,
    private validationsService : ValidationsService,
    private loader : LoaderService
  ) {
    // this.createForm();
    // this.createControlls();
  }
  ngOnInit() {
    console.log("abc");
    
    this.createForm();
    this.createControlls();

  }

  createForm() {
    let array: FormArray = this.formArray;
    let index = this.episodeNo - 1;
    if (array.at(index)) {
      let formGroup: FormGroup = array.at(index) as FormGroup
      this.form = formGroup;
      console.log(this.form);

    } else {
      this.form = this.fb.group({
        id: [''],
        eduId: [''],
        title: ['', [Validators.required,this.validationsService.stringValidator()]],
        description: [''],
        duration: ['', [Validators.required,Validators.pattern('^[0-9]+$')]],
        episode: ['', Validators.required],
      })
    }
  }
  chnageEpisode(event){
    console.log(event);
    
    let json = this.form.value;
    if(this.form.get('id').value && this.form.get('eduId').value){
      this.loader.showLoader()
      this.educationService.updateWebinarVideo(json['eduId'],json['id'],json['episode']).subscribe((res)=>{
        this.loader.hideLoader()
        console.log(res);
        
      })
    }
  }
  addEpisode() {
    let json = this.form.value;
    let array: FormArray = this.formArray;
    if (this.form.get('id').value && this.form.get('eduId').value) {
      this.loader.showLoader()
      this.educationService.updateEpisode(json['eduId'],json['id'],json['title'],json['description'],json['duration'],this.episodeNo).subscribe((res)=>{
        this.loader.hideLoader()
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Episode updated successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
      },(error)=>{
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    } else {
      // array.push(this.form)
      this.loader.showLoader()
      this.educationService.uploadEpisode(this.webinarId, this.form.get('title').value, this.form.get('description').value, this.form.get('duration').value, this.episodeNo, this.form.get('episode').value).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Episode created successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
      },(error)=>{
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }

  }
  onNoClick() {

  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
  createControlls() {
    this.controlls = {
      title: {
        id: "title",
        name: 'title',
        label: "Title",
        required: true,
        placeholder: "Enter Title",
        type: "text"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description",
        required: true,
        placeholder: "Enter Name",
        type: "richText"
      },

      duration: {
        id: "duration",
        name: 'duration',
        label: "Duration",
        required: true,
        placeholder: "Should be in min",
        type: "text"
      }, episode: {
        id: "episode",
        name: 'episode',
        label: "Upload Episode",
        required: true,
        type: "text"
      },


    }
  }

  uploadEpisode() {
    // let json = 

  }
}
