import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { EducationComponent } from './education.component';
import { EducationRoutingModule } from './education-routing.module';
import { WebinarComponent } from './webinar/webinar.component';
import { CourseComponent } from './course/course.component';
import {MatTableModule} from '@angular/material/table';
import { MatIconModule } from '@angular/material/icon';
import { MatMenuModule } from '@angular/material/menu';
import { CommonComponentsModule } from 'app/components/common-components/common-components.module';
import { AddCourseComponent } from './add-course/add-course.component';
import { AddWebinarComponent } from './add-webinar/add-webinar.component';
import { ControllersModule } from 'app/components/controllers/controllers.module';
import {MatButtonModule} from '@angular/material/button';
import {MatSliderModule} from '@angular/material/slider';
import { MatPaginatorModule } from '@angular/material/paginator';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import {MatSlideToggleModule} from '@angular/material/slide-toggle';
import {MatTabsModule} from '@angular/material/tabs';
import {MatStepperModule} from '@angular/material/stepper';
import { EpisodeComponent } from './episode/episode.component';
import {MatTreeModule} from '@angular/material/tree';
import {MatDialogModule} from '@angular/material/dialog';
import {MatSidenavModule} from '@angular/material/sidenav';
import { EpisodesComponent } from './episodes/episodes.component';
import { MatExpansionModule } from '@angular/material/expansion';
import { StatsComponent } from './stats/stats.component';
import {MatCheckboxModule} from '@angular/material/checkbox';
import { MatCheckboxChange } from '@angular/material/checkbox';
import { FormsModule } from '@angular/forms';
@NgModule({
  declarations: [
    EducationComponent,
    WebinarComponent,
    CourseComponent,
    AddCourseComponent,
    AddWebinarComponent,
    EpisodeComponent,
    EpisodesComponent,
    StatsComponent,
  ],
  imports: [
    CommonModule,
    EducationRoutingModule,
    MatTableModule,
    MatDialogModule,
    MatSliderModule,
    MatExpansionModule,
    ControllersModule,
    MatSidenavModule,
    MatTreeModule,
    MatStepperModule,
    MatTabsModule,
    MatMenuModule,
    MatIconModule,
    CommonComponentsModule,
    MatButtonModule,
    MatPaginatorModule,
    MatSnackBarModule,
    MatSlideToggleModule,
    MatCheckboxModule,
    FormsModule
  ],
  providers :[]
  
})
export class EducationModule { }
