import { Component, ViewChild } from '@angular/core';
import { EducationService } from '../../../services/education.service'
import { MatMenuTrigger } from '@angular/material/menu';
import { Router } from '@angular/router';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { saveAs } from 'file-saver';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatSidenav } from '@angular/material/sidenav';
import moment from 'moment';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { TimeDateService } from 'app/services/time-date.service';
import { MatCheckboxChange } from '@angular/material/checkbox';
@Component({
  selector: 'app-course',
  templateUrl: './course.component.html',
  styleUrls: ['./course.component.scss']
})
export class CourseComponent {
  searchTerm: string = '';
  @ViewChild(MatPaginator) paginator: MatPaginator;
  courses: MatTableDataSource<any>;
  displayedColumns: string[] = ['selector','id', 'title', 'mode', 'price', 'publishDate', 'livaDate', 'active','test', 'action'];
  ngAfterViewInit() {
    this.courses.paginator = this.paginator;
  }
  constructor(
    private educationService: EducationService,
    private router: Router,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader : LoaderService,
    private _snackBar: MatSnackBar,
    public timeDateService : TimeDateService,
  ) {
    this.getCources();
  }
  data: any = [];

  currentUTCDate(milliseconds): string {    
    if (milliseconds == 0) {
      0
    } else {
      return moment.utc(new Date(milliseconds)).format("DD-MMM-YYYY")
    }
  }

  dispalyDate(date){
    return moment.utc(date).format("DD-MMM-YYYY")
  }

  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  getCources() {
    let ary = []
    this.loader.showLoader();
    this.educationService.getCources().subscribe((res: Array<any>) => {
      this.loader.hideLoader();
      res.forEach((el) => {
        el['selected'] = false;
        el['title'] = el['title'] ? el['title'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
        if (!this.showAll) {
          if (el.status === 'Active') {
            ary.push(el)
          }
        } else {
          ary.push(el)
        } // Ensure the selected property is added
      });

      this.data = res;
      const coursesArray = Object.values(ary);
      this.courses = new MatTableDataSource(coursesArray.map((item: any) => ({ ...item })));
      this.courses.paginator = this.paginator;
    });
  }
  
  
  
  showAll: boolean = false;
  showDataEvent(event) {
    this.showAll = !this.showAll;
    this.getCources()
  }

  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  editUser(element) {
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }
  deleteUser(element) {
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.educationService.deleteCourse(element['id']).subscribe((res) => {
          this.loader.hideLoader();
          console.log(res);
          this.getCources();
          this.menuTrigger.closeMenu();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Course deleted successfully!', success: true },
            panelClass: 'success-dialog-container'
          });

        }, (error) => {
          this.loader.hideLoader()
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Something Went Wrong!', success: false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })

  }
  showFiller: Boolean = false;
  row: any;
  index: number;
  @ViewChild('sidenav') sidenav: MatSidenav;
  cancel() {
    this.getCources();
    this.sidenav.toggle();
  }

  toggle(row) {
    // drawer.toggle()
    this.index = row;
  }

  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    this.courses.filter = this.searchTerm.trim().toLowerCase();
  }

  add(event) {
    console.log(event);
    this.router.navigate(['/education/course/addCourse']);
  }
  export(event) {
    const selectedCourses = this.courses.data.filter((course: any) => course.selected);
    console.log('Selected Courses:', selectedCourses);  // Debug log
  
    if (selectedCourses.length === 0) {
      this.openSnackBar('No courses selected for export');
      return;
    }
  
    const csvData = this.convertToCSV(selectedCourses);
    const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });
    saveAs(blob, 'selected-courses.csv');
  }
  
  
  selectAll(event: any) {
    const isChecked = event.checked;
    this.courses.data.forEach((course: any) => course.selected = isChecked);
  }

  convertToCSV(data: any[]): string {
    if (!data || data.length === 0) return '';
  
    const header = Object.keys(data[0]).join(',');
    const csvRows = data.map(row => 
      Object.values(row)
        .map(value => value === null || value === undefined ? '' : value.toString())
        .map(value => (value.includes(',')) ? `"${value}"` : value)
        .join(',')
    );
  
    return `${header}\n${csvRows.join('\n')}`;
  }
  
  
  
  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Inactive';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
    this.updatestatus(newStatus, element);
  }
  updatestatus(newStatus, element) {
    let body = {
      "id": element.id,
      "title": element.title,
      "description": element.description,
      "eventOn": element.eventOn,
      "isPublished": element.isPublished,
      "mode": element.mode,
      "price": element.price,
      "author": element.author,
      "isPaid": element.isPaid,
      "eduCategory": element.eduCategory,
      "published": newStatus === 'Active',
      "status": newStatus
    }
    this.loader.showLoader();
    this.educationService.updateWebinar(body).subscribe(
      (res) => {
        this.loader.hideLoader();
        console.log(res);
        this.showSuccessToast('Update successful');
      },
      (error) => {
        this.loader.hideLoader()
        console.error(error);
        this.showErrorToast('Update failed');
      }
    );
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  testChange(event, element){
    this.loader.showLoader()
    this.educationService.testChange('WEBINAR_COURSE',element['id'],event['checked']).subscribe((res)=>{
      this.loader.hideLoader()
        this.showSuccessToast('SuccessFully Done')
    },
    (error)=>{
      this.loader.hideLoader()
        this.showErrorToast('Failed...')
    }
    )
}
}
