import { FlatTreeControl } from '@angular/cdk/tree';
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatTreeFlatDataSource, MatTreeFlattener } from '@angular/material/tree';
import { Router } from '@angular/router';
import { EducationService } from 'app/services/education.service';
import moment from 'moment';
import { MatSnackBar } from '@angular/material/snack-bar';
import { TimeDateService } from 'app/services/time-date.service';
import { MatTableDataSource } from '@angular/material/table';
import { StatsComponent } from '../stats/stats.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { ValidationsService } from 'app/services/validations.service';
import { LoaderService } from 'app/services/loader.service';


@Component({
  selector: 'app-add-course',
  templateUrl: './add-course.component.html',
  styleUrls: ['./add-course.component.scss']
})
export class AddCourseComponent {
  form: FormGroup;
  episodes: FormArray;
  controlls: any;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  dataSource;
  isCreated: boolean = false;
  webinarId: string = null;
  constructor(
    private fb: FormBuilder,
    private educationService: EducationService,
    private router: Router,
    public dialog: MatDialog,
    private timeDateService: TimeDateService,
    private snackBar: MatSnackBar,
    private validationsService: ValidationsService,
    private loader : LoaderService

  ) {
    this.createForm();
    this.createControlls();
  }

  ngOnChanges() {
    if (this.editData) {
      // let ele = document.getElementById("add-update");
      // ele.innerHTML = "Save";
      this.edit();
    }
  }

  ngOnInit(){
    this.form.get('paidUnpaid').valueChanges.subscribe((change)=>{     
      this.form.get('price').reset() 
      if (change == 'Paid') {
        this.form.get('price').setValidators([Validators.required,Validators.pattern('^[0-9]+$')]);
        this.form.get('price').updateValueAndValidity();

      } else {
        this.form.get('price').clearValidators();
        this.form.get('price').updateValueAndValidity();
      }
      
    })
    // this.dataSource = new MatTreeFlatDataSource(this.treeControl, this.treeFlattener);
  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY hh:mm A");
  }

  edit() {
    this.isCreated = true
    this.webinarId = this.editData['id']
    console.log(this.editData);
    this.form = this.fb.group({
      webinar: [this.editData['files'][0]['filePath'], Validators.required],
      title: [this.editData['title'], [Validators.required, this.validationsService.stringValidator()]],
      description: [this.editData['description'],Validators.required],
      poster: [this.editData['poster'], Validators.required],
      price: [this.editData['price'], [Validators.required, Validators.pattern('^[0-9]+$')]],
      presenter: [this.editData['author'], [Validators.required, this.validationsService.stringValidator()]],
      publishedDate: [new Date(this.editData['publishDate']), Validators.required],
      publishedTime: [''],
      publishedDateNdTime: [this.currentUTCDate(this.editData['publishDate'])],
      createdAt: [this.editData['createAt']],
      modifiedAt: [this.currentUTCDate(this.editData['modifiedAt'])],
      liveDate: [this.timeDateService.millisecondsToDateTime(this.editData['liveDate'])['date'], Validators.required],//moment.utc(new Date(milliseconds))
      liveTime: [this.timeDateService.millisecondsToDateTime(this.editData['liveDate'])['time'],Validators.required],
      duration: [this.editData['files'][0]['videoDuration'],],
      type: [this.editData['mode'], Validators.required],
      paidUnpaid: ['', Validators.required],
      advertisement: [true, Validators.required],
      edpisodesNumber: [this.editData['files'].length,],
      featured: [this.editData['featured']],
      sponsored: [this.editData['sponsored']],
    })
    let arra = this.episodes as FormArray;
    console.log(arra);
    arra.clear()
    for (let i = 1; i < this.editData['files'].length; i++) {
      arra.push(this.fb.group({
        id: [this.editData['files'][i]['id']],
        eduId: [this.editData['files'][i]['eduId'],],
        title: [this.editData['files'][i]['title'], Validators.required],
        description: [this.editData['files'][i]['description']],
        duration: [this.editData['files'][i]['videoDuration'], Validators.required],
        episode: [this.editData['files'][i]['filePath'], Validators.required],
      }))
    }
    if (this.editData['paid'] == false) {
      this.form.get('paidUnpaid').setValue('Free')
    } else {
      this.form.get('paidUnpaid').setValue('Paid')
    }
  }
  stats(type: string) {//stats
    let stats: MatTableDataSource<any>;
    let aray = []
    this.loader.showLoader();
    this.educationService.stats(this.editData['id'], 'EDU').subscribe((res: Array<any>) => {
      this.loader.hideLoader();
      res.forEach((el) => {
        if (el['viewed'] && type == 'views') {////liked shared
          aray.push(el)
          const statsArray = Object.values(aray);
          stats = new MatTableDataSource(statsArray.map((item: any) => ({ ...item, })));

        } else if (el['liked'] && type == 'likes') {
          aray.push(el)
          const statsArray = Object.values(aray);
          stats = new MatTableDataSource(statsArray.map((item: any) => ({ ...item, })));

        } else if (el['shared'] && type == 'share') {
          aray.push(el)
          const statsArray = Object.values(aray);
          stats = new MatTableDataSource(statsArray.map((item: any) => ({ ...item, })));
        }
      })
      const dialogRef = this.dialog.open(StatsComponent, {
        width: '600px',
        data: { stats: stats }
      });

    })
  }

  createForm() {
    this.form = this.fb.group({
      webinar: ['', Validators.required],
      title: ['', [Validators.required, this.validationsService.stringValidator()]],
      description: ['',Validators.required],
      poster: ['', Validators.required],
      price: [0, [ Validators.pattern('^[0-9]+$')]],
      presenter: ['', [Validators.required, this.validationsService.stringValidator()]],
      liveDate: ['', Validators.required],
      liveTime: ['',Validators.required],
      duration: ['',[Validators.required,Validators.pattern('^[0-9]+$')]],
      type: ['', Validators.required],
      paidUnpaid: ['', Validators.required],
      advertisement: ['',],
      edpisodesNumber: [''],
      featured: [false],
      sponsored: [false],
    })
    this.episodes = this.fb.array([]);
    
  }
  createControlls() {
    this.controlls = {
      webinar: {
        id: "webinar",
        name: 'webinar',
        label: "Upload Course Trailer*",
        required: true,
        type: "text"
      },
      title: {
        id: "title",
        name: 'title',
        label: "Title",
        required: true,
        placeholder: "Enter Title",
        type: "text"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description*",
        required: true,
        placeholder: "Enter Name",
        type: "richText"
      },
      price: {
        id: "price",
        name: 'price',
        label: "Enter Price",
        required: true,
        type: "Text"
      },
      poster: {
        id: "poster",
        name: 'poster',
        label: "Upload Course Poster*",
        required: true,
        type: "file"
      },
      presenter: {
        id: "presenter",
        name: 'presenter',
        label: "Presenter",
        required: true,
        type: "dropDown"
      },
      publishedDate: {
        id: "publishedDate",
        name: 'publishedDate',
        label: "Published Date",
        required: true,
        placeholder: "mm/dd/yyyy",
        type: "calender"
      },
      publishedTime: {
        id: "publishedTime",
        name: "publishedTime",
        label: "Published Time"

      },
      liveDate: {
        id: "liveDate",
        name: 'liveDate',
        label: "Live Date",
        required: true,
        placeholder: "mm/dd/yyyy",
        type: "calender"
      },
      liveTime: {
        id: "liveTime",
        name: 'liveTime',
        label: "Live Time*",
        required: true,
      },
      publishedDateNdTime: {
        id: "publishedDateNdTime",
        name: 'publishedDateNdTime',
        label: "Published Date and Time",
        required: false,
      },
      createdAt: {
        id: "createdAt",
        name: 'createdAt',
        label: "Created At",
        required: false,
      },
      modifiedAt: {
        id: "modifiedAt",
        name: 'modifiedAt',
        label: "Modified At",
        required: false,
      },
      duration: {
        id: "duration",
        name: 'duration',
        label: "Duration (min)",
        required: true,
        placeholder: "Enter min",
        type: "text"
      },
      type: {
        id: "type",
        name: 'type',
        label: "Type",
        required: true,
        type: "radio",
        options: [
          {
            name: "Online",
            value: "Online"
          }, {
            name: "Offline",
            value: "offline"
          }
        ]
      },
      paidUnpaid: {
        id: "paidUnpaid",
        name: 'paidUnpaid',
        label: "Service Type",
        required: true,
        type: "radio",
        options: [
          {
            name: "Free",
            value: "Free"
          }, {
            name: "Paid",
            value: "Paid"
          }
        ]
      },
      advertisement: {
        id: "advertisement",
        name: 'advertisement',
        label: "Advertisement",
        required: true,
        type: "checkbox"
      },
      edpisodesNumber: {
        id: "edpisodesNumber",
        name: 'edpisodesNumber',
        label: "Episodes Number",
        required: true,
        type: "slider"
      },
      episodes: {
        id: 'episodes',
        name: 'episodes',
        label: "Episodes",
      },
      featured: {
        id: "featured",
        name: 'featured',
        label: "Featured",
        required: true,
        type: "boolean"
      },
      sponsored: {
        id: "sponsored",
        name: 'sponsored',
        label: "Sponsored",
        required: true,
        type: "boolean"
      },
    }
  }

  // onEpisodeClick(index: number) {
  //   console.log(index);

  //   if (this.webinarId) {
  //     const dialogRef = this.dialog.open(EpisodeComponent, { data: { formArray: this.form.get('episodes'), index: index, webinarId: this.webinarId } });

  //     dialogRef.afterClosed().subscribe(result => {
  //       console.log(`Dialog result: ${result}`);
  //     });
  //   }
  // }
  onNoClick(): void {
    this.episodes.removeAt(this.episodes.controls.length - 1)
    this.cancelEvent.emit();
    this.router.navigate(['/education/course/']);
  }

  uploadWebinar(event) {
    console.log(event);
    if (this.editData) {
      this.loader.showLoader();
      this.educationService.updateWebinarVideo(this.editData['id'], this.editData['files'][0]['id'], this.form.get('webinar').value).subscribe((res) => {
        this.loader.hideLoader();

        console.log(res);
      })
    }
    // this.educationService.updateWebinarVideo()
  }
  uploadPoster(event) {
    if (this.editData) {
      this.loader.showLoader();
      this.educationService.uploadPoster(this.editData['id'], this.form.get('poster').value).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Posted uploaded successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
      })
    }
  }

  onSponsoredToggleChange(event){
    console.log(event);
    
    if(this.editData){
      this.loader.showLoader()
      this.educationService.featuresSponsoredTollge(this.editData['id'],'sponsored',event).subscribe((res)=>{
        this.loader.hideLoader()
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Course edited to sponsored!', success: true },
          panelClass: 'success-dialog-container'
        });
      },(error)=>{
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }

  onFeatureToggleChange(event){    
    if(this.editData){
      this.loader.showLoader()
      this.educationService.featuresSponsoredTollge(this.editData['id'],'featured',event).subscribe((res)=>{
        this.loader.hideLoader()
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Course toggle changed to featured!', success: true },
          panelClass: 'success-dialog-container'
        });
      },(error)=>{
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }
  create() {
    let json = this.form.value;
    // moment(inputDate).unix()* 1000
    console.log(json);

    let body = {
      title: json['title'],
      description: json['description'],
      eventOn: this.timeDateService.dateTimeToMilliseconds(json['liveDate'], json['liveTime'])['startTime'],
      status: this.editData ? this.editData['status'] : "Inactive",
      published: this.editData ? this.editData['status'] == 'Active' ? true : false : false,
      mode: json['type'],
      paid: json[''],
      price: json['price'],
      author: json['presenter'],
      eduCategory: "Course",//for course
      sponsored: this.editData ? this.editData['sponsored']: json['sponsored'],//switchState
      featured: this.editData ? this.editData['featured']: json['featured'],
      modifiedAt: '',
      // poster : json['poster'],
      publishDate: moment(json['publishedDate']).unix() * 1000
    }
    if (json['paidUnpaid'] == 'Paid') {
      body['paid'] = true;
    } else {
      body['paid'] = false;
      body['price'] = 0
    }
    if (this.editData) {
      body['id'] = this.editData['id']
      this.loader.showLoader()
      this.educationService.updateWebinar(body).subscribe((res) => {
        this.loader.hideLoader()
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Course updated successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
        this.onNoClick();
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    } else {
      this.loader.showLoader()
      this.educationService.createWebiar(body).subscribe((cres) => {
        console.log(cres);
        this.webinarId = cres['id']
        this.educationService.uploadPoster(this.webinarId, json['poster']).subscribe((res) => {
          console.log(res);
        },(error)=>{
          this.loader.hideLoader()
        })
        this.educationService.uploadEpisode(this.webinarId, json['title'], json['description'], json['duration'], 0, json['webinar']).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          this.isCreated = true;
          this.editData = cres;
          this.router.navigate(['/education/course']);
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Course created successfully!', success: true },
            panelClass: 'success-dialog-container'
          });

        })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }

  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
