import { DecimalPipe, NgFor } from '@angular/common';
import {
    AfterViewInit,
    ChangeDetectionStrategy,
    Component,
    OnDestroy,
    OnInit,
    ViewChild,
    ViewEncapsulation,
} from '@angular/core';
import { MatButtonModule } from '@angular/material/button';
import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { MatIconModule } from '@angular/material/icon';
import { MatMenuModule } from '@angular/material/menu';
import { MatTooltipModule } from '@angular/material/tooltip';
import { Router } from '@angular/router';
import { ApexOptions, NgApexchartsModule } from 'ng-apexcharts';
import { Subject, from, takeUntil } from 'rxjs';
import { AnalyticsService } from './analytics.service';
// import { BaseChartDirective } from 'ng2-charts';
import { MatPaginator, MatPaginatorModule } from '@angular/material/paginator';
import { MatSelectChange, MatSelectModule } from '@angular/material/select';
import { saveAs } from 'file-saver';
import { MatTableDataSource, MatTableModule } from '@angular/material/table';
import { FormBuilder, FormControl, FormGroup, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatInputModule } from '@angular/material/input';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';

@Component({
    selector: 'app-analytics',
    templateUrl: './analytics.component.html',
    styleUrls: ['./analytics.component.scss'],
    standalone: true,
    imports: [
        MatButtonModule,
        MatIconModule,
        MatMenuModule,
        MatButtonToggleModule,
        NgApexchartsModule,
        MatTooltipModule,
        NgFor,
        DecimalPipe,
        // BaseChartDirective,
        MatPaginatorModule,
        MatSelectModule,
        MatTableModule,
        FormsModule,
        ReactiveFormsModule,
        MatDatepickerModule,
        MatInputModule
    ],
})
export class AnalyticsComponent implements AfterViewInit {
    chartVisitors: ApexOptions;
    chartConversions: ApexOptions;
    chartImpressions: ApexOptions;
    chartVisits: ApexOptions;
    chartVisitorsVsPageViews: ApexOptions;
    chartNewVsReturning: ApexOptions;
    chartGender: ApexOptions;
    chartAge: ApexOptions;
    chartLanguage: ApexOptions;
    data: any;
    // @ViewChild(BaseChartDirective) chart?: BaseChartDirective;
    columnsToDisplay = [
        'Workspace Name',
        'Workspace Type',
        'Visits',
        'Bookings',
        'Likes',
        'Calls',
        'Shares',
    ];
    workspaces = [//ALL, VETERINARY, WALKER, GROOMER, TAXI, MEDICAL, BOARDING, NGO, TRAINER, REF
        'ALL',
        'VETERINARY',
        'GROOMER',
        'WALKER',
        'BOARDING',
        'MEDICAL',
        'TRAINER',
        'TAXI',
        'NGO',
    ];
    selectedWorkspaces = 'ALL';
    timeline = ['Past 30 days', 'Past 45 days', 'Past 90 days', 'Custom'];
    selectedTimeline = 'Past 30 days';
    actions = new FormControl(['All']);
    actionsList: string[] = [
        'All',
        'Visited',
        'Booked',
        'Called',
        'Liked',
        'Shared',
    ];
    selectedActions = 'All';
    numbers: number[] = [10, 20, 50, 100];
    selectedNumbers = 10;

    // lineChartData = {
    //     labels: ['11/28', '11/29', '11/30', '12/01', '12/02', '12/03'],
    //     datasets: [
    //         {
    //             data: [120, 150, 170, 180, 220, 100],
    //             label: 'Visits',
    //             fill: false,
    //             borderColor: '#4bc0c0',
    //         },
    //     ],
    // };

    // lineChartOptions = {
    //     responsive: true,
    //     scales: {
    //         x: {
    //             display: true,
    //         },
    //         y: {
    //             display: true,
    //         },
    //     },
    // };

    // pieChartData = {
    //     labels: ['Direct', 'Referral', 'Organic Search', 'Feed'],
    //     datasets: [
    //         {
    //             data: [40, 29, 30, 1],
    //             backgroundColor: ['#ff6384', '#36a2eb', '#ffce56', '#ff9f40'],
    //         },
    //     ],
    // };

    // pieChartOptions = {
    //     responsive: true,
    // };

    allContent = []
    topContent = this.allContent;
    dataSource = new MatTableDataSource(this.allContent);
    @ViewChild(MatPaginator) paginator: MatPaginator;

    constructor(
        private workspaceManagementService: WorkspaceManagementService,
        private fb: FormBuilder
    ) {
        this.range = this.fb.group({
            start: [null],
            end: [null]
        });

    }

    ngOnInit() {
        this.filterContent('workspace');
        this.range.get('end').valueChanges.subscribe((change) => {
            console.log(change);
            const date = new Date(this.range.get('start').value).getTime();
            const date2 = new Date(this.range.get('end').value).getTime() + (3600000 * 24);
            this.workspaceManagementService.getMatrics(date, date2, this.selectedWorkspaces, '').subscribe((res) => {
                console.log(res);
                this.allContent = res['metrics']
                this.totalVisit = res['totalVisit'];
                this.totalBooking = res['totalBooking'];
                this.totalCalls = res['totalCalls'];
                this.totalLikes = res['totalLikes'];
                this.totalShares = res['totalShares']
                this.dataSource.data = this.allContent;
                this.dataSource.paginator = this.paginator;
            })
        })
    }
    ngAfterViewInit() {
        this.dataSource.paginator = this.paginator;
        this.actions.valueChanges.subscribe((selectedActions) => {
            this.updateColumnsToDisplay(selectedActions);
        });
    }

    totalVisit: any;
    totalBooking: any;
    totalCalls: any;
    totalLikes: any;
    totalShares: any;
    range: FormGroup;
    filterContent(type: string) {
        let endTime = Date.now() + (3600000 * 24);
        let startTime = endTime - (30 * 24 * 60 * 60 * 1000) + (3600000 * 24);
        
        switch (type) {
            case 'workspace':
                this.getMatrics(startTime,endTime);
                break
            case 'numbers':
                // console.log('working', this.dataSource.data, this.selectedNumbers);
                this.dataSource.paginator.pageSize = this.selectedNumbers
                this.dataSource.data = this.allContent
                break
            case 'timeline':
                if (this.selectedTimeline === 'Past 30 days') {//'Past 45 days', 'Past 90 days', 'Custom'
                    startTime = endTime - (30 * 24 * 60 * 60 * 1000);
                    this.getMatrics(startTime,endTime);
                } else if (this.selectedTimeline === 'Past 45 days') {
                    startTime = endTime - (45 * 24 * 60 * 60 * 1000);
                    this.getMatrics(startTime,endTime);
                } else if (this.selectedTimeline === 'Past 90 days') {
                    startTime = endTime - (90 * 24 * 60 * 60 * 1000);
                    this.getMatrics(startTime,endTime);
                } else if (this.selectedTimeline === 'Custom' && this.range.get('end').value) {
                    // debugger
                    // if(this.range.get('end').valueChanges){
                        startTime = new Date(this.range.get('start').value).getTime();
                        endTime = new Date(this.range.get('end').value).getTime();
                        this.getMatrics(startTime,endTime);
                    // }
                }
                
                break
        }
        
    }

    getMatrics(startTime,endTime){
        this.workspaceManagementService.getMatrics(startTime, endTime, this.selectedWorkspaces, '').subscribe((res) => {
            console.log(res);
            this.allContent = res['metrics']
            this.totalVisit = res['totalVisit'];
            this.totalBooking = res['totalBooking'];
            this.totalCalls = res['totalCalls'];
            this.totalLikes = res['totalLikes'];
            this.totalShares = res['totalShares']
            this.dataSource.data = this.allContent;
            this.dataSource.paginator = this.paginator;
        })
    }

    export() {
        let csvData;
        csvData = this.dataSource.data.map((item) => ({
            name: item.workspaceName,
            type: item.type,
            visits: item.visits,
            bookings: item.bookings,
            likes: item.likes,
            calls: item.calls,
            shares: item.shares,
        }));
        const csvContent = convertToCSV(csvData);
        const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8' });
        saveAs(blob, 'analytics.csv');
        function convertToCSV(data: any[]): string {
            const header = Object.keys(data[0]).join(',');
            const rows = data.map((item) => Object.values(item).join(','));
            return `${header}\n${rows.join('\n')}`;
        }
    }
    updateColumnsToDisplay(selectedActions: string[]) {
        if (selectedActions.includes('All')) {
            this.actions.setValue(['All'], { emitEvent: false });
            this.columnsToDisplay = [
                'Workspace Name',
                'Workspace Type',
                'Visits',
                'Bookings',
                'Likes',
                'Calls',
                'Shares',
            ];
        } else {
            this.actions.setValue(
                selectedActions.filter((action) => action !== 'All'),
                { emitEvent: false }
            );
            this.columnsToDisplay = ['Workspace Name', 'Workspace Type'];
            if (selectedActions.includes('Visited')) {
                this.columnsToDisplay.push('Visits');
            }
            if (selectedActions.includes('Booked')) {
                this.columnsToDisplay.push('Bookings');
            }
            if (selectedActions.includes('Called')) {
                this.columnsToDisplay.push('Calls');
            }
            if (selectedActions.includes('Liked')) {
                this.columnsToDisplay.push('Likes');
            }
            if (selectedActions.includes('Shared')) {
                this.columnsToDisplay.push('Shares');
            }
        }
        console.log(this.columnsToDisplay);
    }
}
