import { Component, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { UserManagementService } from 'app/services/user-management.service';

@Component({
  selector: 'app-share-coupon',
  templateUrl: './share-coupon.component.html',
  styleUrls: ['./share-coupon.component.scss']
})
export class ShareCouponComponent {
  form: FormGroup;
  controlls: any;

  constructor(
    private fb : FormBuilder,
    private userManagementService : UserManagementService,
    public dialogRef: MatDialogRef<ShareCouponComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private loader : LoaderService
  ) {
    this.createControl();
    this.createForm();
    this.getPetParent();
  }

  createForm() {
    this.form = this.fb.group({
      shareVia: [null, Validators.required],
      petParent: this.fb.array([],Validators.required),
      
    })
  }
  onNoClick(){
    this.dialogRef.close()
  }
  getPetParent(){
    this.userManagementService.getPetParents(1).subscribe((res:Array<any>) => {
      res.forEach((parent)=>{
        this.controlls['petParent']['options'].push({
          name : parent['name'],
          value : parent['name']
        })
      })
    })
  }

  createControl() {
    this.controlls = {
      shareVia: {
        id: "shareVia",
        name: 'shareVia',
        label: "Share Via",
        required: true,
        type: "radio",
        options : [
          {
            name:'email',
            value : 'Email'
          },
          {
            name:'sms',
            value : 'Sms'
          }
        ]
      },
      petParent: {
        id: "petParent",
        name: 'petParent',
        label: "Add Pet Parent",
        required: true,
        type: "dropdown",
        options: [
          
        ]
      },
    }
  }

  shareCoupan(){
    this.dialogRef.close();
    
  }

}
