import { Component, EventEmitter, Inject, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { CouponManagementService } from 'app/services/coupon-management.service';
import { EducationService } from 'app/services/education.service';
import { MiscellaneousService } from 'app/services/miscellaneous.service';
import { ValidationsService } from 'app/services/validations.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import moment from 'moment';
import { ShareCouponComponent } from '../share-coupon/share-coupon.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
// import { ShareCouponComponent } from '../share-coupon/share-coupon.component';

@Component({
  selector: 'app-create-coupan',
  templateUrl: './create-coupan.component.html',
  styleUrls: ['./create-coupan.component.scss']
})
export class CreateCoupanComponent {
  form: FormGroup;
  controlls: any;
  workspaces = [];
  count = 0;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  constructor(
    private fb: FormBuilder,
    private validationsService: ValidationsService,
    private couponManagementService: CouponManagementService,
    private workspaceManagementService: WorkspaceManagementService,
    private educationService: EducationService,
    private miscellaneousService: MiscellaneousService,
    private router: Router,
    public dialog: MatDialog,
    private loader: LoaderService
  ) {
    this.createControl();
    this.createForm();
  }

  async ngOnInit() {
    // this.edit();
    this.form.get('serviceType').valueChanges.subscribe((change) => {
      console.log(change);
      this.form.get('workSpace').reset();
      if (change == 'Open') {
        this.form.get('workSpace').clearValidators();
        this.form.get('workSpace').updateValueAndValidity();
      }
      else {
        this.form.get('workSpace').setValidators([Validators.required]);
        this.form.get('workSpace').updateValueAndValidity();
      }
      this.onServiceTypeChange(change);
    })
    // if(!this.editData){
    this.form.get('workSpace').valueChanges.subscribe((change) => {
      console.log(change);
      this.onWorkSpaceChange(change)
    })
    // }
  }

  ngOnChanges() {
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }
  }

  edit() {

    if (this.editData) {
      console.log(this.editData);
      this.form = this.fb.group({
        coupanCode: [this.editData['code'], [Validators.required, this.validationsService.stringValidator()]],
        serviceType: [this.editData['publishedFor'], Validators.required],
        discount: [this.editData['discount'], Validators.required],
        discountType: [this.editData['discountType'], Validators.required],
        workSpace: ['',],
        refId: [this.editData['refId']],
        startDate: [new Date(this.editData['startDate']), Validators.required],
        description: [this.editData['description'], Validators.required],
        couponQuantity: [this.editData['quantity'], Validators.required],
        endDate: [new Date(this.editData['endDate']), Validators.required]
      })
      // this.onServiceTypeChange(this.editData['publishedFor']);
      this.serviceTypeChangeonEdit(this.editData['publishedFor'])
      this.form.get('workSpace').valueChanges.subscribe((change) => {
        console.log(change);
        this.onWorkSpaceChange(change)
      })
    }
  }

  getWorkspacesEdit(serviceId: string) {/// in edit only
    // debugger
    this.loader.showLoader()
    this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      console.log(res);
      this.loader.hideLoader()
      this.workspaces = res;
      res.forEach((element) => {
        // element['collaboratorId']
        this.controlls['workSpace']['options'].push(
          {
            name: element['designationName'] + ':' + element['workplaceName'],
            value: element['designationName'] + ':' + element['workplaceName']
          }
        );

        this.controlls['workSpace'] = JSON.parse(JSON.stringify(this.controlls['workSpace']));
        if (this.editData) {
          if (this.editData['refId'] == element['id']) {//316ff847-641e-474e-98d5-d14c4fb6e9db
            console.log("got workspace");

            this.form.get('workSpace').setValue(element['designationName'] + ':' + element['workplaceName']);
          }
        }
      });
    })
  }
  getWorkSpaces(serviceId: string) {
    this.loader.showLoader()
    this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      console.log(res);
      this.loader.hideLoader()
      this.workspaces = res;
      res.forEach((element) => {
        // element['collaboratorId']
        this.controlls['workSpace']['options'].push(
          {
            name: element['designationName'] + ':' + element['workplaceName'],
            value: element['designationName'] + ':' + element['workplaceName']
          });

      });
      this.controlls['workSpace'] = JSON.parse(JSON.stringify(this.controlls['workSpace']));
    })
  }

  shareCoupan() {
    const dialogRef = this.dialog.open(ShareCouponComponent, {
      width: '500px',
      data: { unAssignedCoupon: this.editData['quantity'] }
    });
  }

  serviceTypeChangeonEdit(type) {//in edit only
    // debugger
    this.controlls['workSpace']['options'] = [];
    let serviceId;
    if (type == "Veterinary") {
      this.controlls['workSpace']['label'] = "Select Workspace*"
      serviceId = "d8d71038-c48c-11ed-abc1-02817ef0919c";
      this.getWorkspacesEdit(serviceId);

    } else if (type == "Grooming") {
      this.controlls['workSpace']['label'] = "Select Workspace*"
      serviceId = "5e4c6b60-c48e-11ed-abc1-02817ef0919c";
      this.getWorkspacesEdit(serviceId);
    }
    else if (type == 'Webinar') {
      this.controlls['workSpace']['label'] = "Select Webinar*"
      this.educationService.getAllWebiars().subscribe((res: Array<any>) => {
        this.workspaces = res;
        res.forEach((el) => {
          this.controlls['workSpace']['options'].push(
            {
              name: el['title'],
              value: el['title']
            }
          )
          if (this.editData) {
            if (this.editData['refId'] == el['id']) {
              this.form.get('workSpace').setValue(el['title']);
            }
          }
        })
      })
    } else if (type == 'Course') {
      this.controlls['workSpace']['label'] = "Select Course*"
      this.educationService.getCources().subscribe((res: Array<any>) => {
        this.workspaces = res;
        res.forEach((el) => {
          this.controlls['workSpace']['options'].push(
            {
              name: el['title'],
              value: el['title']
            }
          )
          if (this.editData) {
            if (this.editData['refId'] == el['id']) {
              this.form.get('workSpace').setValue(el['title']);
            }
          }
        })
      })
    } else if (type == "Events") {
      this.controlls['workSpace']['label'] = "Select Event*"
      this.miscellaneousService.getEvent().subscribe((res: Array<any>) => {
        this.workspaces = res;
        console.log(res);
        // title
        res.forEach((el) => {
          this.controlls['workSpace']['options'].push(
            {
              name: el['title'],
              value: el['title']
            }
          )
          if (this.editData) {
            if (this.editData['refId'] == el['id']) {
              this.form.get('workSpace').setValue(el['title']);
            }
          }
        })
      })
      this.controlls['workSpace'] = JSON.parse(JSON.stringify(this.controlls['workSpace']));
    }
    // this.couponManagementService.editWorkspace = tr
    // this.editWorkspace = true;
    // })
  }

  onServiceTypeChange(change) {
    // debugger
    console.log(change);
    // this.form.get('serviceType').valueChanges.subscribe((change) => {
    this.controlls['workSpace']['options'] = [];
    let serviceId;
    if (change == "Veterinary") {
      this.controlls['workSpace']['label'] = "Select Workspace*"
      serviceId = "d8d71038-c48c-11ed-abc1-02817ef0919c";
      this.getWorkSpaces(serviceId);

    } else if (change == "Grooming") {
      this.controlls['workSpace']['label'] = "Select Workspace*"
      serviceId = "5e4c6b60-c48e-11ed-abc1-02817ef0919c";
      this.getWorkSpaces(serviceId);
    }
    else if (change == 'Webinar') {
      this.controlls['workSpace']['label'] = "Select Webinar*"
      this.educationService.getAllWebiars().subscribe((res: Array<any>) => {
        this.workspaces = res;
        res.forEach((el) => {
          this.controlls['workSpace']['options'].push(
            {
              name: el['title'],
              value: el['title']
            }
          )

        })
      })
    } else if (change == 'Course') {
      this.controlls['workSpace']['label'] = "Select Course*"
      this.educationService.getCources().subscribe((res: Array<any>) => {
        this.workspaces = res;
        res.forEach((el) => {
          this.controlls['workSpace']['options'].push(
            {
              name: el['title'],
              value: el['title']
            }
          )

        })
      })
    } else if (change == "Events") {
      this.controlls['workSpace']['label'] = "Select Event*"
      this.miscellaneousService.getEvent().subscribe((res: Array<any>) => {
        this.workspaces = res;
        console.log(res);
        // title
        res.forEach((el) => {
          this.controlls['workSpace']['options'].push(
            {
              name: el['title'],
              value: el['title']
            }
          )

        })
      })
    }
    this.controlls['workSpace'] = JSON.parse(JSON.stringify(this.controlls['workSpace']));
    // this.couponManagementService.editWorkspace = tr
    // this.editWorkspace = true;
    // })
  }

  private snackBar: MatSnackBar
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  onWorkSpaceChange(workspaceName) {
    this.onServiceTypeChange(this.form.get('serviceType').value);
    // refId
    console.log(this.form.get('serviceType').value);
    this.workspaces.forEach((workspace) => {
      if (this.form.get('serviceType').value == 'Veterinary' || this.form.get('serviceType').value == 'Grooming') {
        if (workspaceName == workspace['designationName'] + ':' + workspace['workplaceName']) {
          this.form.get('refId').setValue(workspace['id'])
        }
      } else {
        if (workspaceName == workspace['title']) {
          console.log(":::");

          this.form.get('refId').setValue(workspace['id'])
        }

      }
    })
  }
  createForm() {
    this.form = this.fb.group({
      coupanCode: [null, Validators.required],
      serviceType: [null, Validators.required],
      discount: [null, Validators.required],
      discountType: ["%", Validators.required],
      startDate: [null, Validators.required],
      description: [null, Validators.required],
      couponQuantity: [null, Validators.required],
      endDate: [null, Validators.required],
      workSpace: [''],
      refId: ['']
    })
  }

  createControl() {
    this.controlls = {
      coupanCode: {
        id: "coupanCode",
        name: 'coupanCode',
        label: "Coupon Code",
        placeholder: "Enter Coupon Code",
        required: true,
        type: "text"
      },
      serviceType: {
        id: "serviceType",
        name: 'serviceType',
        label: "Select Service Type*",
        required: true,
        type: "radio",
        options: [
          {
            name: "FurrCrew",
            value: "Open"
          },
          {
            name: "Veterinary",
            value: "Veterinary"
          }, {
            name: "Grooming",
            value: "Grooming"
          }, {
            name: "Events",
            value: "Events"
          }, {
            name: "Webinar",
            value: "Webinar"
          }, {
            name: "Course",
            value: "Course"
          }

        ]
      },
      workSpace: {
        id: "workSpace",
        name: 'workSpace',
        label: "WorkSpace Name*",
        required: true,
        type: "dropdown",
        options: []
      },
      discount: {
        id: "discount",
        name: 'discount',
        label: "Total Discount",
        placeholder: "Enter discount in percentage",
        required: true,
        type: "text",

      },
      discountType: {
        id: "discountType",
        name: 'discountType',
        label: "Discount Type",
        required: true,
        type: "radio",
        options: [
          {
            name: "%",
            value: "%"
          },
          {
            name: "Rs",
            value: "Rs"
          }

        ]
      },
      startDate: {
        id: "startDate",
        name: 'startDate',
        label: "Start Date",
        placeholder: "mm/dd/yyyy",
        required: true,
        type: "Date"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description",
        placeholder: "Enter Description",
        required: true,
        type: "text"
      },
      couponQuantity: {
        id: "couponQuantity",
        name: 'couponQuantity',
        label: "Coupon Quantity",
        placeholder: "Enter Coupon Quantity",
        required: true,
        type: "text"
      },
      endDate: {
        id: "endDate",
        name: 'endDate',
        label: "End Date",
        placeholder: "mm/dd/yyyy",
        required: true,
        type: "Date"
      }
    }
  }
  onNoClick(): void {
    // this.dialogRef.close();
    this.cancelEvent.emit();
    this.router.navigate(['/coupon']);
  }

  create() {
    let json = this.form.value;
    console.log(json);
    let body = {
      "code": json['coupanCode'],
      "createdBy": "1",
      "expiryDate": moment(json['endDate']).unix(),
      "couponName": json['coupanCode'],
      "quantity": json['couponQuantity'],
      "active": this.editData ? this.editData['active'] : false,
      "discount": json['discount'],
      "startDate": moment(json['startDate']).unix() * 1000,
      "endDate": moment(json['endDate']).unix() * 1000,
      "split": false,
      "publishedFor": json['serviceType'],
      "published": this.editData ? this.editData['active'] : false,
      "collabDiscount": "",
      "discountType": json["discountType"],
      "description": json['description'],
      "refId": json['refId'],
      "type": json["serviceType"],
    }
    if (body['publishedFor'] == "FurrCrew") {
      body['createdBy'] = "1"
    }
    if (this.editData) {
      body['id'] = this.editData['id'];
      this.loader.showLoader()
      this.couponManagementService.updateCoupon('1', body, this.editData['id']).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        this.cancelEvent.emit();
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Coupon updated successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
        // this.dialogRef.close();
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    } else {
      this.loader.showLoader()
      this.couponManagementService.createCoupan(body).subscribe((res) => {
        console.log(res);
        this.couponManagementService.getAllCoupans().subscribe((res => {
          this.loader.hideLoader()
          console.log("res");
        }))
        this.router.navigate(['/coupon']);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Coupon created successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
        // this.dialogRef.close();
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }
}

