import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { CoupanManagementComponent } from './coupan-management.component';
import { CoupanManagementRoutingModule } from './coupan-management-routing.module';

import {MatTableModule} from '@angular/material/table';
import { MatIconModule } from '@angular/material/icon';
import { MatMenuModule } from '@angular/material/menu';
import { CommonComponentsModule } from 'app/components/common-components/common-components.module';
import {MatDialogModule} from '@angular/material/dialog';
import {MatDatepickerModule} from '@angular/material/datepicker';
import {MatNativeDateModule} from '@angular/material/core';
import {MatButtonModule} from '@angular/material/button';
import { ControllersModule } from 'app/components/controllers/controllers.module';
import { MatPaginatorModule } from '@angular/material/paginator';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import {MatSlideToggleModule} from '@angular/material/slide-toggle';
import {MatSidenavModule} from '@angular/material/sidenav';
import {MatButtonToggleModule} from '@angular/material/button-toggle';
import { CreateCoupanComponent } from './create-coupan/create-coupan.component';
import { ShareCouponComponent } from './share-coupon/share-coupon.component';
import { CouponUsageComponent } from './coupon-usage/coupon-usage.component';
import { FormsModule } from '@angular/forms';
import {MatCheckboxModule} from '@angular/material/checkbox';
@NgModule({
  declarations: [
    CoupanManagementComponent,
    CreateCoupanComponent,
    ShareCouponComponent,
    CouponUsageComponent
  ],
  imports: [
    CommonModule,
    CoupanManagementRoutingModule,
    MatTableModule,
    MatDialogModule,
    ControllersModule,
    MatButtonModule,
    MatSidenavModule,
    MatMenuModule,
    MatIconModule,
    CommonComponentsModule,
    MatPaginatorModule,
    MatSnackBarModule,
    MatButtonToggleModule,
    MatSlideToggleModule,
    MatCheckboxModule,
    FormsModule
  ]
})
export class CoupanManagementModule { }
