import { Component, ViewChild } from '@angular/core';
import { CouponManagementService } from '../../services/coupon-management.service';
import { MatMenuTrigger } from '@angular/material/menu';
import { Router } from '@angular/router';
import { MatDialog } from '@angular/material/dialog';
import { MatSidenav } from '@angular/material/sidenav';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { saveAs } from 'file-saver'; // Import the saveAs function
import { MatSnackBar } from '@angular/material/snack-bar';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { CouponUsageComponent } from './coupon-usage/coupon-usage.component';
import { LoaderService } from 'app/services/loader.service';
import { ChangeDetectorRef } from '@angular/core';

@Component({
  selector: 'app-coupan-management',
  templateUrl: './coupan-management.component.html',
  styleUrls: ['./coupan-management.component.scss']
})
export class CoupanManagementComponent {
  searchTerm: string = '';
  displayedColumns: string[] = ['selector','id', 'coupan', 'count', 'quantity', 'discount', 'discountType', 'active', 'action'];
  coupans: MatTableDataSource<any>;
  showAll: boolean = false;
  @ViewChild('sidenav') sidenav: MatSidenav;
  @ViewChild(MatPaginator) paginator: MatPaginator;
  selectedRow
  row: any;
  data: any;
  showFiller: boolean = false;

  constructor(
    private couponManagementService: CouponManagementService,
    private router: Router,
    public dialog: MatDialog,
    private snackBar: MatSnackBar,
    private loader : LoaderService,
    private _snackBar: MatSnackBar,
    private cdr: ChangeDetectorRef
  ) {
    this.getCoupans();
  }

  ngAfterViewInit() {
    this.coupans.paginator = this.paginator;
  }

  getCoupans() {
    this.loader.showLoader();
  this.couponManagementService.getAllCoupans().subscribe((res: Array<any>) => {
    this.loader.hideLoader();
    const ary = this.showAll ? res : res.filter(el => el.active);
    this.coupans = new MatTableDataSource(ary.map(item => ({ ...item, selected: false })));
    this.coupans.paginator = this.paginator;
    this.data = ary;
  });
  }
  showDataEvent(event) {
    this.showAll = !this.showAll;
    this.getCoupans()
  }

  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;

  editUser() {
    // this.menuTrigger.closeMenu();
    this.row = this.selectedRow;
    this.showFiller = true;
    this.sidenav.toggle();
    // const dialogRef = this.dialog.open(CreateCoupanComponent,{
    //   data: { editData: this.row, },
    //   width: '700px'
    // },

    //   );
    // // this.row = this.data[row];
    // dialogRef.afterClosed().subscribe(result => {
    //   console.log('The dialog was closed');
    // });

  }
  clickName (element) {
    console.log(element);
    
    this.row = this.selectedRow;
    this.row=element;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  stats() {//stats
    let stats : MatTableDataSource<any>;
    let aray=[]
    this.loader.showLoader()
    this.couponManagementService.couponUsage(this.selectedRow['id'], 'COUPON').subscribe((res: Array<any>) => {
      this.loader.hideLoader()
      res.forEach((el) => {
        stats = new MatTableDataSource(res.map((item: any) => ({ ...item, })));
      })
      const dialogRef = this.dialog.open(CouponUsageComponent, {
        data: { stats: stats },
        panelClass: 'custom-dialog-content'
      });

    })
  }

  deleteUser() {
    this.menuTrigger.closeMenu();
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader()
        this.couponManagementService.deleteCoupan(this.selectedRow['id'], 1).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          this.getCoupans();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Coupon deleted successfully!',success : true },
            panelClass: 'success-dialog-container'
          });
        }, (error) => {
          this.loader.hideLoader()
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Something Went Wrong!',success : false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
  }



  filter(searchTerm: string) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  applyFilter() {
    // Modify the logic to filter based on the search term
    this.coupans.filter = this.searchTerm.trim().toLowerCase();
  }

  add(event) {
    this.router.navigate(['/coupon/create']);
    // console.log(event);
    // const dialogRef = this.dialog.open(CreateCoupanComponent,{
    //   data: { editData: null, }});
    // dialogRef.afterClosed().subscribe(result => {
    //   console.log('The dialog was closed');
    // });
  }

  export(event) {
    this.cdr.detectChanges();
    const selectedCoupans = this.getSelectedCoupans();
    console.log('Selected Coupans for Export:', selectedCoupans); // Debugging line

    if (selectedCoupans.length > 0) {
        const csvData = this.convertToCSV(selectedCoupans);
        const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });
        saveAs(blob, 'coupans.csv');
    } else {
        this.openSnackBar('No selected rows to export.');
    }
  }

  getSelectedCoupans() {
    const selectedRows = this.coupans.data.filter(row => row.selected);
    console.log('Selected Rows:', selectedRows); // Ensure this logs selected rows correctly
    return selectedRows;
  }

  convertToCSV(data: any[]): string {
    if (data.length === 0) return '';
    const header = Object.keys(data[0]).join(',');
    const csv = data.map(row => Object.values(row).join(',')).join('\n');
    return `${header}\n${csv}`;
  }

  toggle(row, element) {
    this.selectedRow = element;
    // this.row = new Array()
    // this.row = this.data[row];
    // this.sidenav.toggle();
  }

  cancel() {
    this.getCoupans();
    this.sidenav.toggle();
  }

  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Inactive';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(`Status changed to: ${newStatus} for element with ID: ${element.id}`);
    this.updatestatus(newStatus, element);
  }
  
  updatestatus(newStatus, element) {
    let body = {
      "id": element.id,
      "code": element.code,
      "createdBy": element.createdBy,
      "expiryDate": element.expiryDate,
      "couponName": element.couponName,
      "quantity": element.quantity,
      "discount": element.discount,
      "usedCount": element.usedCount,
      "startDate":element.startDate,
      "endDate": element.endDate,
      "split": element.split,
      "publishedFor": element.publishedFor,
      "published": element.published,
      "collabDiscount": element.collabDiscount,
      "description" : element.description,
      "discountType": element.discountType,
      "active": newStatus === 'Active',
      "type": element.type,
      "refId" : element.refId

    }
    this.loader.showLoader()
    this.couponManagementService.updateCoupon("1", body, "1").subscribe(
      (res) => {
        this.loader.hideLoader()
        console.log(res);
        this.showSuccessToast('Update successful');
      },
      (error) => {
        this.loader.hideLoader()
        console.error(error);
        this.showErrorToast('Update failed');
      }
    );
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
