import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { AppointmentManagementService } from 'app/services/appointment-management.service';
import { LoaderService } from 'app/services/loader.service';
import { TimeDateService } from 'app/services/time-date.service';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';

@Component({
  selector: 'app-veterinary',
  templateUrl: './veterinary.component.html',
  styleUrls: ['./veterinary.component.scss']
})
export class VeterinaryComponent {

  @Input() form: FormGroup;
  controllers: any;
  services: Array<any> = []
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();

  collaborators: any;
  workspaceData: any;
  petParentId: string;
  isHomeVsit: boolean = false;
  servicesArray: Array<any> = [];
  petId: string;

  constructor(
    private fb: FormBuilder,
    private userManagementService: UserManagementService,
    private workspaceManagementService: WorkspaceManagementService,
    private router: Router,
    private appointmentManagementService: AppointmentManagementService,
    private timeDateService: TimeDateService,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader: LoaderService,
    private validationsService: ValidationsService
  ) {
    this.createFormControls();
    this.getCollaborators();
    this.getPetParent();
  }

  ngOnInit() {
    this.form.get('vetSelectedServices').valueChanges.subscribe((value) => {
      this.form.get('address').reset()
      if (value == 'Home Visit') {
        this.form.get('address').setValidators(Validators.required);
        this.form.get('address').updateValueAndValidity();
      } else {
        this.form.get('address').clearValidators();
        this.form.get('address').updateValueAndValidity();
      }

    })
    this.form.get('collaborator').valueChanges.subscribe((value) => {
      // this.form.get('vetSelectedServices').reset();
      this.onCollaboratorChange();
    })
    this.form.get('petParent').valueChanges.subscribe((value) => {
      this.onPetParentChange();
    })
    this.form.get('petName').valueChanges.subscribe((chnage) => {
      if (this.petParentId) {
        this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe((res: Array<any>) => {
          res.forEach((pet) => {
            if (pet['petName'] == chnage) {
              this.petId = pet['id']
            }
          })
        })
      }
    })
    this.form.get('selectSlot').valueChanges.subscribe((chnage) => {
      this.onSlotSelect(chnage)
    })
  }

  ngOnChanges() {
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }

    // this.bookedService()
    this.onServiceSelect();
  }



  onNoClick(): void {
    this.cancelEvent.emit();
  }

  async edit() {
    // debugger
    let serviceId;
    this.form.get('bookedBy').setValue(this.editData['id'])
    console.log(this.editData);
    console.log(JSON.parse(this.editData['bookedServices']));
    if (this.editData['serviceName'] == "Veterinary") {
      serviceId = "d8d71038-c48c-11ed-abc1-02817ef0919c";
      JSON.parse(this.editData['bookedServices']).forEach((service) => {
        this.form.get('vetSelectedServices').setValue(service['name']);
      })
      // if(JSON.parse(this.editData['bookedServices'])[0]['name'] == 'Home Visit'){
      //   this.form.get('serviceCategory').setValue('Home Visit')
      // }else{
      //   this.form.get('serviceCategory').setValue('Center')
      // }
    }
    this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      this.controllers['collaborator']['options'] = [];
      this.controllers['workPlace']['options'] = [];
      this.controllers['services']['options'] = [];
      this.controllers['petName']['options'] = [];
      // this.controllers['petParent']['options'] = [];
      res.forEach((element) => {
        if (element['status'] == 'Active') {
          this.controllers['collaborator']['options'].push(
            {
              name: element['designationName'] + "-" + element['workplaceName'],
              value: element['designationName'] + "-" + element['workplaceName']
            }
          );
        }
        if (this.editData['designationName'] + "-" + this.editData['workspaceName'] == element['designationName'] + "-" + element['workplaceName']) {
          console.log("inside check");

          this.form.get('collaborator').setValue(this.editData['designationName'] + "-" + this.editData['workspaceName']);
          this.form.get('workspaceId').setValue(element['id']);
          this.form.get('collaboratorId').setValue(element['collaboratorId']);
          this.controllers['selectDate'].options = [];
          this.controllers['selectSlot'].options = [];
          // console.log(this.timeDateService.getNext5Days());
          this.controllers['selectDate'].options = this.timeDateService.getNext5WorkingDays(element['workplaceTime']['days']);
          this.controllers['selectSlot'].options = this.timeDateService.getTimeSlots(element['workplaceTime']['start_time'], element['workplaceTime']['end_time'], element['workplaceTime']['lunch_break']['start_time'], element['workplaceTime']['lunch_break']['end_time']);
          let servicesArray = this.form.get('services') as FormArray;
          // servicesArray.clear();
          element['services'].forEach((service, i) => {
            servicesArray.push(
              this.fb.group(
                {
                  description: service['description'],
                  convenienceFee: [service['convenienceFee']],
                  rate: [service['rate']],
                  gstPrice: [service['gstPrice']],
                  isHomeVisit: [service['isHomeVisit']],
                  name: [service['name']],
                  type: [service['type']]
                }
              )
            );
            // groomArray.push(this.fb.control(''))
          });
          this.bookedService();

          // this.timeSlot(element['workplaceTime']['start_time'], element['workplaceTime']['end_time'], element['workplaceTime']['lunch_break']['end_time'], element['workplaceTime']['lunch_break']['start_time']);

        }
      });
      this.form.get('selectDate').setValue(this.timeDateService.millisecondsToDateTime(this.timeDateService.dateToMilliseconds(new Date(this.editData['appointmentDate'])))['date'].toDateString());
      this.form.get('selectSlot').setValue(this.timeDateService.millisecondsToDateTime(this.timeDateService.dateToMilliseconds(new Date(this.editData['appointmentDate'])))['time']);
      this.form.get('workPlace').setValue(this.editData['workspaceName']);

    })
    this.userManagementService.getPetParents(1).subscribe((res: Array<any>) => {
      res.forEach(element => {
        this.controllers['petParent']['options'].push(
          {
            name: element['mobile'],
            value: element['mobile']
          }
        )
        this.petParentId = this.editData['bookedBy'];
        this.petId = this.editData['petId']
        if (element['id'] == this.editData['bookedBy']) {
          this.form.get('petParent').setValue(element['mobile']);
          if (element['mobile'] == this.form.get('petParent').value) {
            this.controllers['petParentName']['options'].push({
              name: element['name'],
              value: element['name']
            })
            this.form.get('petParentName').setValue(element['name'])
          }
        }
      });
    })
    await this.userManagementService.getAllPetsByPetParent(this.editData['bookedBy']).subscribe((res: Array<any>) => {
      res.forEach(pet => {
        this.controllers['petName']['options'].push({
          name: pet['petName'],
          value: pet['petName']
        })
        // debugger
        if (this.editData['petId'] == pet['id']) {
          this.form.get('petName').setValue(pet['petName'])
        }
      });
    })
  }


  create() {
    // this.router.navigate(['/appointment/add']);
    let json = this.form.value;
    console.log(this.form);

    let body = {
      "amount": 1180,
      "bookedBy": this.petParentId,
      "bookedServices": json['bookedServices'],
      "currency": "INR",
      "endTime": json['endTime'],//moment(json['endDate']).unix(),
      "startTime": json['startTime'],
      "petId": this.petId,
      "serviceId": 'd8d71038-c48c-11ed-abc1-02817ef0919c',
      //moment(json['startDate']).unix(),
      "subType": "",//this.editData['subType'] ? this.editData['subType'] : '',
      "type": json['bookedServices'][0]['name'],
      "workspaceId": json['workspaceId'],
      "status": this.editData ? this.editData['status'] : 'Created',
      "addressId": json['address'] ? json['address'] : '',
      "collaboratorId": json['collaboratorId'],
      "appointmentDate": '',
      "appointmentEndDate": ''
      // "serviceStartToEndDateRange" : json['serviceStartToEndRange'],
      // "serviceDate" : json['serviceDate']
    }

    if (this.editData) {
      body['id'] = this.editData['id']

      this.loader.showLoader()
      this.appointmentManagementService.updateAppointment(body, json['collaboratorId']).subscribe((res) => {
        this.appointmentManagementService.getAppointment().subscribe((res) => {
          this.loader.hideLoader();
          this.onNoClick();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Appointment successfully updated!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }
      );
    } else {
      this.loader.showLoader()
      this.appointmentManagementService.createAppointment(body, json['collaboratorId']).subscribe((res) => {
        this.appointmentManagementService.getAppointment().subscribe((res) => {
          this.loader.hideLoader()
          this.router.navigate(['/appointment'])
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Appointment successfully created!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }

      )
    }

  }

  onServiceSelect() {
    let fArray = this.form.get('bookedServices') as FormArray;
    console.log(this.form.get('services'));


    this.form.get('vetSelectedServices').valueChanges.subscribe((chnage) => {
      console.log(chnage);

      fArray.clear();
      // console.log(this.form.get('vetSelectedServices').value);
      this.form.get('services')['controls'].forEach((service) => {
        if (service.get('name').value == chnage) {
          fArray.push(service)
        }
      })
      console.log(fArray);

      // selectedServices
    })

  }

  bookedService() {
    let fArray = this.form.get('bookedServices') as FormArray;
    if (this.form.get('services').value.length > 0) {
      this.form.get('services')['controls'].forEach((service) => {
        if (service.get('name').value == this.form.get('vetSelectedServices').value) {
          fArray.push(service)
        }
      })
    }
  }


  async getCollaborators() {
    let serviceId = 'd8d71038-c48c-11ed-abc1-02817ef0919c'

    this.controllers['collaborator']['options'] = [];
    this.controllers['workPlace']['options'] = [];
    this.controllers['selectDate']['options'] = [];
    this.controllers['services']['options'] = [];
    this.controllers['petName']['options'] = [];
    this.controllers['petParent']['options'] = [];
    await this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      this.workspaceData = res;
      console.log(res);
      res.forEach(element => {
        if (element['status'] == 'Active') {
          this.controllers['collaborator']['options'].push(
            {
              name: element['designationName'] + "-" + element['workplaceName'],
              value: element['designationName'] + "-" + element['workplaceName']
            }
          )
        }
      });
    })
  }
  onCollaboratorChange() {
    // debugger
    let serviceId = "d8d71038-c48c-11ed-abc1-02817ef0919c";

    this.form.get('workPlace').reset();
    this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      console.log(res);
      res.forEach(element => {
        if (element['designationName'] + "-" + element['workplaceName'] == this.form.get('collaborator').value) {
          this.form.get('bookedBy').setValue(element['id']);
          this.form.get('workspaceId').setValue(element['id']);
          this.form.get('collaboratorId').setValue(element['collaboratorId'])
          this.controllers['services']['options'] = [];
          this.controllers['selectDate']['options'] = [];
          this.controllers['workPlace']['options'] = [];
          let servicesArray = this.form.get('services') as FormArray
          servicesArray.clear()
          this.isHomeVsit = element['services'].some(service => service['isHomeVisit']);
          element['services'].forEach((service, i) => {
            servicesArray.push(
              this.fb.group(
                {
                  description: service['description'],
                  convenienceFee: [service['convenienceFee']],
                  rate: [service['rate']],
                  gstPrice: [service['gstPrice']],
                  isHomeVisit: [service['isHomeVisit']],
                  name: [service['name']]
                }
              )
            );
            // this.servicesArray.push('');


          });
          this.form.get('workPlace').setValue(element['workplaceName']);
          let dayArray = []
          element['workplaceTime']['days'].forEach((day) => {
            if (this.timeDateService.getDayOfWeekFromString(day) !== null) {
              dayArray.push(this.timeDateService.getDayOfWeekFromString(day))
            }
          })
          // console.log(this.timeDateService.getNext5Days());
          this.controllers['selectDate'].options = this.timeDateService.getNext5WorkingDays(element['workplaceTime']['days']);
          this.controllers['selectSlot'].options = this.timeDateService.getTimeSlots(element['workplaceTime']['start_time'], element['workplaceTime']['end_time'], element['workplaceTime']['lunch_break']['start_time'], element['workplaceTime']['lunch_break']['end_time']);

        }
      });
    })
  }
  onSlotSelect(chnage) {
    // this.form.get('selectDate').valueChanges.subscribe((chnage)=>{

    // })
    // this.form.get('selectSlot').valueChanges.subscribe((chnage)=>{

    // })
    this.form.get('startTime').setValue(this.timeDateService.dateTimeToMilliseconds(this.form.get('selectDate').value, this.form.get('selectSlot').value)['startTime']);
    this.form.get('endTime').setValue(this.timeDateService.dateTimeToMilliseconds(this.form.get('selectDate').value, this.form.get('selectSlot').value)['endTime'])
  }
  formatDate(date) {
    return ('0' + date.getDate()).slice(-2);
  }

  onPetParentChange() {
    this.controllers['petParentName']['options'] = [];
    this.controllers['petName']['options'] = [];
    this.userManagementService.getPetParents(1).subscribe((res: Array<any>) => {
      res.forEach((ele) => {
        if (ele['mobile'] == this.form.get('petParent').value) {
          this.controllers['petParentName']['options'].push({
            name: ele['name'],
            value: ele['name']
          })
          if (this.controllers['petParentName']['options'].length == 1) {
            this.form.get('petParentName').setValue(ele['name'])
          }
          this.petParentId = ele['id'];
          let addresses = this.form.get('addresses') as FormArray;
          addresses.clear()
          if (this.petParentId) {
            this.appointmentManagementService.getAddress("1", this.petParentId).subscribe((res: Array<any>) => {
              console.log(res);
              res.forEach((el) => {
                addresses.push(this.fb.group({
                  id: [el['id']],
                  userId: [el['userId']],
                  type: [el['type']],
                  flatNo: [el['flatNo']],
                  location: [el['latitude'] + "," + el['longitude']],
                  address: [el['address']],
                  pincode: [el['pincode']],
                  city: [el['city']],
                  state: [el['state']],
                  default: [el['default']]
                }))
              })
            })
          }
          if (this.editData) {
            this.form.get('address').setValue(this.editData['addressId'])
          }
          this.userManagementService.getAllPetsByPetParent(ele['id']).subscribe((res: Array<any>) => {
            res.forEach(pet => {
              this.controllers['petName']['options'].push({
                name: pet['petName'],
                value: pet['petName']
              })
            });
          })
          console.log(this.controllers['petName']['options']);

        }
      })
    })
  }

  getPetParent() {
    this.controllers['petParent']['options'] = [];
    this.userManagementService.getPetParents(1).subscribe((res: Array<any>) => {
      res.forEach(element => {
        this.controllers['petParent']['options'].push(
          {
            name: element['mobile'],
            value: element['mobile']
          }
        )
      });
    })
  }

  createFormControls() {
    this.controllers = {
      serviceType: {
        id: "serviceType",
        name: 'serviceType',
        label: "Select Service",
        required: true,
        placeholder: "Enter Name",
        type: 'radio',
        options: [
          {
            name: 'Veterinary',
            value: 'veterinary'
          },
          {
            name: 'Groomer',
            value: 'groomer'
          },
          {
            name: 'Walker',
            value: 'walker'
          }
        ]
      },
      day: {
        id: "day",
        name: 'day',
        label: "Service Duriation",
        required: true,
        type: 'radio',
        options: [
          {
            name: 'Single Day',
            value: 'Single Day'
          }, {
            name: 'Multiple Days',
            value: 'Multiple Days'
          }
        ]
      },
      serviceCategory: {
        id: "serviceCategory",
        name: 'serviceCategory',
        label: "Service Category",
        required: true,
        placeholder: "Enter Service Category",
        type: 'radio',
        options: [
          {
            name: 'Home Visit',
            value: 'Home Visit'
          },
          {
            name: 'Center',
            value: 'Center'
          },
        ]
      },

      collaborator: {
        id: "collaborator",
        name: 'collaborator',
        label: "Select Collaborator",
        required: true,
        type: 'dropdown',
        options: []
      },
      workPlace: {
        id: "workPlace",
        name: 'workPlace',
        label: "Select WorkPlace",
        required: true,
        type: 'dropdown',
        options: []
      },
      petParent: {
        id: "petParent",
        name: 'petParent',
        label: "Select Pet Parent",
        required: true,
        type: 'dropdown',
        options: []
      },
      petParentName: {
        id: "petParentName",
        name: 'petParentName',
        label: "Pet Parent Name",
        required: true,
        type: 'dropdown',
        options: []
      },
      petName: {
        id: "petName",
        name: 'petName',
        label: "Select Pet Name",
        required: true,
        type: 'dropdown',
        options: []
      },
      selectDate: {
        id: "selectDate",
        name: "selectDate",
        label: "Select Date",
        options: []
      },
      selectSlot: {
        id: "selectSlot",
        name: "selectSlot",
        label: "Select Slot",
        required: true,
        options: []
      },
      startDate: {
        id: "startDate",
        name: "startDate",
        label: "Select StartDate",
      },
      endDate: {
        id: "endDate",
        name: "endDate",
        label: "Select EndDate",
      },
      startTime: {
        id: "startTime",
        name: "startTime",
        label: "Select StartTime",
      },
      endTime: {
        id: "endTime",
        name: "endTime",
        label: "Select EndTime",
      },
      services: {
        id: 'services',
        name: 'services',
        label: 'Select Service',
        options: []
      },
      serviceStartToEndRange: {
        id: 'internalNotes',
        name: 'internalNotes',
        label: 'When',
      },
      serviceDate: {
        id: 'serviceDate',
        name: 'serviceDate',
        label: 'Service Date',
      },
      internalNotes: {
        id: 'internalNotes',
        name: 'internalNotes',
        label: 'Type Internal Notes',
      }

    }
  }

  resetForm() {
    this.form.reset();
  }


}
