import { Component, EventEmitter, Input, Output } from '@angular/core';
import { Form, FormArray, FormBuilder, FormGroup } from '@angular/forms';
import { MatSnackBar } from '@angular/material/snack-bar';

@Component({
  selector: 'app-services',
  templateUrl: './services.component.html',
  styleUrls: ['./services.component.scss']
})
export class ServicesComponent {
  @Input() controller: any;
  @Input() form: FormGroup;
  @Input() multiple: boolean = false;
  @Input() isEditMode: boolean = false;

  constructor(private fb: FormBuilder) {

  }

  ngOnInit() {
    console.log(this.form);

    // console.log(this.multiple);
    console.log(this.form.get('services')['controls']);
    if (this.form.get('serviceType').value == "veterinary") {
      this.multiple = false
    } else if (this.form.get('serviceType').value == "groomer") {
      this.multiple = true
    }
    this.form.get('serviceType').valueChanges.subscribe((res) => {
      if (res == 'veterinary') {
        this.multiple = false
      } else if (res == 'groomer') {
        this.multiple = true;
      }

    })
  }

  ngOnChanges() {
    this.bookedService()
    this.onServiceSelect();
  }
  edit() {
    console.log("edit");
  }
  chnage() {
    console.log(this.form.get('selectedServices'));
  }
  delete() {
    console.log("delet");
  }

  

  onServiceSelect() {
    let fArray = this.form.get('bookedServices') as FormArray;


    if (this.form.get('serviceType').value == "veterinary") {
      this.form.get('vetSelectedServices').valueChanges.subscribe((chnage) => {
        console.log(chnage);
  
        fArray.clear();
        // console.log(this.form.get('vetSelectedServices').value);
        this.form.get('services')['controls'].forEach((service) => {
          if(service == 'Online' || service == 'Offline'){
            this.form.get('serviceCategory').setValue('Center')
          }
          if (service.get('name').value == chnage) {
            fArray.push(service)
          }
        })
        console.log(fArray);
  
        // selectedServices
      })
    } 
    else if (this.form.get('serviceType').value == "groomer") {
      this.form.get('groomSelectedService').valueChanges.subscribe((chnage) => {
        // debugger
        fArray.clear();
        this.form.get('services')['controls'].forEach((el, i) => {
          this.form.get('groomSelectedService').value.forEach((service) => {
            console.log(service);
            if(service == 'Center' || service == 'Home Visit'){
              this.form.get('serviceCategory').setValue(service)
            }
            if (el.get('name').value == service) {
              console.log(el['name']);
              fArray.push(el)
              // groomArray.push([service['name']])
            }
          })
        })

      })
    }   

  }

  bookedService() {
    let fArray = this.form.get('bookedServices') as FormArray;    
    // this.form.get('vetSelectedServices').valueChanges.subscribe((chnage) => {
    // console.log(chnage);

    // fArray.clear();
    // console.log(service);
    if (this.form.get('serviceType').value == "veterinary") {
      this.form.get('services')['controls'].forEach((service) => {
        if (service.get('name').value == this.form.get('vetSelectedServices').value) {
          fArray.push(service)
        }
      })
    } 
    else if (this.form.get('serviceType').value == "groomer") {
      this.form.get('services')['controls'].forEach((el, i) => {
        this.form.get('groomSelectedService').value.forEach((service) => {
          console.log(service);
          console.log(el);
          
          if (el.get('name').value == service) {
            fArray.push(el)
            console.log(fArray);
            
            // groomArray.push([service['name']])
          }
        })
      })
    }    
    // console.log(this.form.get('vetSelectedServices').value);
    console.log(fArray);

    // selectedServices
    // })
  }

  onChange(event, service, i) {
    // debugger
    console.log(event['checked']);
    let fArray = this.form.get('bookedServices') as FormArray;

    if (event['checked']) {
      fArray.push(service)
    } else {
      this.form.get('bookedServices').value.forEach((ser, i) => {
        console.log(ser);
        if (ser['name'] == service.get('name').value) {
          console.log(ser);

          fArray.removeAt(i)
        }
      })
    }

  }
  // onGroomSelectedService() {
  //   this.form.get('groomSelectedService').valueChanges.subscribe((chnage) => {
  //     console.log(this.form.get('groomSelectedService').value);
  //     console.log(this.form.get('bookedServices'));

  //     // this.isHomeVsit = this.form.get('groomSelectedService').value.some(service => (service == 'Home visit'));
  //     // console.log(this.isHomeVsit);

  //   })
  // }
  // onVetSelectedServices() {
  //   this.form.get('vetSelectedServices').valueChanges.subscribe((chnage) => {
  //     console.log(this.form.get('vetSelectedServices').value);


  //   })
  // }

 

}
