import { Component, Inject } from '@angular/core';
import { FormArray, FormBuilder, FormGroup } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { AppointmentManagementService } from 'app/services/appointment-management.service';

@Component({
  selector: 'app-edit-address',
  templateUrl: './edit-address.component.html',
  styleUrls: ['./edit-address.component.scss']
})
export class EditAddressComponent {
  form: FormGroup;
  controlls: any;
  constructor(
    private appointmentManagementService: AppointmentManagementService,
    public dialogRef: MatDialogRef<EditAddressComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder
  ) {
    this.createControllers();
  }
  ngOnInit() {
    console.log(this.data['form']);
    this.form = this.data['form']
  }

  createControllers() {
    this.controlls = {
      type: {
        id: "type",
        name: 'type',
        label: "Enter Type",
        placeholder: "Enter City",
        required: true,
        options: [
          {
            name: 'Home',
            value: 'Home'
          }, {
            name: 'Work',
            value: 'Work'
          },
          {
            name: 'Hotel',
            value: 'Hotel'
          },
          {
            name: 'Other',
            value: 'Other'
          }
        ],
        type: "radio"
      },
      city: {
        id: "city",
        name: 'city',
        label: "Enter City",
        placeholder: "Enter City",
        required: true,
        type: "text"
      },
      state: {
        id: "state",
        name: 'state',
        label: "Enter State",
        placeholder: "Enter State",
        required: true,
        type: "text"
      },
      pincode: {
        id: "pincode",
        name: 'pincode',
        label: "Pincode",
        placeholder: "Enter Pincode",
        required: true,
        type: "text"
      },
      address: {
        id: "address",
        name: 'address',
        label: "Address",
        placeholder: "Enter address",
        required: true,
        type: "text"
      },
      location: {
        id: "location",
        name: 'location',
        label: "Location",
        placeholder: "Enter Location",
        required: true,
        type: "text"
      },

      flatNo: {
        id: "flatNo",
        name: 'flatNo',
        label: "Enter Flat No.",
        placeholder: "Enter Flat No.",
        required: true,
        type: "text"
      },

    }
  }

  edit() {
    let json = this.form.value
    console.log(json);
    let body = {
      userId: this.data['petParentId'],
      type: json['type'],
      flatNo: json['flatNo'],
      latitude: json['location'].split(",")[0].trim(),
      longitude: json['location'].split(",")[1].trim(),
      address: json['address'],
      pincode: json['pincode'],
      city: json['city'],
      state: json['state'],
      default: false,
    }
    if (this.data['status'] == "edit") {
      body['id'] = json['id']
      this.appointmentManagementService.editAddress('1', this.data['petParentId'], body).subscribe((res) => {
        console.log(res);
        console.log(this.data.formArray);

        this.dialogRef.close()
      })
    } else if (this.data['status'] == "add") {
      console.log(this.data);


      this.appointmentManagementService.addAddress('1', this.data['petParentId'], body).subscribe((res) => {
        this.form.get('id').setValue(res['id'])
        let array = this.data.formArray as FormArray
        array.push(this.form)
        console.log(res);
        this.dialogRef.close();
      })
    }
  }

  private snackBar: MatSnackBar
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  onNoClick() {
    this.dialogRef.close()
  }


}
