import { Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { ValidationsService } from 'app/services/validations.service';
import moment from 'moment';
import { Location } from '@angular/common';


@Component({
  selector: 'app-create-appointment',
  templateUrl: './create-appointment.component.html',
  styleUrls: ['./create-appointment.component.scss']
})
export class CreateAppointmentComponent {

  form: FormGroup;
  controllers: any;
  services: Array<any> = []
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  constructor(
    private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private location: Location
  ) {
    this.createFormControls();
    this.createForm();
  }
  ngOnInit() {
    this.form.get('serviceType').valueChanges.subscribe((change)=>{
      if(this.form.get('serviceType').value == 'veterinary'){
        this.form.get('veterinaryForm').reset();
        (this.form.get('veterinaryForm').get('services') as FormArray).clear();//groomSelectedService
        (this.form.get('veterinaryForm').get('addresses') as FormArray).clear();
        (this.form.get('veterinaryForm').get('bookedServices') as FormArray).clear();
      }else if(this.form.get('serviceType').value == 'groomer'){
        this.form.get('groomerForm').reset();
        (this.form.get('groomerForm').get('services') as FormArray).clear();
        (this.form.get('groomerForm').get('addresses') as FormArray).clear();
        (this.form.get('groomerForm').get('groomSelectedService') as FormArray).clear();
        (this.form.get('groomerForm').get('bookedServices') as FormArray).clear();
      }else if(this.form.get('serviceType').value == 'walker'){
        this.form.get('walkerForm').reset();
        (this.form.get('walkerForm').get('addresses') as FormArray).clear();
      }
    })

  }

  ngOnChanges() {
    if (this.editData) {
      if (this.editData['serviceName'] == "Veterinary") {
        this.form.get('serviceType').setValue('veterinary');
      } else if (this.editData['serviceName'] == "Groomers") {
        this.form.get('serviceType').setValue('groomer');
      } else if (this.editData['serviceName'] == 'Walkers') {
        this.form.get('serviceType').setValue('walker');
      }
    }
  }

  // onRadioChange(event){
  //   console.log(event);
  //   if(event == 'veterinary' && this.veterinaryComponent){
  //     this.veterinaryComponent.resetForm();
  //     // this.form.get('veterinaryForm').reset();
  //   }else if(event == 'groomer' && this.groomerComponent){
  //     this.groomerComponent.resetForm();
  //     // this.form.get('groomerForm').reset();
  //   }else if(event == 'walker' && this.walkerComponent){
  //     this.walkerComponent.resetForm();
  //     // this.form.get('walkerForm').reset()
  //   }
  // }

  createForm() {
    this.form = this.fb.group({
      serviceType: ['veterinary', Validators.required],
      veterinaryForm: this.fb.group({
        collaborator: ['', Validators.required],
        workPlace: ['', Validators.required],
        petParent: ['', Validators.required],
        petParentName: ['', Validators.required],
        petName: ['', Validators.required],
        petId: [''],
        bookedBy: [''],
        services: this.fb.array([]),
        vetSelectedServices: [''],
        bookedServices: this.fb.array([], [Validators.required, this.validationsService.minLengthArray(1)]),//
        workspaceId: [''],
        collaboratorId: [''],
        selectDate: ['', Validators.required],
        selectSlot: ['', Validators.required],
        startDate: [''],
        endDate: [''],
        startTime: [''],
        endTime: [''],
        address: [''],
        addresses: this.fb.array([]),
        internalNotes: [''],

        serviceDate: []
      }),
      groomerForm: this.fb.group({
        collaborator: ['', Validators.required],
        workPlace: ['', Validators.required],
        petParent: ['', Validators.required],
        petParentName: ['', Validators.required],
        petName: ['', Validators.required],
        petId: [''],
        bookedBy: [''],
        services: this.fb.array([]),
        serviceCategory: ['Center'],
        groomSelectedService: this.fb.array([]),
        bookedServices: this.fb.array([], [Validators.required, this.validationsService.minLengthArray(1)]),//
        workspaceId: [''],
        collaboratorId: [''],
        selectDate: ['', Validators.required],
        selectSlot: ['', Validators.required],
        startDate: [''],
        endDate: [''],
        startTime: [''],
        endTime: [''],
        address: [''],
        addresses: this.fb.array([]),
        internalNotes: [''],

        serviceDate: []
      }),
      walkerForm: this.fb.group({
        day: [''],
        collaborator: ['', Validators.required],
        workPlace: ['', Validators.required],
        petParent: ['', Validators.required],
        petParentName: ['', Validators.required],
        petName: ['', Validators.required],
        petId: [''],
        bookedBy: [''],
        workspaceId: [''],
        collaboratorId: [''],
        selectDate: ['', Validators.required],
        selectSlot: ['', Validators.required],
        startDate: [''],
        endDate: [''],
        startTime: [''],
        endTime: [''],
        address: ['', Validators.required],
        addresses: this.fb.array([]),
        internalNotes: [''],
        serviceStartToEndRange: this.fb.group({
          start: [''],
          end: ['']
        }),
        serviceDate: []
      })
    })
  }


  onNoClick(): void {
    if(location.href.includes('appointMentId=')){
      this.location.back();
    }else{
      this.router.navigate(['/appointment']);
    }
    this.cancelEvent.emit();
    // pet/editPet
  }

  createFormControls() {
    this.controllers = {
      serviceType: {
        id: "serviceType",
        name: 'serviceType',
        label: "Select Service",
        required: true,
        placeholder: "Enter Name",
        type: 'radio',
        options: [
          {
            name: 'Veterinary',
            value: 'veterinary'
          },
          {
            name: 'Groomer',
            value: 'groomer'
          },
          {
            name: 'Walker',
            value: 'walker'
          }
        ]
      },
    }

  }




}
