import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { AppointmentManagementComponent } from './appointment-management.component';
import { AppointmentManagementRoutingModule } from './appointment-management-routing.module';
import {MatTabsModule} from '@angular/material/tabs';
import {MatTableModule} from '@angular/material/table';
import { MatIconModule } from '@angular/material/icon';
import { MatMenuModule } from '@angular/material/menu';
import { CommonComponentsModule } from 'app/components/common-components/common-components.module';
import { AddAppointmentComponent } from './add-appointment/add-appointment.component';
import { ControllersModule } from 'app/components/controllers/controllers.module';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import {MatButtonModule} from '@angular/material/button';
import {MatDatepickerModule} from '@angular/material/datepicker';
import {MatCardModule} from '@angular/material/card';
import {MatCheckboxModule} from '@angular/material/checkbox';
import {MatSidenavModule} from '@angular/material/sidenav';
import {MatRadioModule} from '@angular/material/radio';
import {MatButtonToggleModule} from '@angular/material/button-toggle';
import {MatSlideToggleModule} from '@angular/material/slide-toggle';
import { MatPaginatorModule } from '@angular/material/paginator';
import { VeterinaryComponent } from './veterinary/veterinary.component';
import { GroomerComponent } from './groomer/groomer.component';

import { AddressesComponent } from './addresses/addresses.component';
import { ServicesComponent } from './services/services.component';
import { EditAddressComponent } from './edit-address/edit-address.component';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { CreateAppointmentComponent } from './create-appointment/create-appointment.component';
import { WalkerComponent } from './walker/walker.component';

@NgModule({
  declarations: [
    AppointmentManagementComponent,
    AddAppointmentComponent,
    VeterinaryComponent,
    GroomerComponent,
    AddressesComponent,
    ServicesComponent,
    EditAddressComponent,
    CreateAppointmentComponent,
    WalkerComponent,
    
  ],
  imports: [
    CommonModule,
    AppointmentManagementRoutingModule,
    MatTabsModule,
    MatSnackBarModule,
    MatTableModule,
    MatCardModule,
    MatCheckboxModule,
    MatSlideToggleModule,
    MatRadioModule,
    MatMenuModule,
    MatDatepickerModule,
    MatIconModule,
    MatSidenavModule,
    CommonComponentsModule,
    ControllersModule,
    FormsModule,
    ReactiveFormsModule,
    MatButtonModule,
    MatButtonToggleModule,
    MatPaginatorModule  
  ]
})
export class AppointmentManagementModule { }
