import { Component, ViewChild } from '@angular/core';
import { AppointmentManagementService } from '../../services/appointment-management.service';
import { MatMenuTrigger } from '@angular/material/menu';
import { Router } from '@angular/router';
import { MatSidenav } from '@angular/material/sidenav';
import { saveAs } from 'file-saver';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';
import moment from 'moment';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
@Component({
    selector: 'app-appointment-management',
    templateUrl: './appointment-management.component.html',
    styleUrls: ['./appointment-management.component.scss'],
})
export class AppointmentManagementComponent {
    searchTerm: string = '';
    index: number;
    displayedColumns: string[] = [
        'selector',
        'id',
        'collaboratorName',
        'serviceName',
        'city',
        'type',
        'workspaceName',
        'appointmentDate',
        'status',
        'action',
    ];
    appointments: MatTableDataSource<any>;
    @ViewChild('sidenav') sidenav: MatSidenav;
    @ViewChild('paginator') paginator: MatPaginator;
    // groomingDataSource = new MatTableDataSource<any>([]);
    // veterinaryDataSource = new MatTableDataSource<any>([]);
    showFiller = false;
    data: any;
    eData
    row: any;
    filterTerm: string = '';
    groomingAppointments: any = [];
    veterinaryAppointments: any = [];
    constructor(
        private appointmentManagementService: AppointmentManagementService,
        private router: Router,
        private dialog: MatDialog,
        private loader : LoaderService,
        private _snackBar: MatSnackBar,
    ) {

    }
    ngOnInit() {
        this.getAppointments();
        this.applyFilter();
        
       
    }
    ngAfterViewInit() {
        
        // setTimeout(() => this.appointments.paginator = this.paginator);
    }

    currentUTCDate(date): string {
        return moment.utc(date).local().format("DD-MMM-YYYY hh:mm A");
    }
    openSnackBar(message: string){
        this._snackBar.open(message,'Close',{
          duration: 2000,
          
        });
      }
    
    copyToClipboard(text: string) {
        navigator.clipboard.writeText(text).then(() => {
          this.openSnackBar('Copied!');
        }).catch(err => {
          console.error('Failed to copy text: ', err);
        });
    }

    getAppointments() {        
        this.loader.showLoader()
        this.appointmentManagementService.getAppointment().subscribe((res: Array<any>) => {
            this.loader.hideLoader()
            console.log(res);
            res.forEach((el) => {
                // el['appointmentDate'] = moment.utc(el['appointmentDate']).local().format("DD-MMM-YYYY");
                // console.log(el['name']);
                // el['collaboratorName'] = el['collaboratorName'] ? el['collaboratorName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
                el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
                // .capitalize()
            })
            this.data = res;
            // this.data = [];
            const appointmentsArray = Object.values(res);
            this.appointments = new MatTableDataSource(
                appointmentsArray.map((item: any) => ({
                    ...item,
                    // id: item.id.substring(0, 8),
                }))
            );
            this.appointments.paginator = this.paginator;
            if(location.href.includes('appointMentId=')){
                const locArray = location.href.split('appointMentId=');
                const appointMentId = locArray[1];
                if(appointMentId){
                    const record = appointmentsArray.find((el)=> el.id == appointMentId);
                    if(record){
                        this.eData = record;
                        this.editUser();
                    }
                }   
            }
            // this.veterinaryDataSource.paginator = this.veterinaryPaginator;
        });

    }
    cancelAppointment() {
        console.log(this.eData);
        // moment(inputDate).unix()*1000
        this.eData['endTime'] = moment(this.eData['appointmentEndDate']).unix()*1000;
        this.eData['startTime'] = moment(this.eData['appointmentDate']).unix()*1000;
       
        this.eData['appointmentDate'] = '';
        this.eData['appointmentEndDate'] = '';
        this.eData['status'] = 'Cancelled'
        // this.eData['collaboratorId'] = 'abc';
        this.loader.showLoader()
        this.appointmentManagementService.updateAppointment(this.eData, this.eData['collaboratorId']).subscribe((res) => {
            this.loader.hideLoader()
            console.log(res);
            this.showSuccessToast('Successfully Cancelled Appointment')

        }, (error) => {
            this.loader.hideLoader()
            this.showErrorToast(error)
        }
        )
    }
    @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
    filter(searchTerm: string) {
        this.searchTerm = searchTerm;
        this.applyFilter();
    }
    applyFilter() {
        this.appointments.filter = this.searchTerm.trim().toLowerCase();
        this.appointments.filter = this.searchTerm.trim().toLowerCase();
    }

    add(event) {
        console.log(event);
        this.router.navigate(['/appointment/add']);
    }
    export(event) {
        const selectedAppointments = this.appointments.data.filter(item => item.selected);

    // Check if any rows are selected
    if (selectedAppointments.length === 0) {
        this.openSnackBar('No rows selected for export.');
        return;
    }

    // Convert the selected appointments to CSV format
    const csvData = this.convertToCSV(selectedAppointments);

    // Create a Blob and trigger the download
    const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });
    saveAs(blob, 'appointments.csv');
    }

    convertToCSV(data: any[]): string {
        const header = Object.keys(data[0]).join(',');
        const csv = data.map((row) => Object.values(row).join(',')).join('\n');
        return `${header}\n${csv}`;
    }
    cancel() {
        this.sidenav.toggle();
        this.getAppointments();
    }

    toggle(row, element) {
        this.index = row;
        this.eData = element
    }

    editUser() {
        
        console.log('edit');
        this.row = this.eData;
        this.showFiller = true;
        this.sidenav.toggle();
    }
    deleteUser() {
        console.log('delete');
        this.menuTrigger.closeMenu();
        const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
            width: '400px',
            data: { message: 'Are you sure you want to Delete?' }
        });

        dialogRef.afterClosed().subscribe(result => {
            if (result) {
                // User confirmed action
                this.loader.showLoader()
                this.appointmentManagementService.deleteAppointment(this.eData['id']).subscribe((res) => {
                    console.log(res);
                    this.loader.hideLoader()
                    this.getAppointments();
                    const dialogRef = this.dialog.open(SuccessDialogComponent, {
                        width: '300px',
                        data: { message: 'Appointment deleted successfully', success: true },
                        panelClass: 'success-dialog-container'
                    });
                }, (error) => {
                    this.loader.hideLoader()
                    const dialogRef = this.dialog.open(SuccessDialogComponent, {
                        width: '300px',
                        data: { message: 'Something Went Wrong!', success: false }
                    });
                }
                )

            } else {
                // User cancelled action
                console.log('Cancelled');
                dialogRef.close()
            }
        })
    }

    private snackBar: MatSnackBar
    showSuccessToast(message: string): void {
        this.snackBar.open(message, 'Close', {
            duration: 3000,
            panelClass: ['success-toast'],
        });
    }

    showErrorToast(message: string): void {
        this.snackBar.open(message, 'Close', {
            duration: 3000,
            panelClass: ['error-toast'],
        });
    }
}
