import { Component, Input } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { Controller } from 'app/interfaces/controller';
import { EditAddressComponent } from '../edit-address/edit-address.component';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ValidationsService } from 'app/services/validations.service';
import { AppointmentManagementService } from 'app/services/appointment-management.service';

@Component({
  selector: 'app-addresses',
  templateUrl: './addresses.component.html',
  styleUrls: ['./addresses.component.scss']
})
export class AddressesComponent {
  @Input() form: FormGroup;
  @Input() multiple: boolean = false;
  @Input() petParentId: string;
  editAddres

  constructor(
    public dialog: MatDialog,
    private fb: FormBuilder,
    private snackBar: MatSnackBar,
    private validationService: ValidationsService,
    private appointmentManagementService : AppointmentManagementService
  ) {

  }

  ngOnInit() {
    console.log(this.form);
    
   
  }

  edit() {
    console.log("edit");
    let dialogRef = this.dialog.open(EditAddressComponent, {
      data: { form: this.editAddres, petParentId: this.petParentId, status: "edit" }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
    });
  }

  add() {
    let form: FormGroup = this.fb.group({
      id : [""],
      userId: [""],
      type: ["", Validators.required],
      flatNo: ["", Validators.required],
      location: ["", [Validators.required, this.validationService.locationValidator()]],
      address: ["", [Validators.required, this.validationService.stringValidator()]],
      pincode: ["", [Validators.required, this.validationService.pincodeValidator()]],
      city: ["", [Validators.required, this.validationService.cityValidation()]],
      state: [""],
      default: [''],
    })
    let dialogRef = this.dialog.open(EditAddressComponent, {
      data: { form: form, petParentId: this.petParentId, status: "add", formArray: this.form.get('addresses') }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      
      // this.appointmentManagementService.getAddress("1", this.petParentId).subscribe((res: Array<any>) => {

      // })
    });
  }

  delete() {
    console.log("delet");
  }

  toggle(address) {
    this.editAddres = address
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
