import { Component, ViewChild } from '@angular/core';
import { AdoptionManagementService } from '../../services/adoption-management.service';
import { ActivatedRoute, Router } from '@angular/router';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatSidenav } from '@angular/material/sidenav';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { saveAs } from 'file-saver';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
@Component({
    selector: 'app-adoption-management',
    templateUrl: './adoption-management.component.html',
    styleUrls: ['./adoption-management.component.scss'],
})
export class AdoptionManagementComponent {
    searchTerm: string = '';
    showFiller = false;
    showAll: boolean = false;
    index: number;
    @ViewChild('sidenav') sidenav: MatSidenav;
    row: any;
    data: any;
    selectedRow
    @ViewChild(MatPaginator) paginator: MatPaginator;
    displayedColumns: string[] = [
        'id',
        'petName',
        'type',
        'city',
        'breed',
        'phone',
        'active',
        'adopted',
        'test',
        'action',
    ];
    adoptions: MatTableDataSource<any>;
    constructor(
        private adoptionManagementService: AdoptionManagementService,
        private route: ActivatedRoute,
        private router: Router,
        private snackBar: MatSnackBar,
        private dialog: MatDialog,
        private loader : LoaderService
    ) {
        this.getAdoptions();
    }
    ngAfterViewInit() {
        this.adoptions.paginator = this.paginator;
    }
    getAdoptions() {
        let ary = []
        this.loader.showLoader();
        this.adoptionManagementService.getPetAdoptons('').subscribe((res: Array<any>) => {
            this.loader.hideLoader()
            res.forEach((el) => {
                // console.log(el['name']);
                el['petName'] = el['petName'] ? el['petName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
                el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
                // .capitalize()
                if (!this.showAll) {
                    if (el.status === 'Active') {
                        ary.push(el)
                    }
                } else {
                    ary.push(el)
                }
            })
            this.data = res;
            const adoptionArray = Object.values(ary);
            this.adoptions = new MatTableDataSource(
                adoptionArray.map((item: any) => ({
                    ...item,
                    // id: item.id.substring(0, 8),
                }))
            );
            this.adoptions.paginator = this.paginator;
        });
    }

    showDataEvent(event) {
        this.showAll = !this.showAll;
        this.getAdoptions()
    }

    testChange(event, element){
        this.loader.showLoader()
        this.adoptionManagementService.testChange('ADOPTION',element['id'],event['checked']).subscribe((res)=>{
            this.loader.hideLoader()
            this.showSuccessToast('SuccessFully Done')
        },
        (error)=>{
            this.loader.hideLoader()
            this.showErrorToast('Failed...')
        }
        )
    }

    filter(searchTerm: string) {
        this.searchTerm = searchTerm;
        this.applyFilter();
    }

    applyFilter() {
        this.adoptions.filter = this.searchTerm.trim().toLowerCase();
    }
    add(event) {
        this.router.navigate(['/adoption/add']);
    }
    export(event) {
        const adoptionsToExport = this.data;
        const csvData = this.convertToCSV(adoptionsToExport);
        const blob = new Blob([csvData], { type: 'text/csv;charset=utf-8' });
        saveAs(blob, 'adoptions.csv');
    }

    convertToCSV(data: any[]): string {
        const header = Object.keys(data[0]).join(',');
        const csv = data.map((row) => Object.values(row).join(',')).join('\n');
        return `${header}\n${csv}`;
    }

    @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
    editAdoption() {
        // this.row = new Array();
        // this.row = this.data[this.index];
        this.row = this.selectedRow
        this.showFiller = true;
        this.sidenav.toggle();
    }
    deleteAdoption() {
        // this.menuTrigger.closeMenu();
        const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
            width: '400px',
            data: { message: 'Are you sure you want to Delete?' }
        });

        dialogRef.afterClosed().subscribe(result => {
            if (result) {
                // User confirmed action
                let id = this.selectedRow['id'];
                this.loader.showLoader()
                this.adoptionManagementService.deletePetAdoption(id).subscribe((res) => {
                    this.loader.hideLoader()
                    console.log(res);
                    this.getAdoptions()
                    const dialogRef = this.dialog.open(SuccessDialogComponent, {
                        width: '300px',
                        data: { message: 'Adoption deleted successfully!', success: true },
                        panelClass: 'success-dialog-container'
                    });
                }, (error) => {
                    this.loader.hideLoader()
                    const dialogRef = this.dialog.open(SuccessDialogComponent, {
                        width: '300px',
                        data: { message: 'Something Went Wrong!', success: false }
                    });
                }
                )

            } else {
                // User cancelled action
                console.log('Cancelled');
                dialogRef.close()
            }
        })

        this.menuTrigger.closeMenu();
    }

    toggle(row, element) {
        // drawer.toggle()        
        this.selectedRow = element;
        this.index = row;
    }
    cancel() {
        this.getAdoptions()
        this.sidenav.toggle();
    }
    adoptStatus(event: any, element: any){
        const newStatus = event.checked ? 'Adopted' : 'Inactive';
        this.updatestatus(newStatus, element);
    }
    slideToggleChange(event: any, element: any) {
        const newStatus = event.checked ? 'Active' : 'Inactive';
        // You can now update the status in your data or perform any other actions.
        // For example, you might want to call an API to update the status on the server.
        console.log(
            `Status changed to: ${newStatus} for element with ID: ${element.id}`
        );
        this.updatestatus(newStatus, element);
    }
    updatestatus(newStatus, element) {
        console.log(element);
        
        let body = {
            "id": element.id,
            "refId": element.refId,
            "petName": element.petName,
            "address": element.address,
            "city": element.city,
            "state": element.state,
            "pincode": element.pincode,
            "type": element.type,
            "breed": element.breed,
            "sex": element.sex,
            "month": element.age,
            "year": element.year,
            "color": element.color,
            "weight": element.weight,
            "size": element.size,
            "coatLength": element.coatLength,
            "story": element.story,
            "status": newStatus,
            "mobile": element.mobile,
            "link": element.link,
            "phone": element.phoneNumber,
            "listedBy":element.listedBy,
            "active": newStatus === 'Active'||newStatus === 'Adopted',
        };
        this.loader.showLoader()
        this.adoptionManagementService.updatePetAdoption(body).subscribe(
            (res) => {
                this.loader.hideLoader()
                console.log(res);
                this.showSuccessToast('Update successful');
            },
            (error) => {
                this.loader.hideLoader()
                console.error(error);
                this.showErrorToast('Update failed');
            }
        );
    }
    showSuccessToast(message: string): void {
        this.snackBar.open(message, 'Close', {
            duration: 3000,
            panelClass: ['success-toast'],
        });
    }

    showErrorToast(message: string): void {
        this.snackBar.open(message, 'Close', {
            duration: 3000,
            panelClass: ['error-toast'],
        });
    }
}
