import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { AdoptionManagementService } from 'app/services/adoption-management.service';
import { LoaderService } from 'app/services/loader.service';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';

@Component({
  selector: 'app-add-adoption',
  templateUrl: './add-adoption.component.html',
  styleUrls: ['./add-adoption.component.scss']
})
export class AddAdoptionComponent {
  form: FormGroup;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controllers: any;
  uploadedImages: any[] = [];
  deletedImages: any[] = [];
  constructor(private fb: FormBuilder,
    private userManagementService: UserManagementService,
    private router: Router,
    private adoptionManagementService: AdoptionManagementService,
    private workspaceManagementService: WorkspaceManagementService,
    private snackBar: MatSnackBar,
    private validationsService: ValidationsService,
    private dialog: MatDialog,
    private loader: LoaderService,
    public dialogRef: MatDialogRef<AddAdoptionComponent>,
  ) {
    this.craeteFormControllers();
    this.createForm();
  }
  ngOnInit() {
    if (this.form.get('type').value == "individual") {
      this.controllers['userName']['options'] = []
      this.userManagementService.getPetPArents().then((res: Array<any>) => {
        console.log(res);
        res.forEach((ele) => {
          this.controllers['userName']['options'].push({
            name: ele['name'],
            value: ele['name']
          })
        })
      })
    }
    this.form.get('type').valueChanges.subscribe((change) => {
      this.onServiceTypeChange(change);
    })
    this.form.get('userName').valueChanges.subscribe((chnage) => {
      this.onUserNameChnage(chnage)
    })
    this.form.get('species').valueChanges.subscribe((chnage) => {
      this.controllers['breed']['options'] = [];
      this.adoptionManagementService.getBreeds(chnage).subscribe((res: Array<any>) => {
        res.forEach((el) => {
          this.controllers['breed']['options'].push(
            {
              name: el,
              value: el
            }
          )
        })
      })
    })
  }
  ngOnChanges() {
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save"
      this.edit()
    }
  }

  onUserNameChnage(chnage) {
    if (this.form.get('type').value == "individual") {
      this.userManagementService.getPetPArents().then((res: Array<any>) => {
        console.log(res);
        res.forEach((ele) => {
          if (chnage == ele['name']) {
            this.form.get('userId').setValue(ele['id'])
          }
        })
      })
    } else if (this.form.get('type').value == "ngos") {
      // 5e4a1033-c48e-11ed-abc1-02817ef0919c
      this.workspaceManagementService.getWorkSpaces("5e4a1033-c48e-11ed-abc1-02817ef0919c").subscribe((res: Array<any>) => {
        console.log(res);
        res.forEach((ele) => {
          if (ele['designationName'] == chnage) {
            this.form.get('userId').setValue(ele['id'])
          }
        })

      })
    }
  }

  onServiceTypeChange(change) {

    // this.form.get('type').valueChanges.subscribe((change) => {
    this.controllers['userName']['options'] = [];
    if (this.form.get('type').value == "individual") {
      this.userManagementService.getPetPArents().then((res: Array<any>) => {
        console.log(res);
        res.forEach((ele) => {
          this.controllers['userName']['options'].push({
            name: ele['name'],
            value: ele['name']
          })
        })
      })
    } else if (this.form.get('type').value == "ngos") {
      this.controllers['userName']['options'] = []
      // 5e4a1033-c48e-11ed-abc1-02817ef0919c
      this.workspaceManagementService.getWorkSpaces("5e4a1033-c48e-11ed-abc1-02817ef0919c").subscribe((res: Array<any>) => {
        console.log(res);
        res.forEach((ele) => {
          this.controllers['userName']['options'].push({
            name: ele['designationName'],
            value: ele['designationName']
          })
        })

      })
    } else {
      this.controllers['userName']['options'] = [];
    }

    // })
    // if (this.form.get('type').value == 'ngos') {
    //   this.form.get('userName').valueChanges.subscribe((change) => {
    //     this.workspaceManagementService.getWorkSpaces("5e4a1033-c48e-11ed-abc1-02817ef0919c").subscribe((res: Array<any>) => {
    //       res.forEach((ele) => {
    //         console.log(ele);

    //         if (this.form.get('userName').value == ele['name']) {
    //           this.form.get('userId').setValue(ele['id'])
    //           this.form.get('number').setValue(ele['mobile']);
    //           this.form.get('link').setValue(ele['profileImage']);
    //           this.form.get('city').setValue(ele['city']);
    //           this.form.get('address').setValue(ele['city'])
    //         }
    //       })

    //     })
    //   })
    // }

  }

  onNoClick(): void {

    this.cancelEvent.emit();
    this.router.navigate(['/adoption']);
  }
  edit() {
    console.log(this.editData);
    this.form = this.fb.group({
      userId: [this.editData['refId']],
      type: [this.editData['listedBy'] ? this.editData['listedBy'].toLowerCase() : 'individual', Validators.required],
      number: [this.editData['phone'], [Validators.required, this.validationsService.mobileNumberValidator()]],
      userName: ['', Validators.required],
      link: [this.editData['link'], [this.validationsService.stringValidator()]],
      city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
      state: [this.editData['state'], [Validators.required, this.validationsService.stringValidator()]],
      pincode: [this.editData['pincode'], [this.validationsService.pincodeValidator()]],
      address: [this.editData['address'], [Validators.required, this.validationsService.stringValidator()]],
      name: [this.editData['petName'], [Validators.required, this.validationsService.stringValidator()]],
      species: [this.editData['type'].toLowerCase(), Validators.required],
      breed: [this.editData['breed'], Validators.required],
      sex: [this.editData['sex'].toLowerCase(), Validators.required],
      age: [this.editData['year'], [Validators.required, Validators.pattern('^[0-9]+$')]],
      size: [this.editData['size'].toLowerCase(), Validators.required],
      coatLength: [this.editData['coatLength'].toLowerCase(), Validators.required],
      color: [this.editData['color'].toLowerCase(), Validators.required],
      weight: [this.editData['weight'], [Validators.required, Validators.pattern('^[0-9]+$')]],
      petStory: [this.editData['story'], [Validators.required, this.validationsService.stringValidator()]],
      coverImage: [this.editData['coverImage'], Validators.required],
      imagex: this.fb.array([]),
      featured: [this.editData['featured']],
      sponsored: [this.editData['sponsored']],
      test: [this.editData['test']]
    })
    let array = this.form.get('imagex') as FormArray;
    this.editData['imagesList'].forEach((image) => {
      array.push(this.fb.control(image['value']))
    })
    if (this.editData['listedBy'] == "3rd Parties") {
      this.form.get('type').setValue('3rdparties')
    }
    this.controllers['breed']['options'] = [];
    this.adoptionManagementService.getBreeds(this.editData['type']).subscribe((res: Array<any>) => {
      res.forEach((el) => {
        this.controllers['breed']['options'].push(
          {
            name: el,
            value: el
          }
        )
      })
    });
    this.form.get('breed').setValue(this.editData['breed']);
    if (this.editData['listedBy']) {
      if (this.editData['listedBy'].toLowerCase() == "individual") {
        this.userManagementService.getPetPArents().then((res: Array<any>) => {
          res.forEach((ele) => {
            if (ele['id'] == this.editData['refId']) {
              console.log("hury");

              this.form.get('userName').setValue(ele['name']);
              // this.form.get('link').setValue(ele['profileImage']);
            }
          })
        })
      } else if (this.editData['listedBy'].toLowerCase() == "ngos") {
        this.controllers['userName']['options'] = [];
        this.workspaceManagementService.getWorkSpaces("5e4a1033-c48e-11ed-abc1-02817ef0919c").subscribe((res: Array<any>) => {
          console.log(res);
          res.forEach((ele) => {
            this.controllers['userName']['options'].push({
              name: ele['designationName'],
              value: ele['designationName']
            })

            if (ele['id'] == this.editData['refId']) {
              console.log("##");

              this.form.get('userName').setValue(ele['designationName']);
              // this.form.get('link').setValue(ele['profileImage']);
            }
          })


        })
      } else if (this.editData['listedBy'] == "3rd Parties" || this.editData['listedBy'] == "3RDPARTIES") {
        this.form.get('userName').setValue(this.editData['refId']);
      }
    }
  }

  createForm() {
    this.form = this.fb.group({
      userId: ['', Validators.required],
      type: ['individual', Validators.required],
      number: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
      userName: ['', Validators.required],
      link: ['', [this.validationsService.stringValidator()]],
      city: ['', [Validators.required, this.validationsService.cityValidation()]],
      state: ['', [Validators.required, this.validationsService.stringValidator()]],
      pincode: ['', [this.validationsService.pincodeValidator()]],
      address: ['', [Validators.required, this.validationsService.stringValidator()]],
      name: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: ['', Validators.required],
      breed: ['', Validators.required],
      sex: ['', Validators.required],
      age: ['', [Validators.required, Validators.pattern('^[0-9]+$')]],
      size: ['', Validators.required],
      coatLength: ['', Validators.required],
      color: ['', Validators.required],
      weight: ['', [Validators.required, Validators.pattern('^[0-9]+$')]],
      petStory: ['', [Validators.required, this.validationsService.stringValidator()]],
      coverImage: ['', Validators.required],
      imagex: this.fb.array([]),
      featured: [false],
      sponsored: [false],
      test: [false]
    })
  }
  craeteFormControllers() {
    this.controllers = {
      type: {
        id: "type",
        name: 'type',
        label: "Select Service Type",
        required: true,
        type: "radio",
        options: [
          {
            name: "Individual",
            value: "individual"
          }, {
            name: "NGOs",
            value: "ngos"
          },
          {
            name: "3rdParties",
            value: "3rdparties"
          }

        ]
      },
      number: {
        id: "number",
        name: 'number',
        label: "Phone Number",
        required: true,
        placeholder: "Enter Phone Number",
        type: "text"
      },
      coverImage: {
        id: "coverImage",
        name: "coverImage",
        label: "Cover Image*"
      },
      userName: {
        id: "userName",
        name: 'userName',
        label: "User Name",
        required: true,
        placeholder: "Enter Pet Parent",
        type: "text",
        options: []
      },
      link: {
        id: "link",
        name: 'link',
        label: "Link",
        required: true,
        placeholder: "Enter Link",
        type: "text"
      },
      city: {
        id: "city",
        name: 'city',
        label: "City",
        required: true,
        placeholder: "Enter City",
        type: "text"
      },
      state: {
        id: "state",
        name: 'state',
        label: "State",
        required: true,
        placeholder: "Enter State",
        type: "text"
      },
      pincode: {
        id: "pincode",
        name: 'pincode',
        label: "Pincode",
        required: true,
        placeholder: "Enter Pincode",
        type: "text"
      },
      address: {
        id: "address",
        name: 'address',
        label: "Address",
        required: true,
        placeholder: "Enter Address",
        type: "text"
      },
      name: {
        id: "name",
        name: 'name',
        label: "Name",
        required: true,
        placeholder: "Enter Pet Name",
        type: "text"
      },
      species: {
        id: "species",
        name: 'species',
        label: "Species",
        required: true,
        type: "dropdown",
        options: [
          {
            name: "cat",
            value: "cat"
          }, {
            name: "dog",
            value: "dog"
          }, {
            name: "bird",
            value: "bird"
          },
          {
            name: "exotic",
            value: "exotic"
          }
        ]
      },
      breed: {
        id: "breed",
        name: 'breed',
        label: "Breed",
        required: true,
        type: "dropdown",
        options: [
          {
            name: "xyz",
            value: "xyz"
          }
        ]
      },
      sex: {
        id: "sex",
        name: 'sex',
        label: "Sex",
        required: true,
        type: "dropdown",
        options: [
          {
            name: "female",
            value: "female"
          }, {
            name: "male",
            value: "male"
          }
        ]
      },
      age: {
        id: "age",
        name: 'age',
        label: "Age",
        required: true,
        placeholder: "Eg. 6",
        type: "text"
      },
      size: {
        id: "size",
        name: 'size',
        label: "Size",
        required: true,
        type: "dropdown",
        options: [
          {
            name: "small",
            value: "small"
          }, {
            name: "medium",
            value: "medium"
          }, {
            name: "large",
            value: "large"
          }
        ]
      },
      coatLength: {
        id: "coatLength",
        name: 'coatLength',
        label: "Coat Length",
        required: true,
        type: "dropdown",
        options: [
          {
            name: "short",
            value: "short"
          }, {
            name: "medium",
            value: "medium"
          }, {
            name: "long",
            value: "long"
          }
        ]
      },
      color: {
        id: "color",
        name: 'color',
        label: "Color",
        required: true,
        type: "dropdown",
        options: [
          {
            name: "Black",
            value: "black"
          }, {
            name: "White",
            value: "white"
          }, {
            name: "golden",
            value: "golden"
          }, {
            name: "brown",
            value: "brown"
          }, {
            name: "black & white",
            value: "black & white"
          }, {
            name: "brown & white",
            value: "brown & white"
          },
        ]
      },
      weight: {
        id: "weight",
        name: 'weight',
        label: "Weight",
        required: true,
        placeholder: "Eg. 6 Kgs",
        type: "text"
      },
      petStory: {
        id: "petStory",
        name: 'petStory',
        label: "Pet Story",
        required: true,
        placeholder: "Enter Pet Story",
        type: "text"
      },
      imagex: {
        id: "imagex",
        name: "imagex",
        label: "Upload Images",
        required: true,
      },
      featured: {
        id: "featured",
        name: 'featured',
        label: "Featured",
        required: true,
        type: "boolean"
      },
      sponsored: {
        id: "sponsored",
        name: 'sponsored',
        label: "Sponsored",
        required: true,
        type: "boolean"
      },
      test: {
        id: "test",
        name: 'test',
        label: "Test",
        required: true,
        type: "boolean"
      }

    }
  }
  uploadCoverImage(event) {
    if (this.editData) {
      ///coverImage
      this.loader.showLoader()
      this.adoptionManagementService.uploadCoverImage(this.editData['id'], this.form.get('coverImage').value).subscribe((res) => {
        console.log(res);
        this.loader.hideLoader()
        this.showSuccessToast("SuccessFully uploaded")

      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Faied toupload")
      }
      )
    }
  }
  create() {
    let json = this.form.value;
    console.log(json);
    let body = {
      "refId": json['userId'],//refid
      // "userName": json['userName'],
      "petName": json['name'],
      "address": json['address'],
      "city": json['city'],
      "state": json['state'],
      "listedBy": json['type'].toUpperCase(),
      "pincode": json['pincode'],
      "type": json['species'],
      "breed": json['breed'],
      "sex": json['sex'],
      "month": 0,
      "year": parseInt(json['age']),
      "color": json['color'],
      "weight": json['weight'],
      "size": json['size'],
      "coatLength": json['coatLength'],
      "story": json['petStory'],
      "status": this.editData ? this.editData['status'] : 'Created',
      "mobile": json['number'],
      "link": json['link'],
      "phone": json['number'],
      "featured": json['featured'],
      "sponsored": json['sponsored'],
      "active": this.editData ? this.editData['active'] : false,
      "test": json['test']
    }
    if (this.editData) {
      body['id'] = this.editData['id'];
      this.loader.showLoader()
      this.adoptionManagementService.updatePetAdoption(body).subscribe((res) => {
        console.log(res);
        this.adoptionManagementService.uploadImages(res['id'],json['imagex']).subscribe((res) => {
          console.log(res);
          this.loader.hideLoader()
        }, (error) => {
          this.loader.hideLoader()
        }
        )
        this.onNoClick()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Pet Adoption updated successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }
      )
    } else {
      this.loader.showLoader()
      this.adoptionManagementService.addPetAdoption(body).subscribe((resp) => {
        this.adoptionManagementService.uploadCoverImage(resp['id'], json['coverImage']).subscribe((res) => {
          console.log(res);

        })
        this.adoptionManagementService.uploadImages(resp['id'], json['imagex']).subscribe((res) => {
          console.log(res);
          this.loader.hideLoader()
        }, (error) => {
          this.loader.hideLoader()
        }
        )
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Pet Adoption created successfully!', success: true },
          panelClass: 'success-dialog-container'
        });
        this.router.navigate(['/adoption']);
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }
      )
    }

  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
  handleDeletedImages(images: any[]) {
    // Call your delete image API here
    this.editData['doctorImages'].forEach((image) => {
      if (images.includes(image.value)) {
        console.log("🚀 ~ deletedImageId ~ image:", image)
        this.deletedImages.push(image.key)
      }
    })
  }
  handleUploadedImages(images: { [key: string]: File }) {
    console.log("🚀 ~ handleUploadedImages ~ images:", images)
    this.uploadedImages.push(images)
  }

}
