import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormGroup } from '@angular/forms';

@Component({
  selector: 'app-time-picker-slider',
  templateUrl: './time-picker-slider.component.html',
  styleUrls: ['./time-picker-slider.component.scss']
})
export class TimePickerSliderComponent {
  @Input() form : FormGroup;
  @Input() controller : any;
  @Input() time: number
  @Output() setTime = new EventEmitter<number>()

  hours = 0
  mins = 0

  displayTime = ''

  ngOnInit() {
    this.updateDisplayValuesAndEmitCombined()
  }

  formatHours(value : number) : string {
    let disp = value
    let ampm = 'A'

    if(value > 11) {
      ampm = 'P'
      disp -= 12
    }
    if(disp == 0) {
      disp = 12
    }

    return `${disp}${ampm}`
  }
  
  onHourChange(msc: any) {
    this.hours = msc.value
    this.updateDisplayValuesAndEmitCombined(false)
  }
  
  onMinChange(msc: any) {
    this.mins = msc.value
    this.updateDisplayValuesAndEmitCombined(false)
  }

  private updateDisplayValuesAndEmitCombined(skipEmit = true) {

    let dispHour = this.hours
    let dispMins = String(this.mins)
    let ampm = 'AM'

    if(dispHour > 11) {
      ampm = 'PM'
      dispHour -= 12
    }
    if(dispHour == 0) {
      dispHour = 12
    }
    if(this.mins < 10) {
      dispMins = `0${dispMins}`
    }

    this.displayTime = `${dispHour}:${dispMins} ${ampm}`

    if(!skipEmit) {
      this.setTime.emit(this.hours + (this.mins / 100))
    }
  }
}
