import { NgModule } from '@angular/core';
import {
    CommonModule,
    HashLocationStrategy,
    LocationStrategy,
    PathLocationStrategy,
} from '@angular/common';
// import { BrowserModule, Title } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { HTTP_INTERCEPTORS, HttpClientModule } from '@angular/common/http';
// Import routing module
// Import app component
import { MatDialogModule } from '@angular/material/dialog';
import { AppComponent } from './app.component';
import {
    ErrorStateMatcher,
    ShowOnDirtyErrorStateMatcher,
} from '@angular/material/core';
import { UserManaementModule } from './modules/user-manaement/user-manaement.module';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { DisplayVideoComponent } from './modules/rolls-management/display-video/display-video.component';
import { GenericActionsComponent } from './components/common-components/generic-actions/generic-actions.component';
import { LoaderInterceptor } from './interceptor/loader.interceptor';
import { ControllersModule } from './components/controllers/controllers.module';
import { RouterOutlet } from '@angular/router';
import { BrowserModule } from '@angular/platform-browser';
import { SafeComponent } from './pipe/safe/safe.component';
import { SafePipe } from './pipe/safe.pipe';
import { TruncatePipe } from './pipe/truncate.pipe';

@NgModule({
    declarations: [
        GenericActionsComponent,
        DisplayVideoComponent,
        SafeComponent,
        SafePipe,
        
        TruncatePipe,
    ],
    imports: [
        AppComponent,
        UserManaementModule,
        HttpClientModule,
        BrowserModule,
        MatDialogModule,
        MatSnackBarModule,
        BrowserAnimationsModule,
        ReactiveFormsModule,
        FormsModule,
        ReactiveFormsModule,
        // CommonModule,
    ],
    exports: [],

    bootstrap: [],
})
export class AppModule { }
