import QuillType from 'quill';
import { AfterViewInit, ElementRef, EventEmitter, OnChanges, Renderer2, SimpleChanges, NgZone, OnDestroy, OnInit } from '@angular/core';
import { CustomOption, CustomModule, QuillModules } from 'ngx-quill/config';
import { QuillService } from './quill.service';
import { DomSanitizer } from '@angular/platform-browser';
import * as i0 from "@angular/core";
export declare class QuillViewComponent implements AfterViewInit, OnChanges, OnDestroy, OnInit {
    elementRef: ElementRef;
    protected renderer: Renderer2;
    protected zone: NgZone;
    protected service: QuillService;
    protected domSanitizer: DomSanitizer;
    protected platformId: any;
    format?: 'object' | 'html' | 'text' | 'json';
    theme?: string;
    modules?: QuillModules;
    debug?: 'warn' | 'log' | 'error' | false;
    formats?: string[] | null;
    sanitize?: boolean;
    beforeRender?: () => Promise<void>;
    strict: boolean;
    content: any;
    customModules: CustomModule[];
    customOptions: CustomOption[];
    preserveWhitespace: boolean;
    onEditorCreated: EventEmitter<any>;
    quillEditor: QuillType;
    editorElem: HTMLElement;
    preserve: boolean;
    private quillSubscription;
    constructor(elementRef: ElementRef, renderer: Renderer2, zone: NgZone, service: QuillService, domSanitizer: DomSanitizer, platformId: any);
    valueSetter: (quillEditor: QuillType, value: any) => any;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<QuillViewComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<QuillViewComponent, "quill-view", never, { "format": { "alias": "format"; "required": false; }; "theme": { "alias": "theme"; "required": false; }; "modules": { "alias": "modules"; "required": false; }; "debug": { "alias": "debug"; "required": false; }; "formats": { "alias": "formats"; "required": false; }; "sanitize": { "alias": "sanitize"; "required": false; }; "beforeRender": { "alias": "beforeRender"; "required": false; }; "strict": { "alias": "strict"; "required": false; }; "content": { "alias": "content"; "required": false; }; "customModules": { "alias": "customModules"; "required": false; }; "customOptions": { "alias": "customOptions"; "required": false; }; "preserveWhitespace": { "alias": "preserveWhitespace"; "required": false; }; }, { "onEditorCreated": "onEditorCreated"; }, never, never, true, never>;
}
